/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.view.TabbedPanel;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.view.TabbedPanelTab;

public class TabbedPanel2
extends TabbedPanel {
    private static final long serialVersionUID = 1L;
    private List<Component> fullTabList = new ArrayList<Component>();
    private List<Component> removedTabList = new ArrayList<Component>();
    private static final Icon PLUS_ICON = new ImageIcon(TabbedPanel2.class.getResource("/resource/icon/fugue/plus.png"));
    private Component hiddenComponent = new JLabel();
    private final Logger logger = Logger.getLogger(TabbedPanel2.class);
    private int prevTabIndex = -1;

    public TabbedPanel2() {
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TabbedPanel2.this.setCloseButtonStates();
                if (TabbedPanel2.this.getSelectedComponent() != null && TabbedPanel2.this.getSelectedComponent().equals(TabbedPanel2.this.hiddenComponent)) {
                    if (TabbedPanel2.this.prevTabIndex == TabbedPanel2.this.indexOfComponent(TabbedPanel2.this.hiddenComponent)) {
                        TabbedPanel2.this.setSelectedIndex(TabbedPanel2.this.prevTabIndex - 1);
                    } else {
                        TabbedPanel2.this.setSelectedIndex(TabbedPanel2.this.prevTabIndex);
                        TabbedPanel2.this.showHiddenTabPopup();
                    }
                } else {
                    TabbedPanel2.this.prevTabIndex = TabbedPanel2.this.getSelectedIndex();
                }
            }
        });
    }

    private void showHiddenTabPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (this.getMousePosition() == null) {
            return;
        }
        Collections.sort(this.removedTabList, new Comparator<Component>(){

            @Override
            public int compare(Component component, Component component2) {
                return component.getName().compareTo(component2.getName());
            }
        });
        for (Component component : this.removedTabList) {
            if (!(component instanceof AbstractPanel)) continue;
            final AbstractPanel abstractPanel = (AbstractPanel)component;
            JMenuItem jMenuItem = new JMenuItem(abstractPanel.getName());
            jMenuItem.setIcon(abstractPanel.getIcon());
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TabbedPanel2.this.setVisible(abstractPanel, true);
                    abstractPanel.setTabFocus();
                }
            });
            jPopupMenu.add(jMenuItem);
        }
        jPopupMenu.show(this, this.getMousePosition().x, this.getMousePosition().y);
    }

    @Deprecated
    public TabbedPanel2 clone(TabbedPanel2 tabbedPanel2) {
        TabbedPanel2 tabbedPanel22 = new TabbedPanel2();
        tabbedPanel22.fullTabList = new ArrayList<Component>(tabbedPanel2.fullTabList);
        tabbedPanel22.removedTabList = new ArrayList<Component>(tabbedPanel2.removedTabList);
        return tabbedPanel22;
    }

    private void setCloseButtonStates() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            Component component = this.getTabComponentAt(i);
            if (component == null || !(component instanceof TabbedPanelTab)) continue;
            TabbedPanelTab tabbedPanelTab = (TabbedPanelTab)component;
            tabbedPanelTab.setEnabled(i == this.getSelectedIndex());
        }
    }

    public void pinVisibleTabs() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            Component component = this.getTabComponentAt(i);
            if (component == null || !(component instanceof TabbedPanelTab) || !component.isVisible()) continue;
            TabbedPanelTab tabbedPanelTab = (TabbedPanelTab)component;
            tabbedPanelTab.setPinned(true);
            this.saveTabState(tabbedPanelTab.getAbstractPanel());
        }
    }

    public void unpinTabs() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            Component component = this.getTabComponentAt(i);
            if (component == null || !(component instanceof TabbedPanelTab) || !component.isVisible()) continue;
            TabbedPanelTab tabbedPanelTab = (TabbedPanelTab)component;
            tabbedPanelTab.setPinned(false);
            this.saveTabState(tabbedPanelTab.getAbstractPanel());
        }
    }

    private String safeName(String string) {
        return string.replaceAll("[^A-Za-z0-9]", "");
    }

    private boolean isTabPinned(Component component) {
        boolean bl = false;
        if (component instanceof AbstractPanel) {
            bl = ((AbstractPanel)component).isShowByDefault();
        }
        return Model.getSingleton().getOptionsParam().getConfig().getBoolean("view.tab.pin." + this.safeName(component.getName()), bl);
    }

    protected void saveTabState(AbstractPanel abstractPanel) {
        if (abstractPanel == null) {
            return;
        }
        Model.getSingleton().getOptionsParam().getConfig().setProperty("view.tab.pin." + this.safeName(abstractPanel.getName()), (Object)abstractPanel.isPinned());
        try {
            Model.getSingleton().getOptionsParam().getConfig().save();
        }
        catch (ConfigurationException configurationException) {
            this.logger.error((Object)configurationException.getMessage(), (Throwable)configurationException);
        }
    }

    public boolean isTabVisible(Component component) {
        if (!this.fullTabList.contains(component)) {
            return false;
        }
        return !this.removedTabList.contains(component);
    }

    public void setVisible(Component component, boolean bl) {
        if (bl) {
            if (this.removedTabList.contains(component)) {
                if (component instanceof AbstractPanel) {
                    AbstractPanel abstractPanel = (AbstractPanel)component;
                    this.addTab(component.getName(), abstractPanel.getIcon(), abstractPanel, abstractPanel.isHideable(), true, abstractPanel.getTabIndex());
                } else {
                    int n;
                    for (n = this.fullTabList.indexOf(component); n >= 0 && (n <= 0 || this.removedTabList.contains(this.fullTabList.get(n - 1))); --n) {
                    }
                    this.addTab(component.getName(), null, component, true, true, n);
                }
                this.removedTabList.remove(component);
            }
        } else if (!this.removedTabList.contains(component)) {
            this.remove(component);
            this.removedTabList.add(component);
        }
        this.handleHiddenTabListTab();
    }

    @Override
    public void addTab(String string, Icon icon, Component component) {
        if (component instanceof AbstractPanel) {
            this.addTab((AbstractPanel)component);
        } else {
            this.addTab(string, icon, component, false, true, this.getTabCount());
        }
    }

    public void addTab(AbstractPanel abstractPanel) {
        boolean bl = !abstractPanel.isHideable() || this.isTabPinned(abstractPanel);
        this.addTab(abstractPanel.getName(), abstractPanel.getIcon(), abstractPanel, abstractPanel.isHideable(), bl, abstractPanel.getTabIndex());
    }

    public void addTab(String string, Icon icon, Component component, boolean bl, boolean bl2, int n) {
        if (component instanceof AbstractPanel) {
            ((AbstractPanel)component).setParent(this);
            ((AbstractPanel)component).setTabIndex(n);
            ((AbstractPanel)component).setHideable(bl);
        }
        if (n == -1 || n > this.getTabCount()) {
            n = this.getTabCount();
        }
        if (icon instanceof ImageIcon) {
            icon = DisplayUtils.getScaledIcon((ImageIcon)icon);
        }
        super.insertTab(string, icon, component, component.getName(), n);
        if (!this.fullTabList.contains(component)) {
            this.fullTabList.add(component);
        }
        int n2 = this.indexOfComponent(component);
        this.setTabComponentAt(n2, new TabbedPanelTab(this, string, icon, component, bl, this.isTabPinned(component)));
        if (!bl2) {
            this.setVisible(component, false);
        } else {
            this.removedTabList.remove(component);
        }
        this.handleHiddenTabListTab();
        if ((n == 0 || this.getTabCount() == 1) && this.indexOfComponent(component) != -1) {
            this.setSelectedComponent(component);
        }
    }

    private void handleHiddenTabListTab() {
        if (this.indexOfComponent(this.hiddenComponent) >= 0) {
            super.remove(this.hiddenComponent);
        }
        if (this.removedTabList.size() > 0) {
            super.addTab("", PLUS_ICON, this.hiddenComponent);
        }
    }

    public void setTabLocked(AbstractPanel abstractPanel, boolean bl) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            TabbedPanelTab tabbedPanelTab;
            Component component = this.getTabComponentAt(i);
            if (component == null || !(component instanceof TabbedPanelTab) || !component.isVisible() || !abstractPanel.equals((tabbedPanelTab = (TabbedPanelTab)component).getAbstractPanel())) continue;
            tabbedPanelTab.setLocked(!bl);
        }
    }

    @Override
    public void setIconAt(int n, Icon icon) {
        Component component;
        Component component2 = this.getTabComponentAt(n);
        if (component2 != null && component2 instanceof JPanel && (component = ((JPanel)component2).getComponent(0)) != null && component instanceof JLabel) {
            ((JLabel)component).setIcon(icon);
        }
    }

    @Override
    public void setTitleAt(int n, String string) {
        Component component = this.getTabComponentAt(n);
        if (component != null && component instanceof JPanel) {
            Component component2 = ((JPanel)component).getComponent(0);
            if (component2 != null && component2 instanceof JLabel) {
                ((JLabel)component2).setText(string);
            }
        } else {
            super.setTitleAt(n, string);
        }
    }

    public List<Component> getTabList() {
        return Collections.unmodifiableList(this.fullTabList);
    }

    public List<Component> getSortedTabList() {
        ArrayList<Component> arrayList = new ArrayList<Component>(this.fullTabList);
        Collections.sort(arrayList, new Comparator<Component>(){

            @Override
            public int compare(Component component, Component component2) {
                return component.getName().compareTo(component2.getName());
            }
        });
        return arrayList;
    }

    public void removeTab(AbstractPanel abstractPanel) {
        this.remove(abstractPanel);
        this.fullTabList.remove(abstractPanel);
        if (this.removedTabList.remove(abstractPanel)) {
            this.handleHiddenTabListTab();
        }
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.removedTabList.clear();
        this.removedTabList.addAll(this.fullTabList);
        this.handleHiddenTabListTab();
    }

    public void setShowTabNames(boolean bl) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            String string = bl ? this.getComponentAt(i).getName() : "";
            this.setTitleAt(i, string);
        }
    }

    @Override
    protected void fireStateChanged() {
        super.fireStateChanged();
        Component component = this.getSelectedComponent();
        if (component instanceof AbstractPanel) {
            ((AbstractPanel)component).tabSelected();
        }
    }

    public boolean isActive() {
        return false;
    }

    public List<AbstractPanel> getPanels() {
        ArrayList<AbstractPanel> arrayList = new ArrayList<AbstractPanel>();
        for (Component component : this.fullTabList) {
            if (!(component instanceof AbstractPanel)) continue;
            arrayList.add((AbstractPanel)component);
        }
        return arrayList;
    }

    public List<AbstractPanel> getVisiblePanels() {
        List<AbstractPanel> list = this.getPanels();
        Iterator<AbstractPanel> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (!this.removedTabList.contains(iterator.next())) continue;
            iterator.remove();
        }
        return list;
    }

    public void setVisiblePanels(List<AbstractPanel> list) {
        this.removeAll();
        for (Component component : this.fullTabList) {
            AbstractPanel abstractPanel;
            if (list.contains(component)) {
                this.setVisible(component, true);
                continue;
            }
            if (!(component instanceof AbstractPanel) || TabbedPanel2.canHidePanel(abstractPanel = (AbstractPanel)component)) continue;
            this.setVisible(component, true);
        }
        if (this.getSelectedComponent() == null && this.getTabCount() > 0) {
            this.setSelectedIndex(0);
        }
    }

    public void setPanelsVisible(boolean bl) {
        for (Component component : this.fullTabList) {
            if (!(component instanceof AbstractPanel)) continue;
            AbstractPanel abstractPanel = (AbstractPanel)component;
            boolean bl2 = true;
            if (!bl) {
                bl2 = TabbedPanel2.canHidePanel(abstractPanel);
            }
            if (!bl2) continue;
            this.setVisible(component, bl);
        }
    }

    private static boolean canHidePanel(AbstractPanel abstractPanel) {
        return abstractPanel.isHideable() && !abstractPanel.isPinned();
    }
}

