/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.shards;

import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.cluster.shards.ClusterSearchShardsGroup;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class ClusterSearchShardsResponse
extends ActionResponse
implements ToXContent {
    private ClusterSearchShardsGroup[] groups;
    private DiscoveryNode[] nodes;

    ClusterSearchShardsResponse() {
    }

    public ClusterSearchShardsGroup[] getGroups() {
        return this.groups;
    }

    public DiscoveryNode[] getNodes() {
        return this.nodes;
    }

    public ClusterSearchShardsResponse(ClusterSearchShardsGroup[] groups, DiscoveryNode[] nodes) {
        this.groups = groups;
        this.nodes = nodes;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int i;
        super.readFrom(in);
        this.groups = new ClusterSearchShardsGroup[in.readVInt()];
        for (i = 0; i < this.groups.length; ++i) {
            this.groups[i] = ClusterSearchShardsGroup.readSearchShardsGroupResponse(in);
        }
        this.nodes = new DiscoveryNode[in.readVInt()];
        for (i = 0; i < this.nodes.length; ++i) {
            this.nodes[i] = new DiscoveryNode(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.groups.length);
        for (ClusterSearchShardsGroup clusterSearchShardsGroup : this.groups) {
            clusterSearchShardsGroup.writeTo(out);
        }
        out.writeVInt(this.nodes.length);
        for (ToXContent toXContent : this.nodes) {
            ((DiscoveryNode)toXContent).writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("nodes");
        for (DiscoveryNode discoveryNode : this.nodes) {
            discoveryNode.toXContent(builder, params);
        }
        builder.endObject();
        builder.startArray("shards");
        for (ToXContent toXContent : this.groups) {
            ((ClusterSearchShardsGroup)toXContent).toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }
}

