/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.cache.clear;

import java.io.IOException;
import org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ClearIndicesCacheRequest
extends BroadcastRequest<ClearIndicesCacheRequest> {
    private boolean queryCache = false;
    private boolean fieldDataCache = false;
    private boolean recycler = false;
    private boolean requestCache = false;
    private String[] fields = null;

    public ClearIndicesCacheRequest() {
    }

    public ClearIndicesCacheRequest(String ... indices) {
        super(indices);
    }

    public boolean queryCache() {
        return this.queryCache;
    }

    public ClearIndicesCacheRequest queryCache(boolean queryCache) {
        this.queryCache = queryCache;
        return this;
    }

    public boolean requestCache() {
        return this.requestCache;
    }

    public ClearIndicesCacheRequest requestCache(boolean requestCache) {
        this.requestCache = requestCache;
        return this;
    }

    public boolean fieldDataCache() {
        return this.fieldDataCache;
    }

    public ClearIndicesCacheRequest fieldDataCache(boolean fieldDataCache) {
        this.fieldDataCache = fieldDataCache;
        return this;
    }

    public ClearIndicesCacheRequest fields(String ... fields) {
        this.fields = fields;
        return this;
    }

    public String[] fields() {
        return this.fields;
    }

    public ClearIndicesCacheRequest recycler(boolean recycler) {
        this.recycler = recycler;
        return this;
    }

    public boolean recycler() {
        return this.recycler;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.queryCache = in.readBoolean();
        this.fieldDataCache = in.readBoolean();
        this.recycler = in.readBoolean();
        this.fields = in.readStringArray();
        this.requestCache = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.queryCache);
        out.writeBoolean(this.fieldDataCache);
        out.writeBoolean(this.recycler);
        out.writeStringArrayNullable(this.fields);
        out.writeBoolean(this.requestCache);
    }
}

