/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.AbstractSearchAsyncAction;
import org.elasticsearch.action.search.SearchDfsQueryAndFetchAsyncAction;
import org.elasticsearch.action.search.SearchDfsQueryThenFetchAsyncAction;
import org.elasticsearch.action.search.SearchPhaseController;
import org.elasticsearch.action.search.SearchQueryAndFetchAsyncAction;
import org.elasticsearch.action.search.SearchQueryThenFetchAsyncAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.indices.IndexClosedException;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportSearchAction
extends HandledTransportAction<SearchRequest, SearchResponse> {
    public static final Setting<Long> SHARD_COUNT_LIMIT_SETTING = Setting.longSetting("action.search.shard_count.limit", 1000L, 1L, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private final ClusterService clusterService;
    private final SearchTransportService searchTransportService;
    private final SearchPhaseController searchPhaseController;

    @Inject
    public TransportSearchAction(Settings settings, ThreadPool threadPool, BigArrays bigArrays, ScriptService scriptService, TransportService transportService, SearchService searchService, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "indices:data/read/search", threadPool, transportService, actionFilters, indexNameExpressionResolver, SearchRequest::new);
        this.searchPhaseController = new SearchPhaseController(settings, bigArrays, scriptService, clusterService);
        this.searchTransportService = new SearchTransportService(settings, transportService);
        SearchTransportService.registerRequestHandler(transportService, searchService);
        this.clusterService = clusterService;
    }

    @Override
    protected void doExecute(SearchRequest searchRequest, ActionListener<SearchResponse> listener) {
        try {
            ClusterState clusterState = this.clusterService.state();
            String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(clusterState, searchRequest);
            Map<String, Set<String>> routingMap = this.indexNameExpressionResolver.resolveSearchRouting(clusterState, searchRequest.routing(), searchRequest.indices());
            int shardCount = this.clusterService.operationRouting().searchShardsCount(clusterState, concreteIndices, routingMap);
            if (shardCount == 1) {
                searchRequest.searchType(SearchType.QUERY_AND_FETCH);
            }
            if (searchRequest.isSuggestOnly()) {
                searchRequest.requestCache(false);
                switch (searchRequest.searchType()) {
                    case DFS_QUERY_AND_FETCH: 
                    case DFS_QUERY_THEN_FETCH: {
                        searchRequest.searchType(SearchType.QUERY_THEN_FETCH);
                    }
                }
            }
        }
        catch (IndexNotFoundException | IndexClosedException clusterState) {
        }
        catch (Exception e) {
            this.logger.debug("failed to optimize search type, continue as normal", (Throwable)e);
        }
        this.searchAsyncAction(searchRequest, listener).start();
    }

    private AbstractSearchAsyncAction searchAsyncAction(SearchRequest searchRequest, ActionListener<SearchResponse> listener) {
        AbstractSearchAsyncAction searchAsyncAction;
        switch (searchRequest.searchType()) {
            case DFS_QUERY_THEN_FETCH: {
                searchAsyncAction = new SearchDfsQueryThenFetchAsyncAction(this.logger, this.searchTransportService, this.clusterService, this.indexNameExpressionResolver, this.searchPhaseController, this.threadPool, searchRequest, listener);
                break;
            }
            case QUERY_THEN_FETCH: {
                searchAsyncAction = new SearchQueryThenFetchAsyncAction(this.logger, this.searchTransportService, this.clusterService, this.indexNameExpressionResolver, this.searchPhaseController, this.threadPool, searchRequest, listener);
                break;
            }
            case DFS_QUERY_AND_FETCH: {
                searchAsyncAction = new SearchDfsQueryAndFetchAsyncAction(this.logger, this.searchTransportService, this.clusterService, this.indexNameExpressionResolver, this.searchPhaseController, this.threadPool, searchRequest, listener);
                break;
            }
            case QUERY_AND_FETCH: {
                searchAsyncAction = new SearchQueryAndFetchAsyncAction(this.logger, this.searchTransportService, this.clusterService, this.indexNameExpressionResolver, this.searchPhaseController, this.threadPool, searchRequest, listener);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown search type: [" + (Object)((Object)searchRequest.searchType()) + "]");
            }
        }
        return searchAsyncAction;
    }
}

