/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.node.AStoreable;

public final class EVariable
extends AStoreable {
    private final String name;
    private Locals.Variable variable = null;

    public EVariable(Location location, String name) {
        super(location);
        this.name = Objects.requireNonNull(name);
    }

    @Override
    void extractVariables(Set<String> variables) {
        variables.add(this.name);
    }

    @Override
    void analyze(Locals locals) {
        this.variable = locals.getVariable(this.location, this.name);
        if (this.write && this.variable.readonly) {
            throw this.createError(new IllegalArgumentException("Variable [" + this.variable.name + "] is read-only."));
        }
        this.actual = this.variable.type;
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        writer.visitVarInsn(this.actual.type.getOpcode(21), this.variable.getSlot());
    }

    @Override
    int accessElementCount() {
        return 0;
    }

    @Override
    boolean isDefOptimized() {
        return false;
    }

    @Override
    void updateActual(Definition.Type actual) {
        throw new IllegalArgumentException("Illegal tree structure.");
    }

    @Override
    void setup(MethodWriter writer, Globals globals) {
    }

    @Override
    void load(MethodWriter writer, Globals globals) {
        writer.visitVarInsn(this.actual.type.getOpcode(21), this.variable.getSlot());
    }

    @Override
    void store(MethodWriter writer, Globals globals) {
        writer.visitVarInsn(this.actual.type.getOpcode(54), this.variable.getSlot());
    }
}

