/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.Constant;
import org.elasticsearch.painless.Def;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.painless.node.AStatement;
import org.elasticsearch.painless.node.SSource;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.commons.Method;

public final class SFunction
extends AStatement {
    final FunctionReserved reserved;
    private final String rtnTypeStr;
    public final String name;
    private final List<String> paramTypeStrs;
    private final List<String> paramNameStrs;
    private final List<AStatement> statements;
    public final boolean synthetic;
    Definition.Type rtnType = null;
    List<Locals.Parameter> parameters = new ArrayList<Locals.Parameter>();
    Definition.Method method = null;
    private Locals.Variable loop = null;

    public SFunction(FunctionReserved reserved, Location location, String rtnType, String name, List<String> paramTypes, List<String> paramNames, List<AStatement> statements, boolean synthetic) {
        super(location);
        this.reserved = Objects.requireNonNull(reserved);
        this.rtnTypeStr = Objects.requireNonNull(rtnType);
        this.name = Objects.requireNonNull(name);
        this.paramTypeStrs = Collections.unmodifiableList(paramTypes);
        this.paramNameStrs = Collections.unmodifiableList(paramNames);
        this.statements = Collections.unmodifiableList(statements);
        this.synthetic = synthetic;
    }

    @Override
    void extractVariables(Set<String> variables) {
        throw new IllegalStateException("Illegal tree structure");
    }

    void generateSignature() {
        try {
            this.rtnType = Definition.getType(this.rtnTypeStr);
        }
        catch (IllegalArgumentException exception) {
            throw this.createError(new IllegalArgumentException("Illegal return type [" + this.rtnTypeStr + "] for function [" + this.name + "]."));
        }
        if (this.paramTypeStrs.size() != this.paramNameStrs.size()) {
            throw this.createError(new IllegalStateException("Illegal tree structure."));
        }
        Class[] paramClasses = new Class[this.paramTypeStrs.size()];
        ArrayList<Definition.Type> paramTypes = new ArrayList<Definition.Type>();
        for (int param = 0; param < this.paramTypeStrs.size(); ++param) {
            try {
                Definition.Type paramType = Definition.getType(this.paramTypeStrs.get(param));
                paramClasses[param] = paramType.clazz;
                paramTypes.add(paramType);
                this.parameters.add(new Locals.Parameter(this.location, this.paramNameStrs.get(param), paramType));
                continue;
            }
            catch (IllegalArgumentException exception) {
                throw this.createError(new IllegalArgumentException("Illegal parameter type [" + this.paramTypeStrs.get(param) + "] for function [" + this.name + "]."));
            }
        }
        Method method = new Method(this.name, MethodType.methodType(this.rtnType.clazz, paramClasses).toMethodDescriptorString());
        this.method = new Definition.Method(this.name, null, false, this.rtnType, paramTypes, method, 10, null);
    }

    @Override
    void analyze(Locals locals) {
        if (this.statements == null || this.statements.isEmpty()) {
            throw this.createError(new IllegalArgumentException("Cannot generate an empty function [" + this.name + "]."));
        }
        locals = Locals.newLocalScope(locals);
        AStatement last = this.statements.get(this.statements.size() - 1);
        for (AStatement statement : this.statements) {
            if (this.allEscape) {
                throw this.createError(new IllegalArgumentException("Unreachable statement."));
            }
            statement.lastSource = statement == last;
            statement.analyze(locals);
            this.methodEscape = statement.methodEscape;
            this.allEscape = statement.allEscape;
        }
        if (!this.methodEscape && this.rtnType.sort != Definition.Sort.VOID) {
            throw this.createError(new IllegalArgumentException("Not all paths provide a return value for method [" + this.name + "]."));
        }
        if (this.reserved.getMaxLoopCounter() > 0) {
            this.loop = locals.getVariable(null, "#loop");
        }
    }

    void write(ClassVisitor writer, CompilerSettings settings, Globals globals) {
        int access = 10;
        if (this.synthetic) {
            access |= 0x1000;
        }
        MethodWriter function = new MethodWriter(access, this.method.method, writer, globals.getStatements(), settings);
        function.visitCode();
        this.write(function, globals);
        function.endMethod();
    }

    @Override
    void write(MethodWriter function, Globals globals) {
        if (this.reserved.getMaxLoopCounter() > 0) {
            function.push(this.reserved.getMaxLoopCounter());
            function.visitVarInsn(54, this.loop.getSlot());
        }
        for (AStatement statement : this.statements) {
            statement.write(function, globals);
        }
        if (!this.methodEscape) {
            if (this.rtnType.sort == Definition.Sort.VOID) {
                function.returnValue();
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
        String staticHandleFieldName = Def.getUserFunctionHandleFieldName(this.name, this.parameters.size());
        globals.addConstantInitializer(new Constant(this.location, WriterConstants.METHOD_HANDLE_TYPE, staticHandleFieldName, this::initializeConstant));
    }

    private void initializeConstant(MethodWriter writer) {
        Handle handle = new Handle(6, WriterConstants.CLASS_TYPE.getInternalName(), this.name, this.method.method.getDescriptor(), false);
        writer.push(handle);
    }

    public static final class FunctionReserved
    implements SSource.Reserved {
        private int maxLoopCounter = 0;

        @Override
        public void markReserved(String name) {
        }

        @Override
        public boolean isReserved(String name) {
            return Locals.FUNCTION_KEYWORDS.contains(name);
        }

        @Override
        public void setMaxLoopCounter(int max) {
            this.maxLoopCounter = max;
        }

        @Override
        public int getMaxLoopCounter() {
            return this.maxLoopCounter;
        }
    }
}

