/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.expressions;

import java.io.IOException;
import org.apache.lucene.expressions.ExpressionComparator;
import org.apache.lucene.expressions.ExpressionValueSource;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.SortField;

class ExpressionSortField
extends SortField {
    private final ExpressionValueSource source;

    ExpressionSortField(String name, ExpressionValueSource source, boolean reverse) {
        super(name, SortField.Type.CUSTOM, reverse);
        this.source = source;
    }

    public FieldComparator<?> getComparator(int numHits, int sortPos) throws IOException {
        return new ExpressionComparator(this.source, numHits);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ExpressionSortField other = (ExpressionSortField)((Object)obj);
        return !(this.source == null ? other.source != null : !this.source.equals((Object)other.source));
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<expr \"");
        buffer.append(this.getField());
        buffer.append("\">");
        if (this.getReverse()) {
            buffer.append('!');
        }
        return buffer.toString();
    }

    public boolean needsScores() {
        return this.source.needsScores();
    }
}

