/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.multibindings.Multibinder;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.ExtensionPoint;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.local.LocalDiscovery;
import org.elasticsearch.discovery.zen.ElectMasterService;
import org.elasticsearch.discovery.zen.ZenDiscovery;
import org.elasticsearch.discovery.zen.ping.ZenPing;
import org.elasticsearch.discovery.zen.ping.ZenPingService;
import org.elasticsearch.discovery.zen.ping.unicast.UnicastHostsProvider;
import org.elasticsearch.discovery.zen.ping.unicast.UnicastZenPing;

public class DiscoveryModule
extends AbstractModule {
    public static final Setting<String> DISCOVERY_TYPE_SETTING = new Setting("discovery.type", "zen", Function.identity(), Setting.Property.NodeScope);
    public static final Setting<String> ZEN_MASTER_SERVICE_TYPE_SETTING = new Setting("discovery.zen.masterservice.type", "zen", Function.identity(), Setting.Property.NodeScope);
    private final Settings settings;
    private final Map<String, List<Class<? extends UnicastHostsProvider>>> unicastHostProviders = new HashMap<String, List<Class<? extends UnicastHostsProvider>>>();
    private final ExtensionPoint.ClassSet<ZenPing> zenPings = new ExtensionPoint.ClassSet<ZenPing>("zen_ping", ZenPing.class, (Class<?>[])new Class[0]);
    private final Map<String, Class<? extends Discovery>> discoveryTypes = new HashMap<String, Class<? extends Discovery>>();
    private final Map<String, Class<? extends ElectMasterService>> masterServiceType = new HashMap<String, Class<? extends ElectMasterService>>();

    public DiscoveryModule(Settings settings) {
        this.settings = settings;
        this.addDiscoveryType("local", LocalDiscovery.class);
        this.addDiscoveryType("zen", ZenDiscovery.class);
        this.addElectMasterService("zen", ElectMasterService.class);
        this.addZenPing(UnicastZenPing.class);
    }

    public void addUnicastHostProvider(String type, Class<? extends UnicastHostsProvider> unicastHostProvider) {
        List<Class<? extends UnicastHostsProvider>> providerList = this.unicastHostProviders.get(type);
        if (providerList == null) {
            providerList = new ArrayList<Class<? extends UnicastHostsProvider>>();
            this.unicastHostProviders.put(type, providerList);
        }
        providerList.add(unicastHostProvider);
    }

    public void addDiscoveryType(String type, Class<? extends Discovery> clazz) {
        if (this.discoveryTypes.containsKey(type)) {
            throw new IllegalArgumentException("discovery type [" + type + "] is already registered");
        }
        this.discoveryTypes.put(type, clazz);
    }

    public void addElectMasterService(String type, Class<? extends ElectMasterService> masterService) {
        if (this.masterServiceType.containsKey(type)) {
            throw new IllegalArgumentException("master service type [" + type + "] is already registered");
        }
        this.masterServiceType.put(type, masterService);
    }

    public void addZenPing(Class<? extends ZenPing> clazz) {
        this.zenPings.registerExtension(clazz);
    }

    @Override
    protected void configure() {
        String discoveryType = DISCOVERY_TYPE_SETTING.get(this.settings);
        Class<? extends Discovery> discoveryClass = this.discoveryTypes.get(discoveryType);
        if (discoveryClass == null) {
            throw new IllegalArgumentException("Unknown Discovery type [" + discoveryType + "]");
        }
        if (!discoveryType.equals("local")) {
            String masterServiceTypeKey = ZEN_MASTER_SERVICE_TYPE_SETTING.get(this.settings);
            Class<? extends ElectMasterService> masterService = this.masterServiceType.get(masterServiceTypeKey);
            if (masterService == null) {
                throw new IllegalArgumentException("Unknown master service type [" + masterServiceTypeKey + "]");
            }
            if (masterService == ElectMasterService.class) {
                this.bind(ElectMasterService.class).asEagerSingleton();
            } else {
                this.bind(ElectMasterService.class).to(masterService).asEagerSingleton();
            }
            this.bind(ZenPingService.class).asEagerSingleton();
            Multibinder<UnicastHostsProvider> unicastHostsProviderMultibinder = Multibinder.newSetBinder(this.binder(), UnicastHostsProvider.class);
            for (Class unicastHostProvider : this.unicastHostProviders.getOrDefault(discoveryType, Collections.emptyList())) {
                unicastHostsProviderMultibinder.addBinding().to(unicastHostProvider);
            }
            this.zenPings.bind(this.binder());
        }
        this.bind(Discovery.class).to(discoveryClass).asEagerSingleton();
    }
}

