/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.aggregations.support.XContentParseContext;
import org.joda.time.DateTimeZone;

public abstract class AbstractValuesSourceParser<VS extends ValuesSource>
implements Aggregator.Parser {
    static final ParseField TIME_ZONE = new ParseField("time_zone", new String[0]);
    private boolean scriptable = true;
    private boolean formattable = false;
    private boolean timezoneAware = false;
    private ValuesSourceType valuesSourceType = null;
    private ValueType targetValueType = null;

    private AbstractValuesSourceParser(boolean scriptable, boolean formattable, boolean timezoneAware, ValuesSourceType valuesSourceType, ValueType targetValueType) {
        this.timezoneAware = timezoneAware;
        this.valuesSourceType = valuesSourceType;
        this.targetValueType = targetValueType;
        this.scriptable = scriptable;
        this.formattable = formattable;
    }

    @Override
    public final ValuesSourceAggregationBuilder<VS, ?> parse(String aggregationName, QueryParseContext context) throws IOException {
        XContentParser.Token token;
        XContentParser parser = context.parser();
        String field = null;
        Script script = null;
        ValueType valueType = null;
        String format = null;
        Object missing = null;
        DateTimeZone timezone = null;
        HashMap<ParseField, Object> otherOptions = new HashMap<ParseField, Object>();
        XContentParseContext parserContext = new XContentParseContext(parser, context.getParseFieldMatcher(), context.getDefaultScriptLanguage());
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if ("missing".equals(currentFieldName) && token.isValue()) {
                missing = parser.objectText();
                continue;
            }
            if (this.timezoneAware && context.getParseFieldMatcher().match(currentFieldName, TIME_ZONE)) {
                if (token == XContentParser.Token.VALUE_STRING) {
                    timezone = DateTimeZone.forID((String)parser.text());
                    continue;
                }
                if (token == XContentParser.Token.VALUE_NUMBER) {
                    timezone = DateTimeZone.forOffsetHours((int)parser.intValue());
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + (Object)((Object)token) + " [" + currentFieldName + "] in [" + aggregationName + "].", new Object[0]);
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if ("field".equals(currentFieldName)) {
                    field = parser.text();
                    continue;
                }
                if (this.formattable && "format".equals(currentFieldName)) {
                    format = parser.text();
                    continue;
                }
                if (this.scriptable) {
                    if ("value_type".equals(currentFieldName) || "valueType".equals(currentFieldName)) {
                        valueType = ValueType.resolveForScript(parser.text());
                        if (this.targetValueType == null || !valueType.isNotA(this.targetValueType)) continue;
                        throw new ParsingException(parser.getTokenLocation(), "Aggregation [" + aggregationName + "] was configured with an incompatible value type [" + valueType + "]. It can only work on value of type [" + this.targetValueType + "]", new Object[0]);
                    }
                    if (this.token(aggregationName, currentFieldName, token, parserContext, otherOptions)) continue;
                    throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + (Object)((Object)token) + " [" + currentFieldName + "] in [" + aggregationName + "].", new Object[0]);
                }
                if (this.token(aggregationName, currentFieldName, token, parserContext, otherOptions)) continue;
                throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + (Object)((Object)token) + " [" + currentFieldName + "] in [" + aggregationName + "].", new Object[0]);
            }
            if (this.scriptable && token == XContentParser.Token.START_OBJECT) {
                if (context.getParseFieldMatcher().match(currentFieldName, Script.ScriptField.SCRIPT)) {
                    script = Script.parse(parser, context.getParseFieldMatcher(), context.getDefaultScriptLanguage());
                    continue;
                }
                if (this.token(aggregationName, currentFieldName, token, parserContext, otherOptions)) continue;
                throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + (Object)((Object)token) + " [" + currentFieldName + "] in [" + aggregationName + "].", new Object[0]);
            }
            if (this.token(aggregationName, currentFieldName, token, parserContext, otherOptions)) continue;
            throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + (Object)((Object)token) + " [" + currentFieldName + "] in [" + aggregationName + "].", new Object[0]);
        }
        ValuesSourceAggregationBuilder<VS, ?> factory = this.createFactory(aggregationName, this.valuesSourceType, this.targetValueType, otherOptions);
        if (field != null) {
            factory.field(field);
        }
        if (script != null) {
            factory.script(script);
        }
        if (valueType != null) {
            factory.valueType(valueType);
        }
        if (format != null) {
            factory.format(format);
        }
        if (missing != null) {
            factory.missing(missing);
        }
        if (timezone != null) {
            factory.timeZone(timezone);
        }
        return factory;
    }

    protected abstract ValuesSourceAggregationBuilder<VS, ?> createFactory(String var1, ValuesSourceType var2, ValueType var3, Map<ParseField, Object> var4);

    protected abstract boolean token(String var1, String var2, XContentParser.Token var3, XContentParseContext var4, Map<ParseField, Object> var5) throws IOException;

    public static abstract class GeoPointValuesSourceParser
    extends AbstractValuesSourceParser<ValuesSource.GeoPoint> {
        protected GeoPointValuesSourceParser(boolean scriptable, boolean formattable) {
            super(scriptable, formattable, false, ValuesSourceType.GEOPOINT, ValueType.GEOPOINT);
        }
    }

    public static abstract class BytesValuesSourceParser
    extends AbstractValuesSourceParser<ValuesSource.Bytes> {
        protected BytesValuesSourceParser(boolean scriptable, boolean formattable) {
            super(scriptable, formattable, false, ValuesSourceType.BYTES, ValueType.STRING);
        }
    }

    public static abstract class NumericValuesSourceParser
    extends AbstractValuesSourceParser<ValuesSource.Numeric> {
        protected NumericValuesSourceParser(boolean scriptable, boolean formattable, boolean timezoneAware) {
            super(scriptable, formattable, timezoneAware, ValuesSourceType.NUMERIC, ValueType.NUMERIC);
        }
    }

    public static abstract class AnyValuesSourceParser
    extends AbstractValuesSourceParser<ValuesSource> {
        protected AnyValuesSourceParser(boolean scriptable, boolean formattable) {
            super(scriptable, formattable, false, ValuesSourceType.ANY, null);
        }
    }
}

