/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.collection.CompositeCollection;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.DelegatingDomainObjectSet;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Actions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeDomainObjectSet<T>
extends DelegatingDomainObjectSet<T> {
    private final Spec<T> uniqueSpec = new ItemIsUniqueInCompositeSpec();
    private final Spec<T> notInSpec = new ItemNotInCompositeSpec();
    private final DefaultDomainObjectSet<T> backingSet;

    public static <T> CompositeDomainObjectSet<T> create(Class<T> type, DomainObjectCollection<? extends T> ... collections) {
        DefaultDomainObjectSet<T> backingSet = new DefaultDomainObjectSet<T>(type, new CompositeCollection());
        CompositeDomainObjectSet<? extends T> out = new CompositeDomainObjectSet<T>(backingSet);
        for (DomainObjectCollection<? extends T> c : collections) {
            out.addCollection(c);
        }
        return out;
    }

    CompositeDomainObjectSet(DefaultDomainObjectSet<T> backingSet) {
        super(backingSet);
        this.backingSet = backingSet;
    }

    protected CompositeCollection getStore() {
        return (CompositeCollection)this.backingSet.getStore();
    }

    @Override
    public Action<? super T> whenObjectAdded(Action<? super T> action) {
        return super.whenObjectAdded(Actions.filter(action, this.uniqueSpec));
    }

    @Override
    public Action<? super T> whenObjectRemoved(Action<? super T> action) {
        return super.whenObjectRemoved(Actions.filter(action, this.notInSpec));
    }

    public void addCollection(DomainObjectCollection<? extends T> collection) {
        if (!this.getStore().getCollections().contains(collection)) {
            this.getStore().addComposited(collection);
            collection.all(this.backingSet.getEventRegister().getAddAction());
            collection.whenObjectRemoved(this.backingSet.getEventRegister().getRemoveAction());
        }
    }

    public void removeCollection(DomainObjectCollection<? extends T> collection) {
        this.getStore().removeComposited(collection);
        Action action = this.backingSet.getEventRegister().getRemoveAction();
        for (Object item : collection) {
            action.execute(item);
        }
    }

    @Override
    public Iterator<T> iterator() {
        CompositeCollection store = this.getStore();
        if (store.isEmpty()) {
            return Iterators.emptyIterator();
        }
        return new SetIterator();
    }

    @Override
    public int size() {
        CompositeCollection store = this.getStore();
        if (store.isEmpty()) {
            return 0;
        }
        return new HashSet(store).size();
    }

    @Override
    public void all(Action<? super T> action) {
        this.whenObjectAdded(action);
        for (T t : this) {
            action.execute(t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SetIterator
    implements Iterator<T> {
        private final Set<T> visited = new HashSet(64);
        private final Iterator<T> iterator;
        private T next;

        public SetIterator() {
            Collection collections = CompositeDomainObjectSet.this.getStore().getCollections();
            this.iterator = collections instanceof List && collections.size() == 1 ? ((Collection)((List)collections).get(0)).iterator() : CompositeDomainObjectSet.this.getStore().iterator();
            this.fetchNext();
        }

        private void fetchNext() {
            while (this.iterator.hasNext()) {
                this.next = this.iterator.next();
                if (this.visited.contains(this.next)) continue;
                this.visited.add(this.next);
                return;
            }
            this.next = null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T next() {
            try {
                Object t = this.next;
                return t;
            }
            finally {
                this.fetchNext();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ItemNotInCompositeSpec
    implements Spec<T> {
        public boolean isSatisfiedBy(T element) {
            return !CompositeDomainObjectSet.this.getStore().contains(element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ItemIsUniqueInCompositeSpec
    implements Spec<T> {
        public boolean isSatisfiedBy(T element) {
            int matches = 0;
            for (Object collection : CompositeDomainObjectSet.this.getStore().getCollections()) {
                if (!((Collection)collection).contains(element) || ++matches <= 1) continue;
                return false;
            }
            return true;
        }
    }
}

