/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.Constants;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.Factory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.CharTable;

public class TypeParameterExtendsBoundsListElement
extends CompositeElement
implements Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.TypeParameterExtendsBoundsListElement");

    public TypeParameterExtendsBoundsListElement() {
        super(JavaElementType.EXTENDS_BOUND_LIST);
    }

    @Override
    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor2, Boolean before) {
        if (first == last && first.getElementType() == JAVA_CODE_REFERENCE && this.getLastChildNode() != null && this.getLastChildNode().getElementType() == ERROR_ELEMENT) {
            super.deleteChildInternal(this.getLastChildNode());
        }
        TreeElement firstAdded = super.addInternal(first, last, anchor2, before);
        CharTable treeCharTab = SharedImplUtil.findCharTableByTree(this);
        if (first == last && first.getElementType() == JAVA_CODE_REFERENCE) {
            LeafElement comma;
            ASTNode child;
            TreeElement element = first;
            for (child = element.getTreeNext(); child != null && child.getElementType() != AND; child = child.getTreeNext()) {
                if (child.getElementType() != JAVA_CODE_REFERENCE) continue;
                comma = Factory.createSingleLeafElement(AND, "&", 0, 1, treeCharTab, this.getManager());
                super.addInternal(comma, comma, element, Boolean.FALSE);
                break;
            }
            for (child = element.getTreePrev(); child != null && child.getElementType() != AND; child = child.getTreePrev()) {
                if (child.getElementType() != JAVA_CODE_REFERENCE) continue;
                comma = Factory.createSingleLeafElement(AND, "&", 0, 1, treeCharTab, this.getManager());
                super.addInternal(comma, comma, child, Boolean.FALSE);
                break;
            }
        }
        IElementType keywordType = JavaTokenType.EXTENDS_KEYWORD;
        String keywordText = "extends";
        if (this.findChildByType(keywordType) == null && this.findChildByType(JAVA_CODE_REFERENCE) != null) {
            LeafElement keyword = Factory.createSingleLeafElement(keywordType, "extends", treeCharTab, this.getManager());
            super.addInternal(keyword, keyword, this.getFirstChildNode(), Boolean.TRUE);
        }
        return firstAdded;
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/TypeParameterExtendsBoundsListElement", "deleteChildInternal"));
        }
        if (child.getElementType() == JAVA_CODE_REFERENCE) {
            ASTNode next = PsiImplUtil.skipWhitespaceAndComments(child.getTreeNext());
            if (next != null && next.getElementType() == AND) {
                this.deleteChildInternal(next);
            } else {
                ASTNode prev = PsiImplUtil.skipWhitespaceAndCommentsBack(child.getTreePrev());
                if (prev != null && (prev.getElementType() == AND || prev.getElementType() == EXTENDS_KEYWORD)) {
                    this.deleteChildInternal(prev);
                }
            }
        }
        super.deleteChildInternal(child);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType elType = child.getElementType();
        if (elType == AND) {
            return 123;
        }
        if (elType == JavaElementType.JAVA_CODE_REFERENCE) {
            return 78;
        }
        if (elType == JavaTokenType.EXTENDS_KEYWORD) {
            return 26;
        }
        return 0;
    }
}

