/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiBundle;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassInitializer;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiDeclarationStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiEllipsisType;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceList;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameterListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.util.ClassUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiExpressionTrimRenderer;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiFormatUtilBase;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;

public class PsiFormatUtil
extends PsiFormatUtilBase {
    public static String formatVariable(@NotNull PsiVariable variable, @FormatVariableOptions int options, PsiSubstitutor substitutor2) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/kotlin/com/intellij/psi/util/PsiFormatUtil", "formatVariable"));
        }
        StringBuilder buffer = new StringBuilder();
        PsiFormatUtil.formatVariable(variable, options, substitutor2, buffer);
        return buffer.toString();
    }

    private static void formatVariable(@NotNull PsiVariable variable, @FormatVariableOptions int options, PsiSubstitutor substitutor2, @NotNull StringBuilder buffer) {
        PsiExpression initializer2;
        String name;
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/kotlin/com/intellij/psi/util/PsiFormatUtil", "formatVariable"));
        }
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/kotlin/com/intellij/psi/util/PsiFormatUtil", "formatVariable"));
        }
        if ((options & 8) != 0 && (options & 0x10) == 0) {
            PsiFormatUtil.formatModifiers(variable, options, buffer);
        }
        if ((options & 2) != 0 && (options & 4) == 0) {
            PsiFormatUtil.appendSpaceIfNeeded(buffer);
            buffer.append(PsiFormatUtil.formatType(variable.getType(), options, substitutor2));
        }
        if (variable instanceof PsiField && (options & 0x1000) != 0) {
            String className2;
            PsiClass aClass2 = ((PsiField)variable).getContainingClass();
            if (aClass2 != null && (className2 = aClass2.getName()) != null) {
                PsiFormatUtil.appendSpaceIfNeeded(buffer);
                if ((options & 0x800) != 0) {
                    String qName = aClass2.getQualifiedName();
                    if (qName != null) {
                        buffer.append(qName);
                    } else {
                        buffer.append(className2);
                    }
                } else {
                    buffer.append(className2);
                }
                buffer.append('.');
            }
            if ((options & 1) != 0) {
                buffer.append(variable.getName());
            }
        } else if ((options & 1) != 0 && StringUtil.isNotEmpty(name = variable.getName())) {
            PsiFormatUtil.appendSpaceIfNeeded(buffer);
            buffer.append(name);
        }
        if ((options & 2) != 0 && (options & 4) != 0) {
            if ((options & 1) != 0 && variable.getName() != null) {
                buffer.append(':');
            }
            buffer.append(PsiFormatUtil.formatType(variable.getType(), options, substitutor2));
        }
        if ((options & 8) != 0 && (options & 0x10) != 0) {
            PsiFormatUtil.formatModifiers(variable, options, buffer);
        }
        if ((options & 0x80) != 0 && (initializer2 = variable.getInitializer()) != null) {
            int index2;
            buffer.append(" = ");
            String text2 = PsiExpressionTrimRenderer.render(initializer2);
            int index1 = text2.lastIndexOf(10);
            if (index1 < 0) {
                index1 = text2.length();
            }
            if ((index2 = text2.lastIndexOf(13)) < 0) {
                index2 = text2.length();
            }
            int index3 = Math.min(index1, index2);
            buffer.append(text2.substring(0, index3));
            if (index3 < text2.length()) {
                buffer.append(" ...");
            }
        }
    }

    public static String formatMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor2, @FormatMethodOptions int options, @FormatVariableOptions int parameterOptions) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/com/intellij/psi/util/PsiFormatUtil", "formatMethod"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/com/intellij/psi/util/PsiFormatUtil", "formatMethod"));
        }
        return PsiFormatUtil.formatMethod(method, substitutor2, options, parameterOptions, 7);
    }

    public static String formatMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor2, @FormatMethodOptions int options, @FormatVariableOptions int parameterOptions, int maxParametersToShow) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/com/intellij/psi/util/PsiFormatUtil", "formatMethod"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/com/intellij/psi/util/PsiFormatUtil", "formatMethod"));
        }
        StringBuilder buffer = new StringBuilder();
        PsiFormatUtil.formatMethod(method, substitutor2, options, parameterOptions, maxParametersToShow, buffer);
        return buffer.toString();
    }

    private static void formatMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor2, @FormatMethodOptions int options, @FormatVariableOptions int parameterOptions, int maxParametersToShow, StringBuilder buffer) {
        String throwsText;
        PsiType type2;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/com/intellij/psi/util/PsiFormatUtil", "formatMethod"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/com/intellij/psi/util/PsiFormatUtil", "formatMethod"));
        }
        if ((options & 8) != 0 && (options & 0x10) == 0) {
            PsiFormatUtil.formatModifiers(method, options, buffer);
        }
        if ((options & 2) != 0 && (options & 4) == 0 && (type2 = method.getReturnType()) != null) {
            PsiFormatUtil.appendSpaceIfNeeded(buffer);
            buffer.append(PsiFormatUtil.formatType(type2, options, substitutor2));
        }
        if ((options & 0x1000) != 0) {
            PsiClass aClass2 = method.getContainingClass();
            if (aClass2 != null) {
                PsiFormatUtil.appendSpaceIfNeeded(buffer);
                String name = aClass2.getName();
                if (name != null) {
                    if ((options & 0x800) != 0) {
                        String qName = aClass2.getQualifiedName();
                        if (qName != null) {
                            buffer.append(qName);
                        } else {
                            buffer.append(name);
                        }
                    } else {
                        buffer.append(name);
                    }
                    buffer.append('.');
                }
            }
            if ((options & 1) != 0) {
                buffer.append(method.getName());
            }
        } else if ((options & 1) != 0) {
            PsiFormatUtil.appendSpaceIfNeeded(buffer);
            buffer.append(method.getName());
        }
        if ((options & 0x100) != 0) {
            buffer.append('(');
            PsiParameter[] params = method.getParameterList().getParameters();
            for (int i = 0; i < Math.min(params.length, maxParametersToShow); ++i) {
                PsiParameter parm = params[i];
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(PsiFormatUtil.formatVariable(parm, parameterOptions, substitutor2));
            }
            if (params.length > maxParametersToShow) {
                buffer.append(", ...");
            }
            buffer.append(')');
        }
        if ((options & 2) != 0 && (options & 4) != 0 && (type2 = method.getReturnType()) != null) {
            if (buffer.length() > 0) {
                buffer.append(':');
            }
            buffer.append(PsiFormatUtil.formatType(type2, options, substitutor2));
        }
        if ((options & 8) != 0 && (options & 0x10) != 0) {
            PsiFormatUtil.formatModifiers(method, options, buffer);
        }
        if ((options & 0x200) != 0 && !(throwsText = PsiFormatUtil.formatReferenceList(method.getThrowsList(), options)).isEmpty()) {
            PsiFormatUtil.appendSpaceIfNeeded(buffer);
            buffer.append("throws ");
            buffer.append(throwsText);
        }
    }

    @NotNull
    public static String formatClass(@NotNull PsiClass aClass2, @FormatClassOptions int options) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/util/PsiFormatUtil", "formatClass"));
        }
        StringBuilder buffer = new StringBuilder();
        if ((options & 8) != 0 && (options & 0x10) == 0) {
            PsiFormatUtil.formatModifiers(aClass2, options, buffer);
        }
        if ((options & 1) != 0) {
            if (aClass2 instanceof PsiAnonymousClass && (options & 0x8000) != 0) {
                PsiClassType baseClassReference = ((PsiAnonymousClass)aClass2).getBaseClassType();
                PsiClass baseClass = baseClassReference.resolve();
                String name = baseClass == null ? baseClassReference.getPresentableText() : PsiFormatUtil.formatClass(baseClass, options);
                buffer.append(PsiBundle.message("anonymous.class.derived.display", name));
            } else {
                String name = aClass2.getName();
                if (name != null) {
                    PsiFormatUtil.appendSpaceIfNeeded(buffer);
                    if ((options & 0x800) != 0) {
                        String qName = aClass2.getQualifiedName();
                        if (qName != null) {
                            buffer.append(qName);
                        } else {
                            buffer.append(aClass2.getName());
                        }
                    } else {
                        buffer.append(aClass2.getName());
                    }
                }
            }
        }
        if ((options & 8) != 0 && (options & 0x10) != 0) {
            PsiFormatUtil.formatModifiers(aClass2, options, buffer);
        }
        if ((options & 0x400) != 0) {
            String implementsText;
            String extendsText = PsiFormatUtil.formatReferenceList(aClass2.getExtendsList(), options);
            if (!extendsText.isEmpty()) {
                PsiFormatUtil.appendSpaceIfNeeded(buffer);
                buffer.append("extends ");
                buffer.append(extendsText);
            }
            if (!(implementsText = PsiFormatUtil.formatReferenceList(aClass2.getImplementsList(), options)).isEmpty()) {
                PsiFormatUtil.appendSpaceIfNeeded(buffer);
                buffer.append("implements ");
                buffer.append(implementsText);
            }
        }
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiFormatUtil", "formatClass"));
        }
        return string;
    }

    public static String formatModifiers(PsiElement element, int options) throws IllegalArgumentException {
        StringBuilder buffer = new StringBuilder();
        PsiFormatUtil.formatModifiers(element, options, buffer);
        return buffer.toString();
    }

    private static void formatModifiers(PsiElement element, int options, StringBuilder buffer) throws IllegalArgumentException {
        PsiModifierList list2;
        boolean isInterface = false;
        if (element instanceof PsiVariable) {
            list2 = ((PsiVariable)element).getModifierList();
        } else if (element instanceof PsiMethod) {
            list2 = ((PsiMethod)element).getModifierList();
        } else if (element instanceof PsiClass) {
            isInterface = ((PsiClass)element).isInterface();
            list2 = ((PsiClass)element).getModifierList();
            if (list2 == null) {
                return;
            }
        } else if (element instanceof PsiClassInitializer) {
            list2 = ((PsiClassInitializer)element).getModifierList();
            if (list2 == null) {
                return;
            }
        } else {
            throw new IllegalArgumentException();
        }
        if (list2 == null) {
            return;
        }
        if ((options & 0x20) == 0 ? list2.hasExplicitModifier("public") : list2.hasModifierProperty("public")) {
            PsiFormatUtil.appendModifier(buffer, "public");
        }
        if (list2.hasModifierProperty("protected")) {
            PsiFormatUtil.appendModifier(buffer, "protected");
        }
        if (list2.hasModifierProperty("private")) {
            PsiFormatUtil.appendModifier(buffer, "private");
        }
        if ((options & 0x20) == 0 ? list2.hasExplicitModifier("packageLocal") : list2.hasModifierProperty("packageLocal")) {
            if (element instanceof PsiClass && element.getParent() instanceof PsiDeclarationStatement) {
                PsiFormatUtil.appendModifier(buffer, PsiBundle.message("local.class.preposition", new Object[0]));
            } else {
                PsiFormatUtil.appendModifier(buffer, PsiBundle.visibilityPresentation("packageLocal"));
            }
        }
        if ((options & 0x20) == 0 ? list2.hasExplicitModifier("static") : list2.hasModifierProperty("static")) {
            PsiFormatUtil.appendModifier(buffer, "static");
        }
        if (!isInterface && ((options & 0x20) == 0 ? list2.hasExplicitModifier("abstract") : list2.hasModifierProperty("abstract"))) {
            PsiFormatUtil.appendModifier(buffer, "abstract");
        }
        if ((options & 0x20) == 0 ? list2.hasExplicitModifier("final") : list2.hasModifierProperty("final")) {
            PsiFormatUtil.appendModifier(buffer, "final");
        }
        if (list2.hasModifierProperty("native") && (options & 0x4000) == 0) {
            PsiFormatUtil.appendModifier(buffer, "native");
        }
        if (list2.hasModifierProperty("synchronized") && (options & 0x4000) == 0) {
            PsiFormatUtil.appendModifier(buffer, "synchronized");
        }
        if (list2.hasModifierProperty("strictfp") && (options & 0x4000) == 0) {
            PsiFormatUtil.appendModifier(buffer, "strictfp");
        }
        if (list2.hasModifierProperty("transient") && element instanceof PsiVariable) {
            PsiFormatUtil.appendModifier(buffer, "transient");
        }
        if (list2.hasModifierProperty("volatile")) {
            PsiFormatUtil.appendModifier(buffer, "volatile");
        }
    }

    private static void appendModifier(StringBuilder buffer, String modifier) {
        PsiFormatUtil.appendSpaceIfNeeded(buffer);
        buffer.append(modifier);
    }

    public static String formatReferenceList(PsiReferenceList list2, int options) {
        StringBuilder buffer = new StringBuilder();
        PsiJavaCodeReferenceElement[] refs = list2.getReferenceElements();
        for (int i = 0; i < refs.length; ++i) {
            PsiJavaCodeReferenceElement ref = refs[i];
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(PsiFormatUtil.formatReference(ref, options));
        }
        return buffer.toString();
    }

    public static String formatType(@Nullable PsiType type2, int options, @NotNull PsiSubstitutor substitutor2) {
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/com/intellij/psi/util/PsiFormatUtil", "formatType"));
        }
        type2 = substitutor2.substitute(type2);
        if ((options & 0x10000) != 0) {
            type2 = TypeConversionUtil.erasure(type2);
        } else if ((options & 0x20000) != 0 && !(PsiUtil.resolveClassInType(type2) instanceof PsiTypeParameter)) {
            boolean preserveEllipsis = type2 instanceof PsiEllipsisType;
            type2 = TypeConversionUtil.erasure(type2);
            if (preserveEllipsis && type2 instanceof PsiArrayType) {
                type2 = new PsiEllipsisType(((PsiArrayType)type2).getComponentType());
            }
        }
        if (type2 == null) {
            return "null";
        }
        return (options & 0x2000) == 0 ? type2.getPresentableText() : ((options & 0x40000) == 0 ? type2.getCanonicalText(false) : type2.getInternalCanonicalText());
    }

    public static String formatReference(PsiJavaCodeReferenceElement ref, int options) {
        return (options & 0x2000) == 0 ? ref.getText() : ref.getCanonicalText();
    }

    @Nullable
    public static String getExternalName(PsiModifierListOwner owner) {
        return PsiFormatUtil.getExternalName(owner, true);
    }

    @Nullable
    public static String getExternalName(PsiModifierListOwner owner, boolean showParamName) {
        return PsiFormatUtil.getExternalName(owner, showParamName, 7);
    }

    @Nullable
    public static String getExternalName(PsiModifierListOwner owner, boolean showParamName, int maxParamsToShow) {
        StringBuilder builder = new StringBuilder();
        if (owner instanceof PsiClass) {
            ClassUtil.formatClassName((PsiClass)owner, builder);
            return builder.toString();
        }
        PsiClass psiClass = PsiTreeUtil.getParentOfType((PsiElement)owner, PsiClass.class, false);
        if (psiClass == null) {
            return null;
        }
        ClassUtil.formatClassName(psiClass, builder);
        if (owner instanceof PsiMethod) {
            builder.append(" ");
            PsiFormatUtil.formatMethod((PsiMethod)owner, PsiSubstitutor.EMPTY, 10499, showParamName ? 8195 : 8194, maxParamsToShow, builder);
        } else if (owner instanceof PsiField) {
            builder.append(" ").append(((PsiField)owner).getName());
        } else if (owner instanceof PsiParameter) {
            PsiElement declarationScope = ((PsiParameter)owner).getDeclarationScope();
            if (!(declarationScope instanceof PsiMethod)) {
                return null;
            }
            PsiMethod psiMethod = (PsiMethod)declarationScope;
            builder.append(" ");
            PsiFormatUtil.formatMethod(psiMethod, PsiSubstitutor.EMPTY, 10499, showParamName ? 8195 : 8194, maxParamsToShow, builder);
            builder.append(" ");
            if (showParamName) {
                PsiFormatUtil.formatVariable((PsiVariable)owner, 1, PsiSubstitutor.EMPTY, builder);
            } else {
                builder.append(psiMethod.getParameterList().getParameterIndex((PsiParameter)owner));
            }
        } else {
            return null;
        }
        return builder.toString();
    }

    public static String getPackageDisplayName(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/com/intellij/psi/util/PsiFormatUtil", "getPackageDisplayName"));
        }
        if (psiClass instanceof PsiTypeParameter) {
            PsiTypeParameterListOwner owner = ((PsiTypeParameter)psiClass).getOwner();
            String ownerName = null;
            if (owner instanceof PsiClass) {
                ownerName = ((PsiClass)owner).getQualifiedName();
                if (ownerName == null) {
                    ownerName = owner.getName();
                }
            } else if (owner instanceof PsiMethod) {
                ownerName = owner.getName();
            }
            return ownerName == null ? "type parameter" : "type parameter of " + ownerName;
        }
        String packageName = psiClass.getQualifiedName();
        String string = packageName = packageName == null || packageName.lastIndexOf(46) <= 0 ? "" : packageName.substring(0, packageName.lastIndexOf(46));
        if (packageName.isEmpty()) {
            packageName = "default package";
        }
        return packageName;
    }

    public static @interface FormatClassOptions {
    }

    public static @interface FormatMethodOptions {
    }

    public static @interface FormatVariableOptions {
    }
}

