/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Cast;
import org.gradle.model.internal.core.NodeInitializer;
import org.gradle.model.internal.core.NodeInitializerContext;
import org.gradle.model.internal.inspect.FactoryBasedStructNodeInitializer;
import org.gradle.model.internal.manage.binding.StructBindings;
import org.gradle.model.internal.manage.binding.StructBindingsStore;
import org.gradle.model.internal.manage.schema.ManagedImplSchema;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.StructSchema;
import org.gradle.model.internal.manage.schema.extract.NodeInitializerExtractionStrategy;
import org.gradle.model.internal.type.ModelType;
import org.gradle.model.internal.typeregistration.InstanceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryBasedStructNodeInitializerExtractionStrategy<T>
implements NodeInitializerExtractionStrategy {
    private final InstanceFactory<T> instanceFactory;
    private final StructBindingsStore bindingsStore;

    public FactoryBasedStructNodeInitializerExtractionStrategy(InstanceFactory<T> instanceFactory, StructBindingsStore bindingsStore) {
        this.instanceFactory = instanceFactory;
        this.bindingsStore = bindingsStore;
    }

    public <S> NodeInitializer extractNodeInitializer(ModelSchema<S> schema, NodeInitializerContext<S> context) {
        if (!this.instanceFactory.getBaseInterface().isAssignableFrom(schema.getType())) {
            return null;
        }
        NodeInitializer nodeInitializer = this.getNodeInitializer((ModelSchema)Cast.uncheckedCast(schema));
        if (nodeInitializer == null) {
            throw new IllegalArgumentException(String.format("Cannot create an instance of type '%s' as this type is not known. Known types: %s.", schema.getType(), this.formatKnownTypes(context.getConstraints(), this.instanceFactory.getSupportedTypes())));
        }
        return nodeInitializer;
    }

    private String formatKnownTypes(Spec<ModelType<?>> constraints, Set<? extends ModelType<?>> supportedTypes) {
        StringBuilder builder = new StringBuilder();
        for (ModelType<?> supportedType : supportedTypes) {
            if (!constraints.isSatisfiedBy(supportedType)) continue;
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(supportedType);
        }
        if (builder.length() == 0) {
            return "(none)";
        }
        return builder.toString();
    }

    private <S extends T> NodeInitializer getNodeInitializer(ModelSchema<S> schema) {
        StructSchema publicSchema = (StructSchema)Cast.uncheckedCast(schema);
        InstanceFactory.ImplementationInfo implementationInfo = this.getImplementationInfo(publicSchema);
        if (implementationInfo == null) {
            return null;
        }
        Set<ModelType<?>> internalViews = implementationInfo.getInternalViews();
        ModelType<?> delegateType = implementationInfo.getDelegateType();
        StructBindings bindings = this.bindingsStore.getBindings(publicSchema.getType(), internalViews, delegateType);
        return new FactoryBasedStructNodeInitializer(bindings, implementationInfo);
    }

    private <S extends T> InstanceFactory.ImplementationInfo getImplementationInfo(StructSchema<S> schema) {
        ModelType publicType = schema.getType();
        return schema instanceof ManagedImplSchema ? this.instanceFactory.getManagedSubtypeImplementationInfo(publicType) : this.instanceFactory.getImplementationInfo(publicType);
    }

    @Override
    public Iterable<ModelType<?>> supportedTypes() {
        return ImmutableSet.copyOf(this.instanceFactory.getSupportedTypes());
    }
}

