/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Objects;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.coor.QuadTiling;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.Utils;

public class BBox {
    private double xmin = Double.POSITIVE_INFINITY;
    private double xmax = Double.NEGATIVE_INFINITY;
    private double ymin = Double.POSITIVE_INFINITY;
    private double ymax = Double.NEGATIVE_INFINITY;

    public BBox(double d, double d2) {
        this.xmax = this.xmin = d;
        this.ymax = this.ymin = d2;
        this.sanity();
    }

    public BBox(LatLon latLon, LatLon latLon2) {
        this(latLon.lon(), latLon.lat(), latLon2.lon(), latLon2.lat());
    }

    public BBox(BBox bBox) {
        this.xmin = bBox.xmin;
        this.xmax = bBox.xmax;
        this.ymin = bBox.ymin;
        this.ymax = bBox.ymax;
    }

    public BBox(double d, double d2, double d3, double d4) {
        if (d > d3) {
            this.xmax = d;
            this.xmin = d3;
        } else {
            this.xmax = d3;
            this.xmin = d;
        }
        if (d2 > d4) {
            this.ymax = d2;
            this.ymin = d4;
        } else {
            this.ymax = d4;
            this.ymin = d2;
        }
        this.sanity();
    }

    public BBox(Way way) {
        for (Node node : way.getNodes()) {
            LatLon latLon = node.getCoor();
            if (latLon == null) continue;
            this.add(latLon);
        }
    }

    public BBox(Node node) {
        LatLon latLon = node.getCoor();
        if (latLon == null) {
            this.ymax = 0.0;
            this.ymin = 0.0;
            this.xmax = 0.0;
            this.xmin = 0.0;
        } else {
            this.xmin = this.xmax = latLon.lon();
            this.ymin = this.ymax = latLon.lat();
        }
    }

    private void sanity() {
        if (this.xmin < -180.0) {
            this.xmin = -180.0;
        }
        if (this.xmax > 180.0) {
            this.xmax = 180.0;
        }
        if (this.ymin < -90.0) {
            this.ymin = -90.0;
        }
        if (this.ymax > 90.0) {
            this.ymax = 90.0;
        }
    }

    public final void add(LatLon latLon) {
        this.add(latLon.lon(), latLon.lat());
    }

    public final void add(double d, double d2) {
        this.xmin = Math.min(this.xmin, d);
        this.xmax = Math.max(this.xmax, d);
        this.ymin = Math.min(this.ymin, d2);
        this.ymax = Math.max(this.ymax, d2);
        this.sanity();
    }

    public final void add(BBox bBox) {
        this.xmin = Math.min(this.xmin, bBox.xmin);
        this.xmax = Math.max(this.xmax, bBox.xmax);
        this.ymin = Math.min(this.ymin, bBox.ymin);
        this.ymax = Math.max(this.ymax, bBox.ymax);
        this.sanity();
    }

    public void addPrimitive(OsmPrimitive osmPrimitive, double d) {
        BBox bBox = osmPrimitive.getBBox();
        this.add(bBox.xmin - d, bBox.ymin - d);
        this.add(bBox.xmax + d, bBox.ymax + d);
    }

    public double height() {
        return this.ymax - this.ymin;
    }

    public double width() {
        return this.xmax - this.xmin;
    }

    public boolean bounds(BBox bBox) {
        return this.xmin <= bBox.xmin && this.xmax >= bBox.xmax && this.ymin <= bBox.ymin && this.ymax >= bBox.ymax;
    }

    public boolean bounds(LatLon latLon) {
        return this.xmin <= latLon.lon() && this.xmax >= latLon.lon() && this.ymin <= latLon.lat() && this.ymax >= latLon.lat();
    }

    public boolean intersects(BBox bBox) {
        if (this.xmin > bBox.xmax) {
            return false;
        }
        if (this.xmax < bBox.xmin) {
            return false;
        }
        if (this.ymin > bBox.ymax) {
            return false;
        }
        return !(this.ymax < bBox.ymin);
    }

    public LatLon getTopLeft() {
        return new LatLon(this.ymax, this.xmin);
    }

    public double getTopLeftLat() {
        return this.ymax;
    }

    public double getTopLeftLon() {
        return this.xmin;
    }

    public LatLon getBottomRight() {
        return new LatLon(this.ymin, this.xmax);
    }

    public double getBottomRightLat() {
        return this.ymin;
    }

    public double getBottomRightLon() {
        return this.xmax;
    }

    public LatLon getCenter() {
        return new LatLon(this.ymin + (this.ymax - this.ymin) / 2.0, this.xmin + (this.xmax - this.xmin) / 2.0);
    }

    int getIndex(int n) {
        int n2 = QuadTiling.index(this.ymin, this.xmin, n);
        int n3 = QuadTiling.index(this.ymin, this.xmax, n);
        if (n2 == -1) {
            n2 = n3;
        } else if (n2 != n3) {
            return -1;
        }
        int n4 = QuadTiling.index(this.ymax, this.xmin, n);
        if (n2 == -1) {
            n2 = n4;
        } else if (n2 != n4) {
            return -1;
        }
        int n5 = QuadTiling.index(this.ymax, this.xmax, n);
        if (n2 == -1) {
            n2 = n5;
        } else if (n2 != n5) {
            return -1;
        }
        return n2;
    }

    public Rectangle2D toRectangle() {
        return new Rectangle2D.Double(this.xmin, this.ymin, this.xmax - this.xmin, this.ymax - this.ymin);
    }

    public int hashCode() {
        return Objects.hash(this.xmin, this.xmax, this.ymin, this.ymax);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BBox bBox = (BBox)object;
        return Double.compare(bBox.xmax, this.xmax) == 0 && Double.compare(bBox.ymax, this.ymax) == 0 && Double.compare(bBox.xmin, this.xmin) == 0 && Double.compare(bBox.ymin, this.ymin) == 0;
    }

    public String toString() {
        return "[ x: " + this.xmin + " -> " + this.xmax + ", y: " + this.ymin + " -> " + this.ymax + " ]";
    }

    public String toStringCSV(String string) {
        return Utils.join(string, Arrays.asList(LatLon.cDdFormatter.format(this.xmin), LatLon.cDdFormatter.format(this.ymin), LatLon.cDdFormatter.format(this.xmax), LatLon.cDdFormatter.format(this.ymax)));
    }
}

