/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.java.ArrayReadNode;
import com.oracle.truffle.api.interop.java.ArrayReadNodeGen;
import com.oracle.truffle.api.interop.java.ArrayWriteNode;
import com.oracle.truffle.api.interop.java.ArrayWriteNodeGen;
import com.oracle.truffle.api.interop.java.JavaFunctionMessageResolution;
import com.oracle.truffle.api.interop.java.JavaFunctionObject;
import com.oracle.truffle.api.interop.java.JavaInterop;
import com.oracle.truffle.api.interop.java.JavaObject;
import com.oracle.truffle.api.interop.java.ToJavaNode;
import com.oracle.truffle.api.interop.java.ToJavaNodeGen;
import com.oracle.truffle.api.nodes.Node;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class JavaObjectMessageResolution {
    JavaObjectMessageResolution() {
    }

    static abstract class PropertiesNode
    extends Node {
        PropertiesNode() {
        }

        @CompilerDirectives.TruffleBoundary
        public Object access(JavaObject receiver) {
            Field[] fields = receiver.clazz.getFields();
            String[] names = new String[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                names[i] = fields[i].getName();
            }
            return JavaInterop.asTruffleObject(names);
        }
    }

    static abstract class WriteFieldNode
    extends Node {
        @Node.Child
        private ToJavaNode toJava = ToJavaNodeGen.create();
        @Node.Child
        private ArrayWriteNode write = ArrayWriteNodeGen.create();

        WriteFieldNode() {
        }

        public Object access(VirtualFrame frame, JavaObject receiver, String name, Object value) {
            try {
                Object obj = receiver.obj;
                try {
                    Field f = WriteFieldNode.findField(receiver, name);
                    Object convertedValue = this.toJava.execute(frame, value, f.getType());
                    WriteFieldNode.setField(obj, f, convertedValue);
                    return JavaObject.NULL;
                }
                catch (NoSuchFieldException ex) {
                    throw new RuntimeException(ex);
                }
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void setField(Object obj, Field f, Object convertedValue) throws IllegalAccessException {
            f.set(obj, convertedValue);
        }

        @CompilerDirectives.TruffleBoundary
        private static Field findField(JavaObject receiver, String name) throws NoSuchFieldException {
            return receiver.clazz.getField(name);
        }

        public Object access(VirtualFrame frame, JavaObject receiver, Number index, Object value) {
            return this.write.executeWithTarget(frame, receiver, index, value);
        }
    }

    static abstract class ReadFieldNode
    extends Node {
        @Node.Child
        private ArrayReadNode read = ArrayReadNodeGen.create();

        ReadFieldNode() {
        }

        public Object access(VirtualFrame frame, JavaObject object, Number index) {
            return this.read.executeWithTarget(frame, object, index);
        }

        @CompilerDirectives.TruffleBoundary
        public Object access(JavaObject object, String name) {
            try {
                Object val;
                Object obj = object.obj;
                boolean onlyStatic = obj == null;
                try {
                    boolean isStatic;
                    Field field = object.clazz.getField(name);
                    boolean bl = isStatic = (field.getModifiers() & 8) != 0;
                    if (onlyStatic != isStatic) {
                        throw new NoSuchFieldException();
                    }
                    val = field.get(obj);
                }
                catch (NoSuchFieldException ex) {
                    for (Method m : object.clazz.getMethods()) {
                        boolean isStatic;
                        boolean bl = isStatic = (m.getModifiers() & 8) != 0;
                        if (onlyStatic != isStatic || !m.getName().equals(name)) continue;
                        return new JavaFunctionObject(m, obj);
                    }
                    throw (NoSuchFieldError)new NoSuchFieldError(ex.getMessage()).initCause(ex);
                }
                if (ToJavaNode.isPrimitive(val)) {
                    return val;
                }
                return JavaInterop.asTruffleObject(val);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    static abstract class NullCheckNode
    extends Node {
        NullCheckNode() {
        }

        public Object access(JavaObject object) {
            return object == JavaObject.NULL;
        }
    }

    static abstract class NewNode
    extends Node {
        NewNode() {
        }

        public Object access(JavaObject object, Object[] args) {
            return NewNode.execute(object, args);
        }

        @CompilerDirectives.TruffleBoundary
        private static Object execute(JavaObject receiver, Object[] args) {
            if (receiver.obj != null) {
                throw new IllegalStateException("Can only work on classes: " + receiver.obj);
            }
            for (int i = 0; i < args.length; ++i) {
                if (!(args[i] instanceof JavaObject)) continue;
                args[i] = ((JavaObject)args[i]).obj;
            }
            IllegalStateException ex = new IllegalStateException("No suitable constructor found for " + receiver.clazz);
            for (Constructor<?> constructor : receiver.clazz.getConstructors()) {
                try {
                    Object ret = constructor.newInstance(args);
                    if (ToJavaNode.isPrimitive(ret)) {
                        return ret;
                    }
                    return JavaInterop.asTruffleObject(ret);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException instEx) {
                    ex = new IllegalStateException(instEx);
                }
            }
            throw ex;
        }
    }

    static abstract class InvokeNode
    extends Node {
        @Node.Child
        private JavaFunctionMessageResolution.ExecuteNode.DoExecuteNode doExecute;

        InvokeNode() {
        }

        public Object access(VirtualFrame frame, JavaObject object, String name, Object[] args) {
            Method foundMethod = InvokeNode.findMethod(object, name, args);
            if (foundMethod != null) {
                if (this.doExecute == null || args.length != this.doExecute.numberOfArguments()) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.doExecute = this.insert(new JavaFunctionMessageResolution.ExecuteNode.DoExecuteNode(args.length));
                }
                return this.doExecute.execute(frame, foundMethod, object.obj, args);
            }
            throw UnknownIdentifierException.raise(name);
        }

        @CompilerDirectives.TruffleBoundary
        private static Method findMethod(JavaObject object, String name, Object[] args) {
            for (Method m : object.clazz.getMethods()) {
                if (!m.getName().equals(name) || m.getParameterTypes().length != args.length && !m.isVarArgs()) continue;
                return m;
            }
            return null;
        }
    }

    static abstract class ArrayHasSizeNode
    extends Node {
        ArrayHasSizeNode() {
        }

        public Object access(JavaObject receiver) {
            Object obj = receiver.obj;
            if (obj == null) {
                return false;
            }
            try {
                return obj instanceof Object[] || Array.getLength(obj) >= 0;
            }
            catch (IllegalArgumentException ex) {
                return Boolean.FALSE;
            }
        }
    }

    static abstract class ArrayGetSizeNode
    extends Node {
        ArrayGetSizeNode() {
        }

        public Object access(JavaObject receiver) {
            Object obj = receiver.obj;
            if (obj == null) {
                return 0;
            }
            return Array.getLength(obj);
        }
    }
}

