/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.method;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.builtins.UnaryCoreMethodNode;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.arguments.ArgumentDescriptorUtils;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.methods.CanBindMethodToModuleNode;
import org.jruby.truffle.language.methods.CanBindMethodToModuleNodeGen;
import org.jruby.truffle.language.methods.InternalMethod;
import org.jruby.truffle.language.objects.MetaClassNode;
import org.jruby.truffle.language.objects.MetaClassNodeGen;

@CoreClass(value="UnboundMethod")
public abstract class UnboundMethodNodes {

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends UnaryCoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            throw new RaiseException(this.coreExceptions().typeErrorAllocatorUndefinedFor(rubyClass, this));
        }
    }

    @CoreMethod(names={"source_location"})
    public static abstract class SourceLocationNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object sourceLocation(DynamicObject unboundMethod) {
            SourceSection sourceSection = Layouts.UNBOUND_METHOD.getMethod(unboundMethod).getSharedMethodInfo().getSourceSection();
            if (sourceSection.getSource() == null) {
                return this.nil();
            }
            DynamicObject file = this.createString(StringOperations.encodeRope(sourceSection.getSource().getName(), (Encoding)UTF8Encoding.INSTANCE));
            Object[] objects = new Object[]{file, sourceSection.getStartLine()};
            return this.createArray(objects, objects.length);
        }
    }

    @CoreMethod(names={"parameters"})
    public static abstract class ParametersNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject parameters(DynamicObject method) {
            ArgumentDescriptor[] argsDesc = Layouts.UNBOUND_METHOD.getMethod(method).getSharedMethodInfo().getArgumentDescriptors();
            return ArgumentDescriptorUtils.argumentDescriptorsToParameters(this.getContext(), argsDesc, true);
        }
    }

    @CoreMethod(names={"owner"})
    public static abstract class OwnerNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject owner(DynamicObject unboundMethod) {
            return Layouts.UNBOUND_METHOD.getMethod(unboundMethod).getDeclaringModule();
        }
    }

    @CoreMethod(names={"origin"}, visibility=Visibility.PRIVATE)
    public static abstract class OriginNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject origin(DynamicObject unboundMethod) {
            return Layouts.UNBOUND_METHOD.getOrigin(unboundMethod);
        }
    }

    @CoreMethod(names={"name"})
    public static abstract class NameNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject name(DynamicObject unboundMethod) {
            return this.getSymbol(Layouts.UNBOUND_METHOD.getMethod(unboundMethod).getName());
        }
    }

    @CoreMethod(names={"hash"})
    public static abstract class HashNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public long hash(DynamicObject rubyMethod) {
            InternalMethod method = Layouts.UNBOUND_METHOD.getMethod(rubyMethod);
            long h = Helpers.hashStart((Ruby)this.getContext().getJRubyRuntime(), (long)method.getDeclaringModule().hashCode());
            h = Helpers.murmurCombine((long)h, (long)Layouts.UNBOUND_METHOD.getOrigin(rubyMethod).hashCode());
            h = Helpers.murmurCombine((long)h, (long)method.getSharedMethodInfo().hashCode());
            return Helpers.hashEnd((long)h);
        }
    }

    @CoreMethod(names={"bind"}, required=1)
    public static abstract class BindNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private MetaClassNode metaClassNode;
        @Node.Child
        private CanBindMethodToModuleNode canBindMethodToModuleNode;

        public BindNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.metaClassNode = MetaClassNodeGen.create(context, sourceSection, null);
            this.canBindMethodToModuleNode = CanBindMethodToModuleNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public DynamicObject bind(DynamicObject unboundMethod, Object object, @Cached(value="create()") BranchProfile errorProfile) {
            DynamicObject objectMetaClass = this.metaClass(object);
            if (!this.canBindMethodToModuleNode.executeCanBindMethodToModule(Layouts.UNBOUND_METHOD.getMethod(unboundMethod), objectMetaClass)) {
                errorProfile.enter();
                DynamicObject declaringModule = Layouts.UNBOUND_METHOD.getMethod(unboundMethod).getDeclaringModule();
                if (RubyGuards.isSingletonClass(declaringModule)) {
                    throw new RaiseException(this.coreExceptions().typeError("singleton method called for a different object", this));
                }
                throw new RaiseException(this.coreExceptions().typeError("bind argument must be an instance of " + Layouts.MODULE.getFields(declaringModule).getName(), this));
            }
            return Layouts.METHOD.createMethod(this.coreLibrary().getMethodFactory(), object, Layouts.UNBOUND_METHOD.getMethod(unboundMethod));
        }

        protected DynamicObject metaClass(Object object) {
            return this.metaClassNode.executeMetaClass(object);
        }
    }

    @CoreMethod(names={"arity"})
    public static abstract class ArityNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int arity(DynamicObject method) {
            return Layouts.UNBOUND_METHOD.getMethod(method).getSharedMethodInfo().getArity().getArityNumber();
        }
    }

    @CoreMethod(names={"=="}, required=1)
    public static abstract class EqualNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isRubyUnboundMethod(other)"})
        boolean equal(DynamicObject self, DynamicObject other) {
            return Layouts.UNBOUND_METHOD.getMethod(self) == Layouts.UNBOUND_METHOD.getMethod(other) && Layouts.UNBOUND_METHOD.getOrigin(self) == Layouts.UNBOUND_METHOD.getOrigin(other);
        }

        @Specialization(guards={"!isRubyUnboundMethod(other)"})
        boolean equal(DynamicObject self, Object other) {
            return false;
        }
    }
}

