/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.option;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.LayoutHelper;

public class OptionsJvmPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = -7541236934312940852L;
    private static final Path JVM_PROPERTIES_FILE = Paths.get(Constant.getDefaultHomeDirectory(false), ".ZAP_JVM.properties");
    private static final String NAME = Constant.messages.getString("jvm.options.title");
    private ZapTextField jvmOptionsField = null;

    public OptionsJvmPanel() {
        this.setName(NAME);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(Constant.messages.getString("jvm.options.label.jvmoptions"));
        jLabel.setLabelFor(this.getJvmOptionsField());
        jPanel.add((Component)jLabel, LayoutHelper.getGBC(0, 0, 1, 1.0));
        jPanel.add((Component)this.getJvmOptionsField(), LayoutHelper.getGBC(1, 0, 1, 1.0));
        jPanel.add((Component)new JLabel(Constant.messages.getString("jvm.options.warning.restart")), LayoutHelper.getGBC(0, 1, 2, 1.0));
        jPanel.add((Component)new JLabel(), LayoutHelper.getGBC(0, 10, 1, 0.5, 1.0));
        this.add(jPanel);
    }

    private ZapTextField getJvmOptionsField() {
        if (this.jvmOptionsField == null) {
            this.jvmOptionsField = new ZapTextField();
        }
        return this.jvmOptionsField;
    }

    @Override
    public void initParam(Object object) {
        try {
            List<String> list;
            if (Files.exists(JVM_PROPERTIES_FILE, new LinkOption[0]) && (list = Files.readAllLines(JVM_PROPERTIES_FILE, StandardCharsets.UTF_8)).size() > 0) {
                this.getJvmOptionsField().setText(list.get(0));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void validateParam(Object object) throws Exception {
    }

    @Override
    public void saveParam(Object object) throws Exception {
        try {
            String string = this.getJvmOptionsField().getText();
            if (string.length() == 0) {
                Files.deleteIfExists(JVM_PROPERTIES_FILE);
            } else {
                if (!JVM_PROPERTIES_FILE.getParent().toFile().exists()) {
                    JVM_PROPERTIES_FILE.getParent().toFile().mkdirs();
                }
                Files.write(JVM_PROPERTIES_FILE, string.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
        }
        catch (IOException iOException) {
            View.getSingleton().showWarningDialog(this, MessageFormat.format(Constant.messages.getString("jvm.options.error.writing"), JVM_PROPERTIES_FILE.toAbsolutePath(), iOException.getMessage()));
        }
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.jvm";
    }
}

