/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import org.zaproxy.zap.utils.Orderable;
import org.zaproxy.zap.view.AbstractMultipleOptionsBaseTableModel;

public abstract class AbstractMultipleOrderedOptionsBaseTableModel<E extends Orderable>
extends AbstractMultipleOptionsBaseTableModel<E> {
    private static final long serialVersionUID = 8139923613612787185L;

    @Override
    public void removeElement(int n) {
        boolean bl = n != this.getElements().size() - 1;
        this.getElements().remove(n);
        this.fireTableRowsDeleted(n, n);
        if (bl) {
            this.updateOrdersAndFireNotification(n);
        }
    }

    public void moveTop(int n) {
        Orderable orderable = (Orderable)this.getElement(n);
        this.getElements().add(0, orderable);
        this.getElements().remove(n + 1);
        this.updateOrdersAndFireNotification(0);
    }

    public void moveUp(int n) {
        Orderable orderable = (Orderable)this.getElement(n);
        int n2 = n - 1;
        int n3 = n;
        this.getElements().add(n2, orderable);
        this.getElements().remove(n + 1);
        orderable.setOrder(n);
        ((Orderable)this.getElements().get(n3)).setOrder(n + 1);
        this.fireTableRowsUpdated(n2, n3);
    }

    public void moveDown(int n) {
        this.moveUp(n + 1);
    }

    public void moveBottom(int n) {
        Orderable orderable = (Orderable)this.getElement(n);
        this.getElements().remove(n);
        this.getElements().add(orderable);
        this.updateOrdersAndFireNotification(n);
    }

    protected void updateOrdersAndFireNotification(int n) {
        for (int i = n; i < this.getElements().size(); ++i) {
            ((Orderable)this.getElement(i)).setOrder(i + 1);
        }
        this.fireTableDataChanged();
    }
}

