/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.system;

import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import org.owasp.jbrofuzz.system.FileListener;

class SimpleFileMonitor {
    private final Timer timer;
    private final File logFile;
    private long lastModified;
    private FileListener listener;
    private long lastLength;

    protected SimpleFileMonitor(long pollingInterval, File logFile) {
        this.logFile = logFile;
        this.lastLength = logFile.length();
        this.lastModified = logFile.exists() ? logFile.lastModified() : -1L;
        this.timer = new Timer(true);
        this.timer.schedule((TimerTask)new FileMonitorNotifier(), 0L, pollingInterval);
    }

    protected void addListener(FileListener fileListener) {
        this.listener = fileListener;
    }

    public long getLastLength() {
        return this.lastLength;
    }

    private class FileMonitorNotifier
    extends TimerTask {
        private FileMonitorNotifier() {
        }

        @Override
        public void run() {
            long newModifiedTime;
            long l = newModifiedTime = SimpleFileMonitor.this.logFile.exists() ? SimpleFileMonitor.this.logFile.lastModified() : -1L;
            if (newModifiedTime != SimpleFileMonitor.this.lastModified) {
                SimpleFileMonitor.this.lastModified = newModifiedTime;
                SimpleFileMonitor.this.listener.fileChanged(SimpleFileMonitor.this.logFile);
                SimpleFileMonitor.this.lastLength = SimpleFileMonitor.this.logFile.length();
            }
        }
    }
}

