/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.awt.event;

import com.jogamp.newt.Window;
import com.jogamp.newt.event.awt.AWTAdapter;
import com.jogamp.newt.event.awt.AWTWindowAdapter;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowEvent;
import javax.media.nativewindow.NativeWindow;
import jogamp.newt.driver.DriverUpdatePosition;

public class AWTParentWindowAdapter
extends AWTWindowAdapter
implements HierarchyListener {
    NativeWindow downstreamParent;

    public AWTParentWindowAdapter(NativeWindow nativeWindow, Window window) {
        super(window);
        this.downstreamParent = nativeWindow;
    }

    public AWTParentWindowAdapter() {
    }

    public AWTParentWindowAdapter setDownstream(NativeWindow nativeWindow, Window window) {
        this.setDownstream(window);
        this.downstreamParent = nativeWindow;
        return this;
    }

    @Override
    public synchronized AWTAdapter clear() {
        super.clear();
        this.downstreamParent = null;
        return this;
    }

    @Override
    public synchronized AWTAdapter addTo(Component component) {
        component.addHierarchyListener(this);
        return super.addTo(component);
    }

    @Override
    public synchronized AWTAdapter removeFrom(Component component) {
        component.removeHierarchyListener(this);
        return super.removeFrom(component);
    }

    @Override
    public synchronized void focusGained(FocusEvent focusEvent) {
        if (!this.isSetup) {
            return;
        }
        Window window = this.getNewtWindow();
        if (null != window) {
            boolean bl = window.isNativeValid() && window.getGraphicsConfiguration().getChosenCapabilities().isOnscreen();
            boolean bl2 = this.downstreamParent == window.getParent();
            boolean bl3 = window.isFullscreen();
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("AWT: focusGained: onscreen " + bl + ", " + focusEvent + ", isParent: " + bl2 + ", isFS " + bl3);
            }
            if (bl2) {
                if (bl && !bl3) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
                }
                window.requestFocus(false);
            }
        }
    }

    @Override
    public synchronized void focusLost(FocusEvent focusEvent) {
        if (!this.isSetup) {
            return;
        }
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("AWT: focusLost: " + focusEvent);
        }
    }

    @Override
    public synchronized void componentResized(ComponentEvent componentEvent) {
        Window window;
        if (!this.isSetup) {
            return;
        }
        final Component component = componentEvent.getComponent();
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("AWT: componentResized: " + component);
        }
        if (null != (window = this.getNewtWindow())) {
            window.runOnEDTIfAvail(false, new Runnable(){

                @Override
                public void run() {
                    int n = component.getWidth();
                    int n2 = component.getHeight();
                    if (0 < n && 0 < n2) {
                        if (window.getWidth() != n || window.getHeight() != n2) {
                            window.setSize(n, n2);
                            boolean bl = component.isShowing();
                            if (bl != window.isVisible()) {
                                window.setVisible(bl);
                            }
                        }
                    } else if (window.isVisible()) {
                        window.setVisible(false);
                    }
                }
            });
        }
    }

    @Override
    public synchronized void componentMoved(ComponentEvent componentEvent) {
        Window window;
        if (!this.isSetup) {
            return;
        }
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("AWT: componentMoved: " + componentEvent);
        }
        if (null != (window = this.getNewtWindow()) && window.getDelegatedWindow() instanceof DriverUpdatePosition) {
            ((DriverUpdatePosition)((Object)window.getDelegatedWindow())).updatePosition(0, 0);
        }
    }

    @Override
    public synchronized void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public synchronized void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public synchronized void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        if (!this.isSetup) {
            return;
        }
        final Window window = this.getNewtWindow();
        if (null != window && null == this.getNewtEventListener()) {
            long l = hierarchyEvent.getChangeFlags();
            Component component = hierarchyEvent.getComponent();
            if (0L != (4L & l)) {
                final boolean bl = component.isShowing();
                if (DEBUG_IMPLEMENTATION) {
                    System.err.println("AWT: hierarchyChanged SHOWING_CHANGED: showing " + bl + ", comp " + component + ", changed " + hierarchyEvent.getChanged());
                }
                window.runOnEDTIfAvail(false, new Runnable(){

                    @Override
                    public void run() {
                        if (window.isVisible() != bl) {
                            window.setVisible(bl);
                        }
                    }
                });
            }
            if (DEBUG_IMPLEMENTATION && 0L != (2L & l)) {
                System.err.println("AWT: hierarchyChanged DISPLAYABILITY_CHANGED: " + hierarchyEvent.getChanged());
            }
        }
    }
}

