/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize;

import org.jmol.minimize.Minimizer;
import org.jmol.thread.JmolThread;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class MinimizationThread
extends JmolThread {
    private Minimizer minimizer;

    @Override
    public int setManager(Object manager, Viewer vwr, Object options) {
        this.minimizer = (Minimizer)manager;
        this.setViewer(vwr, "MinimizationThread");
        return 0;
    }

    @Override
    protected void run1(int mode) throws InterruptedException {
        while (true) {
            switch (mode) {
                case -1: {
                    this.lastRepaintTime = this.startTime;
                    this.haveReference = true;
                    if (!this.minimizer.startMinimization()) {
                        return;
                    }
                    this.vwr.startHoverWatcher(false);
                    mode = 0;
                    break;
                }
                case 0: {
                    if (!this.minimizer.minimizationOn() || this.checkInterrupted(this.minimizer.getThread())) {
                        mode = -2;
                        break;
                    }
                    this.currentTime = System.currentTimeMillis();
                    int elapsed = (int)(this.currentTime - this.lastRepaintTime);
                    int sleepTime = 33 - elapsed;
                    if (!this.runSleep(sleepTime, 1)) {
                        return;
                    }
                    mode = 1;
                    break;
                }
                case 1: {
                    this.lastRepaintTime = this.currentTime = System.currentTimeMillis();
                    mode = this.minimizer.stepMinimization() ? 0 : -2;
                    break;
                }
                case -2: {
                    this.minimizer.endMinimization();
                    this.vwr.startHoverWatcher(true);
                    return;
                }
            }
        }
    }

    @Override
    protected void oops(Exception e) {
        if (this.minimizer.minimizationOn()) {
            Logger.error(e.toString());
        }
    }
}

