/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel.console;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javajs.util.PT;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.jmol.api.JmolAbstractButton;
import org.jmol.api.JmolViewer;
import org.jmol.awt.Platform;
import org.jmol.console.JmolConsole;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.jmolpanel.HelpDialog;
import org.openscience.jmol.app.jmolpanel.PreferencesDialog;
import org.openscience.jmol.app.jmolpanel.console.EnterListener;

public class AppConsole
extends JmolConsole
implements EnterListener {
    public static final String ALL_BUTTONS = "Editor Variables Clear History State UndoRedo Close Font Help";
    private int fontSize;
    public JDialog jcd;
    protected ConsoleTextPane console;
    private JmolAbstractButton varButton;
    private JmolAbstractButton haltButton;
    private JmolAbstractButton closeButton;
    private JmolAbstractButton clearButton;
    private JmolAbstractButton stepButton;
    private JmolAbstractButton helpButton;
    private JmolAbstractButton undoButton;
    private JmolAbstractButton redoButton;
    private JmolAbstractButton checkButton;
    private JmolAbstractButton topButton;
    private JmolAbstractButton fontButton;
    private JPanel buttonPanel = new JPanel();
    protected JScrollBar vBar;
    protected JScrollBar hBar;
    boolean isError = false;
    ExecuteCommandThread execThread;
    private static int MAXUNDO = 10;
    private String[] undoStack = new String[MAXUNDO + 1];
    private int undoPointer = 0;
    private boolean undoSaved = false;
    private boolean dontsave;

    public AppConsole() {
    }

    @Override
    public void start(Viewer vwr) {
        this.setup(vwr, null, null);
    }

    public AppConsole(JmolViewer vwr, Container externalContainer, String enabledButtons) {
        this.setup((Viewer)vwr, externalContainer, enabledButtons);
    }

    private void setup(Viewer vwr, Container externalContainer, String enabledButtons) {
        this.setViewer(vwr);
        Window w = Platform.getWindow((Container)vwr.display);
        JFrame jFrame = this.vwrFrame = w instanceof JFrame ? (JFrame)w : null;
        if (externalContainer == null) {
            this.jcd = new JDialog(this.vwrFrame, null, false);
            this.jcd.setSize(645, 400);
            this.jcd.setLocationRelativeTo(this.vwrFrame);
            this.externalContainer = this.jcd;
        } else {
            this.externalContainer = externalContainer;
            vwr.setConsole(this);
        }
        this.addWindowListener();
        this.layoutWindow(enabledButtons);
    }

    @Override
    public void updateFontSize() {
        int scale = PT.parseInt("" + (String)this.vwr.getProperty("DATA_API", "getPreference", "consoleFontScale"));
        scale = (scale < 0 ? 1 : scale) % 5;
        this.fontSize = scale * 4 + 12;
        if (this.console != null) {
            this.console.setFont(new Font("dialog", 0, this.fontSize));
        }
    }

    @Override
    public void sendConsoleEcho(String strEcho) {
        if (strEcho == null) {
            this.updateLabels();
        } else if (strEcho.equals("\u0000")) {
            this.sendConsoleMessage(null);
        } else {
            this.console.outputEcho(strEcho);
        }
        this.setError(false);
    }

    @Override
    public void sendConsoleMessage(String strStatus) {
        if (strStatus == null) {
            this.console.clearContent(null);
            this.console.outputStatus("");
        } else if (strStatus.indexOf("ERROR:") >= 0) {
            this.console.outputError(strStatus);
            this.setError(true);
        } else {
            this.console.outputStatus(strStatus);
            this.isError = false;
        }
    }

    @Override
    protected JmolAbstractButton setButton(String label) {
        JmolAbstractButton b = super.setButton(label);
        this.buttonPanel.add((JButton)((Object)b));
        return b;
    }

    @Override
    protected void setupLabels0(Map<String, String> labels) {
        labels.put("Check", GT._("Check"));
        labels.put("Clear", GT._("Clear"));
        labels.put("Close", GT._("Close"));
        labels.put("Halt", GT._("Halt"));
        labels.put("Help", GT._("Help"));
        labels.put("Editor", GT._("Editor"));
        labels.put("History", GT._("History"));
        labels.put("State", GT._("State"));
        labels.put("Step", GT._("Step"));
        labels.put("Top", GT._("Top"));
        labels.put("Undo", GT._("Undo"));
        labels.put("Redo", GT._("Redo"));
        labels.put("Font", GT._("Font"));
        labels.put("Variables", GT._("Variables"));
    }

    @Override
    protected void layoutWindow(String enabledButtons) {
        this.setTitle();
        this.console = new ConsoleTextPane(this);
        this.console.setPrompt();
        this.console.setDragEnabled(true);
        if (enabledButtons == null) {
            enabledButtons = ALL_BUTTONS;
        }
        JScrollPane consolePane = new JScrollPane(this.console);
        this.vBar = consolePane.getVerticalScrollBar();
        this.hBar = consolePane.getHorizontalScrollBar();
        String[] tokens = PT.getTokens(enabledButtons);
        for (int i = 0; i < tokens.length; ++i) {
            this.enableButton(tokens[i]);
        }
        AppConsole.setEnabled(this.undoButton, false);
        AppConsole.setEnabled(this.redoButton, false);
        JPanel buttonPanelWrapper = new JPanel();
        buttonPanelWrapper.setLayout(new BorderLayout());
        buttonPanelWrapper.add((Component)this.buttonPanel, "Center");
        JSplitPane spane = new JSplitPane(0, consolePane, buttonPanelWrapper);
        consolePane.setMinimumSize(new Dimension(300, 300));
        consolePane.setPreferredSize(new Dimension(5000, 5000));
        buttonPanelWrapper.setMinimumSize(new Dimension(60, 60));
        buttonPanelWrapper.setMaximumSize(new Dimension(1000, 60));
        buttonPanelWrapper.setPreferredSize(new Dimension(60, 60));
        spane.setDividerSize(0);
        spane.setResizeWeight(0.95);
        this.getPane().add(spane);
    }

    private static void setEnabled(JmolAbstractButton button, boolean TF) {
        if (button != null) {
            button.setEnabled(TF);
        }
    }

    private void enableButton(String name) {
        switch ("Check     Clear     Close     Editor    Halt      Help      History   State     Step      Top       UndoRedo  Font      Variables ".indexOf(name)) {
            case 0: {
                this.checkButton = this.setButton("Check");
                break;
            }
            case 10: {
                this.clearButton = this.setButton("Clear");
                break;
            }
            case 20: {
                this.closeButton = this.setButton("Close");
                break;
            }
            case 30: {
                this.editButton = this.setButton("Editor");
                break;
            }
            case 40: {
                this.haltButton = this.setButton("Halt");
                break;
            }
            case 50: {
                this.helpButton = this.setButton("Help");
                break;
            }
            case 60: {
                this.historyButton = this.setButton("History");
                break;
            }
            case 70: {
                this.stateButton = this.setButton("State");
                break;
            }
            case 80: {
                this.stepButton = this.setButton("Step");
                break;
            }
            case 90: {
                this.topButton = this.setButton("Top");
                break;
            }
            case 100: {
                this.undoButton = this.setButton("Undo");
                this.redoButton = this.setButton("Redo");
                break;
            }
            case 110: {
                this.varButton = this.setButton("Variables");
                break;
            }
            case 120: {
                this.fontButton = this.setButton("Font");
                this.fontButton.setToolTipText(GT._("toggle font size"));
            }
        }
    }

    private void setError(boolean TF) {
        this.isError = TF;
    }

    @Override
    public void enterPressed() {
        this.executeCommandAsThread(null);
    }

    @Override
    protected void execute(String strCommand) {
        this.executeCommandAsThread(strCommand);
    }

    void executeCommandAsThread(String strCommand) {
        if (strCommand == null) {
            strCommand = this.console.getCommandString().trim();
        }
        if (strCommand.equalsIgnoreCase("undo")) {
            this.undoRedo(false);
            this.console.appendNewline();
            this.console.setPrompt();
            return;
        }
        if (strCommand.equalsIgnoreCase("redo")) {
            this.undoRedo(true);
            this.console.appendNewline();
            this.console.setPrompt();
            return;
        }
        if (strCommand.equalsIgnoreCase("exitJmol")) {
            System.exit(0);
        } else if (strCommand.startsWith("font console")) {
            String s = strCommand.substring(12);
            if (PT.parseInt(s) > 0) {
                s = "sansserif-" + s;
            }
            this.console.setFont(Font.decode(s));
            strCommand = " ";
        } else if (strCommand.length() == 0) {
            strCommand = "!resume";
            this.undoSetEnabled();
        }
        if (strCommand.length() > 0) {
            this.execThread = new ExecuteCommandThread(strCommand);
            this.execThread.start();
        }
    }

    private void undoClear() {
        if (this.undoButton == null) {
            return;
        }
        for (int i = 0; i <= MAXUNDO; ++i) {
            this.undoStack[i] = null;
        }
        this.undoPointer = 0;
        this.undoButton.setEnabled(false);
        this.redoButton.setEnabled(false);
    }

    private boolean undoSetEnabled() {
        if (this.undoButton == null) {
            return false;
        }
        boolean undoAllowed = this.vwr.getBooleanProperty("undo") && this.vwr.getBooleanProperty("preserveState");
        this.undoButton.setEnabled(undoAllowed && this.undoPointer > 0 && this.undoStack[this.undoPointer - 1] != null);
        this.redoButton.setEnabled(undoAllowed && this.undoPointer < MAXUNDO && this.undoStack[this.undoPointer + 1] != null);
        return undoAllowed;
    }

    private void undoRedo(boolean isRedo) {
        if (this.undoButton == null) {
            return;
        }
        if (!this.undoSetEnabled()) {
            return;
        }
        int ptr = this.undoPointer + (isRedo ? 1 : -1);
        if (!this.undoSaved) {
            this.undoSave(false);
        }
        if (ptr > MAXUNDO || ptr < 0) {
            return;
        }
        String state = this.undoStack[ptr];
        if (state != null) {
            state = state + "#----";
            this.setError(false);
            this.vwr.evalStringQuiet(state);
            this.undoPointer = ptr;
        }
        this.undoSetEnabled();
    }

    private void undoSave(boolean incrementPtr) {
        int i;
        if (this.undoButton == null) {
            return;
        }
        if (!this.vwr.getBooleanProperty("undo") || !this.vwr.getBooleanProperty("preserveState")) {
            return;
        }
        for (i = this.undoPointer + 1; i <= MAXUNDO; ++i) {
            this.undoStack[i] = null;
        }
        Logger.startTimer("(console");
        try {
            this.undoStack[this.undoPointer] = (String)this.vwr.getProperty("readable", "stateInfo", null);
            if (incrementPtr && this.undoPointer == MAXUNDO) {
                for (i = 1; i <= MAXUNDO; ++i) {
                    this.undoStack[i - 1] = this.undoStack[i];
                }
                this.undoStack[AppConsole.MAXUNDO] = null;
            } else if (incrementPtr) {
                ++this.undoPointer;
            }
        }
        catch (Error e) {
            this.dontsave = true;
        }
        if (this.dontsave || Logger.checkTimer("(console", false) > 2000) {
            this.vwr.setBooleanProperty("undo", false);
            this.undoClear();
            Logger.info("command processing slow; undo disabled");
        } else {
            this.undoSetEnabled();
        }
        this.undoSaved = true;
    }

    void executeCommand(String strCommand) {
        boolean doWait;
        this.console.appendNewline();
        this.console.setPrompt();
        if (strCommand.length() == 0) {
            this.console.grabFocus();
            return;
        }
        if (strCommand.charAt(0) != '!' && this.vwr.getBooleanProperty("executionPaused")) {
            strCommand = "!" + strCommand;
        }
        if (strCommand.charAt(0) != '!' && !this.isError) {
            this.undoSave(true);
        }
        this.setError(false);
        this.undoSaved = false;
        String strErrorMessage = null;
        boolean bl = doWait = strCommand.indexOf("WAITTEST ") == 0;
        if (doWait) {
            Object o = this.vwr.scriptWaitStatus(strCommand.substring(5), "+fileLoaded,+scriptStarted,+scriptStatus,+scriptEcho,+scriptTerminated");
            if (o instanceof List) {
                List info = (List)o;
                for (int i = 0; i < info.size(); ++i) {
                    List statusRecordSet = (List)info.get(i);
                    for (int j = 0; j < statusRecordSet.size(); ++j) {
                        List statusRecord = (List)statusRecordSet.get(j);
                        Logger.info("msg#=" + statusRecord.get(0) + " " + statusRecord.get(1) + " intInfo=" + statusRecord.get(2) + " stringInfo=" + statusRecord.get(3));
                    }
                }
            }
            this.console.appendNewline();
        } else {
            boolean isInterrupt;
            boolean isScriptExecuting = this.vwr.isScriptExecuting();
            strErrorMessage = "";
            String str = strCommand;
            boolean bl2 = isInterrupt = str.charAt(0) == '!';
            if (isInterrupt) {
                str = str.substring(1);
            }
            if (this.vwr.checkHalt(str, isInterrupt)) {
                String string = strErrorMessage = isScriptExecuting ? "script execution halted with " + strCommand : "no script was executing - use exitJmol to exit Jmol";
            }
            if (strErrorMessage.length() > 0) {
                this.console.outputError(strErrorMessage);
            } else {
                this.vwr.script(strCommand + (strCommand.indexOf("\u0001##") >= 0 ? "" : "\u0001## EDITOR_IGNORE ##"));
            }
        }
        if (strCommand.indexOf("\u0001##") < 0) {
            this.console.grabFocus();
        }
    }

    @Override
    protected void clearContent(String text) {
        this.console.clearContent(text);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.console.grabFocus();
        Object source = e.getSource();
        if (source == this.topButton) {
            if (this.scriptEditor != null) {
                this.scriptEditor.gotoTop();
            }
            return;
        }
        if (source == this.checkButton && this.scriptEditor != null) {
            this.scriptEditor.checkScript();
        }
        if (source == this.stepButton) {
            if (this.scriptEditor != null) {
                this.scriptEditor.doStep();
            }
            return;
        }
        if (source == this.closeButton) {
            this.setVisible(false);
            return;
        }
        if (source == this.haltButton) {
            this.vwr.haltScriptExecution();
            return;
        }
        if (source == this.varButton) {
            this.execute("!show variables");
            return;
        }
        if (source == this.clearButton) {
            this.console.clearContent(null);
            return;
        }
        if (source == this.undoButton) {
            this.undoRedo(false);
            return;
        }
        if (source == this.redoButton) {
            this.undoRedo(true);
            return;
        }
        if (source == this.fontButton) {
            PreferencesDialog d = (PreferencesDialog)this.vwr.getProperty("DATA_API", "getPreference", null);
            if (d != null) {
                d.setFontScale(-1);
            }
            return;
        }
        if (source == this.helpButton) {
            URL url = this.getClass().getClassLoader().getResource("org/openscience/jmol/Data/guide/ch04.html");
            if (url == null) {
                this.vwr.script("help");
            } else {
                new HelpDialog(null, url).setVisible(true);
            }
        }
        super.actionPerformed(e);
    }

    @Override
    public String getText() {
        return this.console.getText();
    }

    class ConsoleDocument
    extends DefaultStyledDocument {
        private ConsoleTextPane consoleTextPane;
        SimpleAttributeSet attError = new SimpleAttributeSet();
        SimpleAttributeSet attEcho;
        SimpleAttributeSet attPrompt;
        SimpleAttributeSet attUserInput;
        SimpleAttributeSet attStatus;
        private Position positionBeforePrompt;
        private Position positionAfterPrompt;
        private int offsetAfterPrompt;

        ConsoleDocument() {
            StyleConstants.setForeground(this.attError, Color.red);
            this.attPrompt = new SimpleAttributeSet();
            StyleConstants.setForeground(this.attPrompt, Color.magenta);
            this.attUserInput = new SimpleAttributeSet();
            StyleConstants.setForeground(this.attUserInput, Color.black);
            this.attEcho = new SimpleAttributeSet();
            StyleConstants.setForeground(this.attEcho, Color.blue);
            StyleConstants.setBold(this.attEcho, true);
            this.attStatus = new SimpleAttributeSet();
            StyleConstants.setForeground(this.attStatus, Color.black);
            StyleConstants.setItalic(this.attStatus, true);
        }

        void setConsoleTextPane(ConsoleTextPane consoleTextPane) {
            this.consoleTextPane = consoleTextPane;
        }

        boolean isAtEnd() {
            return this.consoleTextPane.getCaretPosition() == this.getLength();
        }

        void clearContent() {
            try {
                super.remove(0, this.getLength());
            }
            catch (BadLocationException exception) {
                Logger.errorEx("Could not clear script window content", exception);
            }
        }

        void setPrompt() {
            try {
                super.insertString(this.getLength(), "$ ", this.attPrompt);
                this.setOffsetPositions();
                this.consoleTextPane.setCaretPosition(this.offsetAfterPrompt);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }

        void setOffsetPositions() {
            try {
                this.offsetAfterPrompt = this.getLength();
                this.positionBeforePrompt = this.createPosition(this.offsetAfterPrompt - 2);
                this.positionAfterPrompt = this.createPosition(this.offsetAfterPrompt - 1);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }

        void setNoPrompt() {
            try {
                this.offsetAfterPrompt = this.getLength();
                this.positionAfterPrompt = this.positionBeforePrompt = this.createPosition(this.offsetAfterPrompt);
                this.consoleTextPane.setCaretPosition(this.offsetAfterPrompt);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }

        void outputBeforePrompt(String str, SimpleAttributeSet attribute) {
            try {
                int pt = this.consoleTextPane.getCaretPosition();
                Position caretPosition = this.createPosition(pt);
                pt = this.positionBeforePrompt.getOffset();
                super.insertString(pt, str + "\n", attribute);
                this.offsetAfterPrompt += str.length() + 1;
                this.positionBeforePrompt = this.createPosition(this.offsetAfterPrompt - 2);
                this.positionAfterPrompt = this.createPosition(this.offsetAfterPrompt - 1);
                pt = caretPosition.getOffset();
                this.consoleTextPane.setCaretPosition(pt);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.consoleTextPane.setCaretPosition(this.getLength());
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        AppConsole.this.vBar.setValue(AppConsole.this.vBar.getMaximum());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
        }

        void outputError(String strError) {
            this.outputBeforePrompt(strError, this.attError);
        }

        void outputErrorForeground(String strError) {
            try {
                super.insertString(this.getLength(), strError + "\n", this.attError);
                this.consoleTextPane.setCaretPosition(this.getLength());
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }

        void outputEcho(String strEcho) {
            this.outputBeforePrompt(strEcho, this.attEcho);
        }

        void outputStatus(String strStatus) {
            this.outputBeforePrompt(strStatus, this.attStatus);
        }

        void appendNewline() {
            try {
                super.insertString(this.getLength(), "\n", this.attUserInput);
                this.consoleTextPane.setCaretPosition(this.getLength());
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }

        @Override
        public synchronized void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            int ichNewline = str.indexOf(10);
            if (ichNewline != 0) {
                if (offs < this.offsetAfterPrompt) {
                    offs = this.getLength();
                }
                super.insertString(offs, str, a == this.attError ? a : this.attUserInput);
                this.consoleTextPane.setCaretPosition(offs + str.length());
            }
            if (ichNewline >= 0) {
                this.consoleTextPane.enterPressed();
            }
        }

        String getCommandString() {
            String strCommand = "";
            try {
                int cmdStart = this.positionAfterPrompt.getOffset();
                strCommand = this.getText(cmdStart, this.getLength() - cmdStart);
                while (strCommand.length() > 0 && strCommand.charAt(0) == ' ') {
                    strCommand = strCommand.substring(1);
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            return strCommand;
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            if (offs < this.offsetAfterPrompt) {
                if ((len -= this.offsetAfterPrompt - offs) <= 0) {
                    return;
                }
                offs = this.offsetAfterPrompt;
            }
            super.remove(offs, len);
        }

        @Override
        public void replace(int offs, int length, String str, AttributeSet attrs) throws BadLocationException {
            if (offs < this.offsetAfterPrompt) {
                if (offs + length < this.offsetAfterPrompt) {
                    offs = this.getLength();
                    length = 0;
                } else {
                    length -= this.offsetAfterPrompt - offs;
                    offs = this.offsetAfterPrompt;
                }
            }
            super.replace(offs, length, str, attrs);
        }

        void replaceCommand(String newCommand, boolean isError) throws BadLocationException {
            if (this.positionAfterPrompt == this.positionBeforePrompt) {
                return;
            }
            this.replace(this.offsetAfterPrompt, this.getLength() - this.offsetAfterPrompt, newCommand, isError ? this.attError : this.attUserInput);
        }

        void colorCommand(SimpleAttributeSet att) {
            if (this.positionAfterPrompt == this.positionBeforePrompt) {
                return;
            }
            this.setCharacterAttributes(this.offsetAfterPrompt, this.getLength() - this.offsetAfterPrompt, att, true);
        }
    }

    class ConsoleTextPane
    extends JTextPane {
        private ConsoleDocument consoleDoc;
        private EnterListener enterListener;
        boolean checking;
        private String pageUpBuffer;

        ConsoleTextPane(AppConsole appConsole) {
            super(new ConsoleDocument());
            this.checking = false;
            AppConsole.this.updateFontSize();
            this.consoleDoc = (ConsoleDocument)this.getDocument();
            this.consoleDoc.setConsoleTextPane(this);
            this.enterListener = appConsole;
        }

        public String getCommandString() {
            String cmd = this.consoleDoc.getCommandString();
            return cmd;
        }

        public void setPrompt() {
            this.consoleDoc.setPrompt();
        }

        public void appendNewline() {
            this.consoleDoc.appendNewline();
        }

        public void outputError(String strError) {
            this.consoleDoc.outputError(strError);
        }

        public void outputErrorForeground(String strError) {
            this.consoleDoc.outputErrorForeground(strError);
        }

        public void outputEcho(String strEcho) {
            this.consoleDoc.outputEcho(strEcho);
        }

        public void outputStatus(String strStatus) {
            this.consoleDoc.outputStatus(strStatus);
        }

        public void enterPressed() {
            if (this.enterListener != null) {
                this.enterListener.enterPressed();
            }
        }

        public void clearContent(String text) {
            this.consoleDoc.clearContent();
            if (text != null) {
                this.consoleDoc.outputEcho(text);
            }
            this.setPrompt();
        }

        @Override
        protected void processKeyEvent(KeyEvent ke) {
            int kcode = ke.getKeyCode();
            int kid = ke.getID();
            if (kid == 401) {
                switch (kcode) {
                    case 67: {
                        if (!ke.isControlDown() || !ke.isAltDown()) break;
                        ke.consume();
                        AppConsole.this.vwr.script("!quit");
                        return;
                    }
                    case 9: {
                        ke.consume();
                        if (!this.consoleDoc.isAtEnd()) break;
                        String cmd = AppConsole.this.completeCommand(this.consoleDoc.getCommandString());
                        if (cmd != null) {
                            try {
                                this.consoleDoc.replaceCommand(cmd, false);
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                        ++AppConsole.this.nTab;
                        return;
                    }
                    case 27: {
                        ke.consume();
                        try {
                            this.consoleDoc.replaceCommand("", false);
                            break;
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                }
                AppConsole.this.nTab = 0;
            }
            if ((kcode == 33 || kcode == 34) && ke.isControlDown()) {
                if (kid == 401) {
                    this.recallCommand(kcode == 33, true);
                }
                return;
            }
            this.pageUpBuffer = null;
            if (kcode == 38 && kid == 401 && !ke.isControlDown()) {
                this.recallCommand(true, false);
            } else if (kcode == 40 && kid == 401 && !ke.isControlDown()) {
                this.recallCommand(false, false);
            } else if ((kcode == 40 || kcode == 38) && kid == 401 && ke.isControlDown()) {
                super.processKeyEvent(new KeyEvent((Component)ke.getSource(), kid, ke.getWhen(), 0, kcode, ke.getKeyChar(), ke.getKeyLocation()));
            } else {
                super.processKeyEvent(ke);
                if (kid == 402 && ke.getModifiers() < 2 && (kcode == 32 || kcode > 40 && kcode < 400 || kcode == 8)) {
                    this.checkCommand();
                }
            }
        }

        void recallCommand(boolean up, boolean pageup) {
            String cmd;
            String string = pageup ? AppConsole.this.vwr.historyFind(this.pageUpBuffer == null ? (this.pageUpBuffer = this.consoleDoc.getCommandString()) : this.pageUpBuffer, up ? -1 : 1) : (cmd = AppConsole.this.vwr.getSetHistory(up ? -1 : 1));
            if (cmd == null) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AppConsole.this.hBar.setValue(0);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
                return;
            }
            boolean isError = false;
            try {
                if (cmd.endsWith("#??")) {
                    isError = true;
                    cmd = cmd.substring(0, cmd.indexOf("#??"));
                }
                cmd = PT.trim(cmd, ";");
                this.consoleDoc.replaceCommand(cmd, isError);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }

        synchronized void checkCommand() {
            String strCommand = this.consoleDoc.getCommandString();
            if (strCommand.length() == 0 || strCommand.charAt(0) == '!' || AppConsole.this.vwr.isScriptExecuting() || AppConsole.this.vwr.getBooleanProperty("executionPaused")) {
                return;
            }
            this.checking = true;
            this.consoleDoc.colorCommand(AppConsole.this.vwr.scriptCheck(strCommand) instanceof String ? this.consoleDoc.attError : this.consoleDoc.attUserInput);
            this.checking = false;
        }
    }

    class ExecuteCommandThread
    extends Thread {
        String strCommand;

        ExecuteCommandThread(String command) {
            this.strCommand = command;
            this.setName("appConsoleExecuteCommandThread");
        }

        @Override
        public void run() {
            try {
                while (AppConsole.this.console.checking) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception e) {
                        // empty catch block
                        break;
                    }
                }
                AppConsole.this.executeCommand(this.strCommand);
            }
            catch (Exception ie) {
                Logger.errorEx("execution command interrupted!", ie);
            }
        }
    }
}

