/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcherSupplier;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalOrder;
import org.elasticsearch.search.aggregations.support.AbstractValuesSourceParser;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.aggregations.support.XContentParseContext;

public class HistogramParser
extends AbstractValuesSourceParser.NumericValuesSourceParser {
    private static final ObjectParser<double[], ParseFieldMatcherSupplier> EXTENDED_BOUNDS_PARSER = new ObjectParser(Histogram.EXTENDED_BOUNDS_FIELD.getPreferredName(), () -> new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY});

    public HistogramParser() {
        super(true, true, false);
    }

    protected HistogramAggregationBuilder createFactory(String aggregationName, ValuesSourceType valuesSourceType, ValueType targetValueType, Map<ParseField, Object> otherOptions) {
        InternalOrder order;
        Long minDocCount;
        Boolean keyed;
        double[] extendedBounds;
        HistogramAggregationBuilder factory = new HistogramAggregationBuilder(aggregationName);
        Double interval = (Double)otherOptions.get(Histogram.INTERVAL_FIELD);
        if (interval == null) {
            throw new ParsingException(null, "Missing required field [interval] for histogram aggregation [" + aggregationName + "]", new Object[0]);
        }
        factory.interval(interval);
        Double offset = (Double)otherOptions.get(Histogram.OFFSET_FIELD);
        if (offset != null) {
            factory.offset(offset);
        }
        if ((extendedBounds = (double[])otherOptions.get(Histogram.EXTENDED_BOUNDS_FIELD)) != null) {
            factory.extendedBounds(extendedBounds[0], extendedBounds[1]);
        }
        if ((keyed = (Boolean)otherOptions.get(Histogram.KEYED_FIELD)) != null) {
            factory.keyed(keyed);
        }
        if ((minDocCount = (Long)otherOptions.get(Histogram.MIN_DOC_COUNT_FIELD)) != null) {
            factory.minDocCount(minDocCount);
        }
        if ((order = (InternalOrder)otherOptions.get(Histogram.ORDER_FIELD)) != null) {
            factory.order(order);
        }
        return factory;
    }

    @Override
    protected boolean token(String aggregationName, String currentFieldName, XContentParser.Token token, XContentParseContext context, Map<ParseField, Object> otherOptions) throws IOException {
        XContentParser parser = context.getParser();
        if (token.isValue()) {
            if (context.matchField(currentFieldName, Histogram.INTERVAL_FIELD)) {
                otherOptions.put(Histogram.INTERVAL_FIELD, parser.doubleValue());
                return true;
            }
            if (context.matchField(currentFieldName, Histogram.MIN_DOC_COUNT_FIELD)) {
                otherOptions.put(Histogram.MIN_DOC_COUNT_FIELD, parser.longValue());
                return true;
            }
            if (context.matchField(currentFieldName, Histogram.KEYED_FIELD)) {
                otherOptions.put(Histogram.KEYED_FIELD, parser.booleanValue());
                return true;
            }
            if (context.matchField(currentFieldName, Histogram.OFFSET_FIELD)) {
                otherOptions.put(Histogram.OFFSET_FIELD, parser.doubleValue());
                return true;
            }
            return false;
        }
        if (token == XContentParser.Token.START_OBJECT) {
            if (context.matchField(currentFieldName, Histogram.ORDER_FIELD)) {
                InternalOrder order = null;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (token != XContentParser.Token.VALUE_STRING) continue;
                    String dir = parser.text();
                    boolean asc = "asc".equals(dir);
                    if (!asc && !"desc".equals(dir)) {
                        throw new ParsingException(parser.getTokenLocation(), "Unknown order direction in aggregation [" + aggregationName + "]: [" + dir + "]. Should be either [asc] or [desc]", new Object[0]);
                    }
                    order = HistogramParser.resolveOrder(currentFieldName, asc);
                }
                otherOptions.put(Histogram.ORDER_FIELD, order);
                return true;
            }
            if (context.matchField(currentFieldName, Histogram.EXTENDED_BOUNDS_FIELD)) {
                double[] bounds = EXTENDED_BOUNDS_PARSER.apply(parser, context::getParseFieldMatcher);
                otherOptions.put(Histogram.EXTENDED_BOUNDS_FIELD, bounds);
                return true;
            }
            return false;
        }
        return false;
    }

    static InternalOrder resolveOrder(String key, boolean asc) {
        if ("_key".equals(key)) {
            return (InternalOrder)(asc ? InternalOrder.KEY_ASC : InternalOrder.KEY_DESC);
        }
        if ("_count".equals(key)) {
            return (InternalOrder)(asc ? InternalOrder.COUNT_ASC : InternalOrder.COUNT_DESC);
        }
        return new InternalOrder.Aggregation(key, asc);
    }

    static {
        EXTENDED_BOUNDS_PARSER.declareDouble((bounds, d) -> {
            bounds[0] = d;
        }, new ParseField("min", new String[0]));
        EXTENDED_BOUNDS_PARSER.declareDouble((bounds, d) -> {
            bounds[1] = d;
        }, new ParseField("max", new String[0]));
    }
}

