/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4;

import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.cursors.IntCursor;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.oio.OioServerSocketChannel;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.timeout.ReadTimeoutException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.NetworkExceptionHelper;
import org.elasticsearch.common.transport.PortsRange;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.http.BindHttpException;
import org.elasticsearch.http.HttpInfo;
import org.elasticsearch.http.HttpServerAdapter;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.HttpStats;
import org.elasticsearch.http.HttpTransportSettings;
import org.elasticsearch.http.netty4.Netty4HttpRequestHandler;
import org.elasticsearch.http.netty4.cors.Netty4CorsConfig;
import org.elasticsearch.http.netty4.cors.Netty4CorsConfigBuilder;
import org.elasticsearch.http.netty4.cors.Netty4CorsHandler;
import org.elasticsearch.http.netty4.pipelining.HttpPipeliningHandler;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BindTransportException;
import org.elasticsearch.transport.netty4.Netty4OpenChannelsHandler;
import org.elasticsearch.transport.netty4.Netty4Utils;

public class Netty4HttpServerTransport
extends AbstractLifecycleComponent
implements HttpServerTransport {
    public static Setting<ByteSizeValue> SETTING_HTTP_NETTY_MAX_CUMULATION_BUFFER_CAPACITY;
    public static Setting<Integer> SETTING_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS;
    public static final Setting<Integer> SETTING_HTTP_WORKER_COUNT;
    public static final Setting<Boolean> SETTING_HTTP_TCP_NO_DELAY;
    public static final Setting<Boolean> SETTING_HTTP_TCP_KEEP_ALIVE;
    public static final Setting<Boolean> SETTING_HTTP_TCP_BLOCKING_SERVER;
    public static final Setting<Boolean> SETTING_HTTP_TCP_REUSE_ADDRESS;
    public static final Setting<ByteSizeValue> SETTING_HTTP_TCP_SEND_BUFFER_SIZE;
    public static final Setting<ByteSizeValue> SETTING_HTTP_TCP_RECEIVE_BUFFER_SIZE;
    public static final Setting<ByteSizeValue> SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_SIZE;
    public static final Setting<ByteSizeValue> SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_MIN;
    public static final Setting<ByteSizeValue> SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_MAX;
    protected final NetworkService networkService;
    protected final BigArrays bigArrays;
    protected final ByteSizeValue maxContentLength;
    protected final ByteSizeValue maxInitialLineLength;
    protected final ByteSizeValue maxHeaderSize;
    protected final ByteSizeValue maxChunkSize;
    protected final int workerCount;
    protected final boolean blockingServer;
    protected final boolean pipelining;
    protected final int pipeliningMaxEvents;
    protected final boolean compression;
    protected final int compressionLevel;
    protected final boolean resetCookies;
    protected final PortsRange port;
    protected final String[] bindHosts;
    protected final String[] publishHosts;
    protected final boolean detailedErrorsEnabled;
    protected final ThreadPool threadPool;
    protected final boolean tcpNoDelay;
    protected final boolean tcpKeepAlive;
    protected final boolean reuseAddress;
    protected final ByteSizeValue tcpSendBufferSize;
    protected final ByteSizeValue tcpReceiveBufferSize;
    protected final RecvByteBufAllocator recvByteBufAllocator;
    protected final ByteSizeValue maxCumulationBufferCapacity;
    protected final int maxCompositeBufferComponents;
    protected volatile ServerBootstrap serverBootstrap;
    protected volatile BoundTransportAddress boundAddress;
    protected final List<Channel> serverChannels = new ArrayList<Channel>();
    Netty4OpenChannelsHandler serverOpenChannels;
    protected volatile HttpServerAdapter httpServerAdapter;
    private final Netty4CorsConfig corsConfig;

    @Inject
    public Netty4HttpServerTransport(Settings settings, NetworkService networkService, BigArrays bigArrays, ThreadPool threadPool) {
        super(settings);
        this.networkService = networkService;
        this.bigArrays = bigArrays;
        this.threadPool = threadPool;
        ByteSizeValue maxContentLength = (ByteSizeValue)HttpTransportSettings.SETTING_HTTP_MAX_CONTENT_LENGTH.get(settings);
        this.maxChunkSize = (ByteSizeValue)HttpTransportSettings.SETTING_HTTP_MAX_CHUNK_SIZE.get(settings);
        this.maxHeaderSize = (ByteSizeValue)HttpTransportSettings.SETTING_HTTP_MAX_HEADER_SIZE.get(settings);
        this.maxInitialLineLength = (ByteSizeValue)HttpTransportSettings.SETTING_HTTP_MAX_INITIAL_LINE_LENGTH.get(settings);
        this.resetCookies = (Boolean)HttpTransportSettings.SETTING_HTTP_RESET_COOKIES.get(settings);
        this.maxCumulationBufferCapacity = (ByteSizeValue)SETTING_HTTP_NETTY_MAX_CUMULATION_BUFFER_CAPACITY.get(settings);
        this.maxCompositeBufferComponents = (Integer)SETTING_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS.get(settings);
        this.workerCount = (Integer)SETTING_HTTP_WORKER_COUNT.get(settings);
        this.blockingServer = (Boolean)SETTING_HTTP_TCP_BLOCKING_SERVER.get(settings);
        this.port = (PortsRange)HttpTransportSettings.SETTING_HTTP_PORT.get(settings);
        this.bindHosts = ((List)HttpTransportSettings.SETTING_HTTP_BIND_HOST.get(settings)).toArray(Strings.EMPTY_ARRAY);
        this.publishHosts = ((List)HttpTransportSettings.SETTING_HTTP_PUBLISH_HOST.get(settings)).toArray(Strings.EMPTY_ARRAY);
        this.tcpNoDelay = (Boolean)SETTING_HTTP_TCP_NO_DELAY.get(settings);
        this.tcpKeepAlive = (Boolean)SETTING_HTTP_TCP_KEEP_ALIVE.get(settings);
        this.reuseAddress = (Boolean)SETTING_HTTP_TCP_REUSE_ADDRESS.get(settings);
        this.tcpSendBufferSize = (ByteSizeValue)SETTING_HTTP_TCP_SEND_BUFFER_SIZE.get(settings);
        this.tcpReceiveBufferSize = (ByteSizeValue)SETTING_HTTP_TCP_RECEIVE_BUFFER_SIZE.get(settings);
        this.detailedErrorsEnabled = (Boolean)HttpTransportSettings.SETTING_HTTP_DETAILED_ERRORS_ENABLED.get(settings);
        ByteSizeValue receivePredictorMin = (ByteSizeValue)SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_MIN.get(settings);
        ByteSizeValue receivePredictorMax = (ByteSizeValue)SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_MAX.get(settings);
        this.recvByteBufAllocator = receivePredictorMax.getBytes() == receivePredictorMin.getBytes() ? new FixedRecvByteBufAllocator(Math.toIntExact(receivePredictorMax.getBytes())) : new AdaptiveRecvByteBufAllocator(Math.toIntExact(receivePredictorMin.getBytes()), Math.toIntExact(receivePredictorMin.getBytes()), Math.toIntExact(receivePredictorMax.getBytes()));
        this.compression = (Boolean)HttpTransportSettings.SETTING_HTTP_COMPRESSION.get(settings);
        this.compressionLevel = (Integer)HttpTransportSettings.SETTING_HTTP_COMPRESSION_LEVEL.get(settings);
        this.pipelining = (Boolean)HttpTransportSettings.SETTING_PIPELINING.get(settings);
        this.pipeliningMaxEvents = (Integer)HttpTransportSettings.SETTING_PIPELINING_MAX_EVENTS.get(settings);
        this.corsConfig = Netty4HttpServerTransport.buildCorsConfig(settings);
        if (maxContentLength.getBytes() > Integer.MAX_VALUE) {
            this.logger.warn("maxContentLength[{}] set to high value, resetting it to [100mb]", (Object)maxContentLength);
            maxContentLength = new ByteSizeValue(100L, ByteSizeUnit.MB);
        }
        this.maxContentLength = maxContentLength;
        this.logger.debug("using max_chunk_size[{}], max_header_size[{}], max_initial_line_length[{}], max_content_length[{}], receive_predictor[{}->{}], pipelining[{}], pipelining_max_events[{}]", (Object)this.maxChunkSize, (Object)this.maxHeaderSize, (Object)this.maxInitialLineLength, (Object)this.maxContentLength, (Object)receivePredictorMin, (Object)receivePredictorMax, (Object)this.pipelining, (Object)this.pipeliningMaxEvents);
    }

    public Settings settings() {
        return this.settings;
    }

    public void httpServerAdapter(HttpServerAdapter httpServerAdapter) {
        this.httpServerAdapter = httpServerAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() {
        boolean success = false;
        try {
            ByteSizeValue tcpReceiveBufferSize;
            this.serverOpenChannels = new Netty4OpenChannelsHandler(this.logger);
            this.serverBootstrap = new ServerBootstrap();
            if (this.blockingServer) {
                this.serverBootstrap.group((EventLoopGroup)new OioEventLoopGroup(this.workerCount, EsExecutors.daemonThreadFactory((Settings)this.settings, (String)"http_server_worker")));
                this.serverBootstrap.channel(OioServerSocketChannel.class);
            } else {
                this.serverBootstrap.group((EventLoopGroup)new NioEventLoopGroup(this.workerCount, EsExecutors.daemonThreadFactory((Settings)this.settings, (String)"http_server_worker")));
                this.serverBootstrap.channel(NioServerSocketChannel.class);
            }
            this.serverBootstrap.childHandler(this.configureServerChannelHandler());
            this.serverBootstrap.childOption(ChannelOption.TCP_NODELAY, SETTING_HTTP_TCP_NO_DELAY.get(this.settings));
            this.serverBootstrap.childOption(ChannelOption.SO_KEEPALIVE, SETTING_HTTP_TCP_KEEP_ALIVE.get(this.settings));
            ByteSizeValue tcpSendBufferSize = (ByteSizeValue)SETTING_HTTP_TCP_SEND_BUFFER_SIZE.get(this.settings);
            if (tcpSendBufferSize.getBytes() > 0L) {
                this.serverBootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)Math.toIntExact(tcpSendBufferSize.getBytes()));
            }
            if ((tcpReceiveBufferSize = (ByteSizeValue)SETTING_HTTP_TCP_RECEIVE_BUFFER_SIZE.get(this.settings)).getBytes() > 0L) {
                this.serverBootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)Math.toIntExact(tcpReceiveBufferSize.getBytes()));
            }
            this.serverBootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)this.recvByteBufAllocator);
            this.serverBootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)this.recvByteBufAllocator);
            boolean reuseAddress = (Boolean)SETTING_HTTP_TCP_REUSE_ADDRESS.get(this.settings);
            this.serverBootstrap.option(ChannelOption.SO_REUSEADDR, (Object)reuseAddress);
            this.serverBootstrap.childOption(ChannelOption.SO_REUSEADDR, (Object)reuseAddress);
            this.boundAddress = this.createBoundHttpAddress();
            success = true;
        }
        finally {
            if (!success) {
                this.doStop();
            }
        }
    }

    private BoundTransportAddress createBoundHttpAddress() {
        InetAddress publishInetAddress;
        InetAddress[] hostAddresses;
        try {
            hostAddresses = this.networkService.resolveBindHostAddresses(this.bindHosts);
        }
        catch (IOException e) {
            throw new BindHttpException("Failed to resolve host [" + Arrays.toString(this.bindHosts) + "]", (Throwable)e);
        }
        ArrayList<InetSocketTransportAddress> boundAddresses = new ArrayList<InetSocketTransportAddress>(hostAddresses.length);
        for (InetAddress address : hostAddresses) {
            boundAddresses.add(this.bindAddress(address));
        }
        try {
            publishInetAddress = this.networkService.resolvePublishHostAddresses(this.publishHosts);
        }
        catch (Exception e) {
            throw new BindTransportException("Failed to resolve publish address", (Throwable)e);
        }
        int publishPort = Netty4HttpServerTransport.resolvePublishPort(this.settings, boundAddresses, publishInetAddress);
        InetSocketAddress publishAddress = new InetSocketAddress(publishInetAddress, publishPort);
        return new BoundTransportAddress(boundAddresses.toArray(new TransportAddress[0]), (TransportAddress)new InetSocketTransportAddress(publishAddress));
    }

    static int resolvePublishPort(Settings settings, List<InetSocketTransportAddress> boundAddresses, InetAddress publishInetAddress) {
        int publishPort = (Integer)HttpTransportSettings.SETTING_HTTP_PUBLISH_PORT.get(settings);
        if (publishPort < 0) {
            for (InetSocketTransportAddress boundAddress : boundAddresses) {
                InetAddress boundInetAddress = boundAddress.address().getAddress();
                if (!boundInetAddress.isAnyLocalAddress() && !boundInetAddress.equals(publishInetAddress)) continue;
                publishPort = boundAddress.getPort();
                break;
            }
        }
        if (publishPort < 0) {
            IntHashSet ports = new IntHashSet();
            for (InetSocketTransportAddress boundAddress : boundAddresses) {
                ports.add(boundAddress.getPort());
            }
            if (ports.size() == 1) {
                publishPort = ((IntCursor)ports.iterator().next()).value;
            }
        }
        if (publishPort < 0) {
            throw new BindHttpException("Failed to auto-resolve http publish port, multiple bound addresses " + boundAddresses + " with distinct ports and none of them matched the publish address (" + publishInetAddress + "). Please specify a unique port by setting " + HttpTransportSettings.SETTING_HTTP_PORT.getKey() + " or " + HttpTransportSettings.SETTING_HTTP_PUBLISH_PORT.getKey());
        }
        return publishPort;
    }

    static Netty4CorsConfig buildCorsConfig(Settings settings) {
        Pattern p;
        if (!((Boolean)HttpTransportSettings.SETTING_CORS_ENABLED.get(settings)).booleanValue()) {
            return Netty4CorsConfigBuilder.forOrigins(new String[0]).disable().build();
        }
        String origin = (String)HttpTransportSettings.SETTING_CORS_ALLOW_ORIGIN.get(settings);
        Netty4CorsConfigBuilder builder = Strings.isNullOrEmpty((String)origin) ? Netty4CorsConfigBuilder.forOrigins(new String[0]) : (origin.equals("*") ? Netty4CorsConfigBuilder.forAnyOrigin() : ((p = RestUtils.checkCorsSettingForRegex((String)origin)) == null ? Netty4CorsConfigBuilder.forOrigins(RestUtils.corsSettingAsArray((String)origin)) : Netty4CorsConfigBuilder.forPattern(p)));
        if (((Boolean)HttpTransportSettings.SETTING_CORS_ALLOW_CREDENTIALS.get(settings)).booleanValue()) {
            builder.allowCredentials();
        }
        String[] strMethods = Strings.splitStringByCommaToArray((String)((String)HttpTransportSettings.SETTING_CORS_ALLOW_METHODS.get(settings)));
        HttpMethod[] methods = (HttpMethod[])Arrays.asList(strMethods).stream().map(HttpMethod::valueOf).toArray(HttpMethod[]::new);
        return builder.allowedRequestMethods(methods).maxAge(((Integer)HttpTransportSettings.SETTING_CORS_MAX_AGE.get(settings)).intValue()).allowedRequestHeaders(Strings.splitStringByCommaToArray((String)((String)HttpTransportSettings.SETTING_CORS_ALLOW_HEADERS.get(settings)))).shortCircuit().build();
    }

    private InetSocketTransportAddress bindAddress(InetAddress hostAddress) {
        AtomicReference boundSocket = new AtomicReference();
        AtomicReference lastException = new AtomicReference();
        boolean success = this.port.iterate(portNumber -> {
            try {
                List<Channel> list = this.serverChannels;
                synchronized (list) {
                    ChannelFuture future = this.serverBootstrap.bind((SocketAddress)new InetSocketAddress(hostAddress, portNumber)).sync();
                    this.serverChannels.add(future.channel());
                    boundSocket.set((InetSocketAddress)future.channel().localAddress());
                }
            }
            catch (Exception e) {
                lastException.set(e);
                return false;
            }
            return true;
        });
        if (!success) {
            throw new BindHttpException("Failed to bind to [" + this.port.getPortRangeString() + "]", (Throwable)lastException.get());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Bound http to address {{}}", (Object)NetworkAddress.format((InetSocketAddress)((InetSocketAddress)boundSocket.get())));
        }
        return new InetSocketTransportAddress((InetSocketAddress)boundSocket.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() {
        List<Channel> list = this.serverChannels;
        synchronized (list) {
            if (!this.serverChannels.isEmpty()) {
                try {
                    Netty4Utils.closeChannels(this.serverChannels);
                }
                catch (IOException e) {
                    this.logger.trace("exception while closing channels", (Throwable)e);
                }
                this.serverChannels.clear();
            }
        }
        if (this.serverOpenChannels != null) {
            this.serverOpenChannels.close();
            this.serverOpenChannels = null;
        }
        if (this.serverBootstrap != null) {
            this.serverBootstrap.config().group().shutdownGracefully(0L, 5L, TimeUnit.SECONDS).awaitUninterruptibly();
            this.serverBootstrap = null;
        }
    }

    protected void doClose() {
    }

    public BoundTransportAddress boundAddress() {
        return this.boundAddress;
    }

    public HttpInfo info() {
        BoundTransportAddress boundTransportAddress = this.boundAddress();
        if (boundTransportAddress == null) {
            return null;
        }
        return new HttpInfo(boundTransportAddress, this.maxContentLength.getBytes());
    }

    public HttpStats stats() {
        Netty4OpenChannelsHandler channels = this.serverOpenChannels;
        return new HttpStats(channels == null ? 0L : channels.numberOfOpenChannels(), channels == null ? 0L : channels.totalChannels());
    }

    public Netty4CorsConfig getCorsConfig() {
        return this.corsConfig;
    }

    protected void dispatchRequest(RestRequest request, RestChannel channel) {
        this.httpServerAdapter.dispatchRequest(request, channel, this.threadPool.getThreadContext());
    }

    protected void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof ReadTimeoutException) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Connection timeout [{}]", (Object)ctx.channel().remoteAddress());
            }
            ctx.channel().close();
        } else {
            if (!this.lifecycle.started()) {
                return;
            }
            if (!NetworkExceptionHelper.isCloseConnectionException((Throwable)cause)) {
                this.logger.warn(() -> new ParameterizedMessage("caught exception while handling client http traffic, closing connection {}", (Object)ctx.channel()), cause);
                ctx.channel().close();
            } else {
                this.logger.debug(() -> new ParameterizedMessage("caught exception while handling client http traffic, closing connection {}", (Object)ctx.channel()), cause);
                ctx.channel().close();
            }
        }
    }

    public ChannelHandler configureServerChannelHandler() {
        return new HttpChannelHandler(this, this.detailedErrorsEnabled, this.threadPool.getThreadContext());
    }

    static {
        Netty4Utils.setup();
        SETTING_HTTP_NETTY_MAX_CUMULATION_BUFFER_CAPACITY = Setting.byteSizeSetting((String)"http.netty.max_cumulation_buffer_capacity", (ByteSizeValue)new ByteSizeValue(-1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
        SETTING_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS = Setting.intSetting((String)"http.netty.max_composite_buffer_components", (int)-1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
        SETTING_HTTP_WORKER_COUNT = new Setting("http.netty.worker_count", s -> Integer.toString(EsExecutors.boundedNumberOfProcessors((Settings)s) * 2), s -> Setting.parseInt((String)s, (int)1, (String)"http.netty.worker_count"), new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
        SETTING_HTTP_TCP_NO_DELAY = Setting.boolSetting((String)"http.tcp_no_delay", (Setting)NetworkService.TcpSettings.TCP_NO_DELAY, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
        SETTING_HTTP_TCP_KEEP_ALIVE = Setting.boolSetting((String)"http.tcp.keep_alive", (Setting)NetworkService.TcpSettings.TCP_KEEP_ALIVE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
        SETTING_HTTP_TCP_BLOCKING_SERVER = Setting.boolSetting((String)"http.tcp.blocking_server", (Setting)NetworkService.TcpSettings.TCP_BLOCKING_SERVER, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
        SETTING_HTTP_TCP_REUSE_ADDRESS = Setting.boolSetting((String)"http.tcp.reuse_address", (Setting)NetworkService.TcpSettings.TCP_REUSE_ADDRESS, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
        SETTING_HTTP_TCP_SEND_BUFFER_SIZE = Setting.byteSizeSetting((String)"http.tcp.send_buffer_size", (Setting)NetworkService.TcpSettings.TCP_SEND_BUFFER_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
        SETTING_HTTP_TCP_RECEIVE_BUFFER_SIZE = Setting.byteSizeSetting((String)"http.tcp.receive_buffer_size", (Setting)NetworkService.TcpSettings.TCP_RECEIVE_BUFFER_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
        SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_SIZE = Setting.byteSizeSetting((String)"transport.netty.receive_predictor_size", settings -> {
            long defaultReceiverPredictor = 524288L;
            if (JvmInfo.jvmInfo().getMem().getDirectMemoryMax().getBytes() > 0L) {
                long l = (long)(0.3 * (double)JvmInfo.jvmInfo().getMem().getDirectMemoryMax().getBytes() / (double)((Integer)SETTING_HTTP_WORKER_COUNT.get(settings)).intValue());
                defaultReceiverPredictor = Math.min(defaultReceiverPredictor, Math.max(l, 65536L));
            }
            return new ByteSizeValue(defaultReceiverPredictor).toString();
        }, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_MIN = Setting.byteSizeSetting((String)"http.netty.receive_predictor_min", SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_MAX = Setting.byteSizeSetting((String)"http.netty.receive_predictor_max", SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    }

    protected static class HttpChannelHandler
    extends ChannelInitializer<Channel> {
        private final Netty4HttpServerTransport transport;
        private final Netty4HttpRequestHandler requestHandler;

        protected HttpChannelHandler(Netty4HttpServerTransport transport, boolean detailedErrorsEnabled, ThreadContext threadContext) {
            this.transport = transport;
            this.requestHandler = new Netty4HttpRequestHandler(transport, detailedErrorsEnabled, threadContext);
        }

        protected void initChannel(Channel ch) throws Exception {
            ch.pipeline().addLast("openChannels", (ChannelHandler)this.transport.serverOpenChannels);
            HttpRequestDecoder decoder = new HttpRequestDecoder(Math.toIntExact(this.transport.maxInitialLineLength.getBytes()), Math.toIntExact(this.transport.maxHeaderSize.getBytes()), Math.toIntExact(this.transport.maxChunkSize.getBytes()));
            decoder.setCumulator(ByteToMessageDecoder.COMPOSITE_CUMULATOR);
            ch.pipeline().addLast("decoder", (ChannelHandler)decoder);
            ch.pipeline().addLast("decoder_compress", (ChannelHandler)new HttpContentDecompressor());
            ch.pipeline().addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
            HttpObjectAggregator aggregator = new HttpObjectAggregator(Math.toIntExact(this.transport.maxContentLength.getBytes()));
            if (this.transport.maxCompositeBufferComponents != -1) {
                aggregator.setMaxCumulationBufferComponents(this.transport.maxCompositeBufferComponents);
            }
            ch.pipeline().addLast("aggregator", (ChannelHandler)aggregator);
            if (this.transport.compression) {
                ch.pipeline().addLast("encoder_compress", (ChannelHandler)new HttpContentCompressor(this.transport.compressionLevel));
            }
            if (((Boolean)HttpTransportSettings.SETTING_CORS_ENABLED.get(this.transport.settings())).booleanValue()) {
                ch.pipeline().addLast("cors", (ChannelHandler)new Netty4CorsHandler(this.transport.getCorsConfig()));
            }
            if (this.transport.pipelining) {
                ch.pipeline().addLast("pipelining", (ChannelHandler)new HttpPipeliningHandler(this.transport.pipeliningMaxEvents));
            }
            ch.pipeline().addLast("handler", (ChannelHandler)this.requestHandler);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            Netty4Utils.maybeDie(cause);
            super.exceptionCaught(ctx, cause);
        }
    }
}

