/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.ILambda;
import org.objectweb.asm.Type;

final class PSubDefCall
extends AExpression {
    private final String name;
    private final List<AExpression> arguments;
    private StringBuilder recipe = null;
    private List<String> pointers = new ArrayList<String>();

    PSubDefCall(Location location, String name, List<AExpression> arguments) {
        super(location);
        this.name = Objects.requireNonNull(name);
        this.arguments = Objects.requireNonNull(arguments);
    }

    @Override
    void extractVariables(Set<String> variables) {
        throw this.createError(new IllegalStateException("Illegal tree structure."));
    }

    @Override
    void analyze(Locals locals) {
        this.recipe = new StringBuilder();
        int totalCaptures = 0;
        for (int argument = 0; argument < this.arguments.size(); ++argument) {
            AExpression expression = this.arguments.get(argument);
            expression.internal = true;
            expression.analyze(locals);
            if (expression instanceof ILambda) {
                ILambda lambda = (ILambda)((Object)expression);
                this.pointers.add(lambda.getPointer());
                char ch = (char)(argument + totalCaptures);
                this.recipe.append(ch);
                totalCaptures += lambda.getCaptureCount();
            }
            expression.expected = expression.actual;
            this.arguments.set(argument, expression.cast(locals));
        }
        this.actual = this.expected == null || this.explicit ? Definition.DEF_TYPE : this.expected;
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        writer.writeDebugInfo(this.location);
        ArrayList<Type> parameterTypes = new ArrayList<Type>();
        parameterTypes.add(Definition.DEF_TYPE.type);
        for (AExpression argument : this.arguments) {
            parameterTypes.add(argument.actual.type);
            if (argument instanceof ILambda) {
                ILambda lambda = (ILambda)((Object)argument);
                for (Type capture : lambda.getCaptures()) {
                    parameterTypes.add(capture);
                }
            }
            argument.write(writer, globals);
        }
        Type methodType = Type.getMethodType((Type)this.actual.type, (Type[])parameterTypes.toArray(new Type[0]));
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.recipe.toString());
        args.addAll(this.pointers);
        writer.invokeDefCall(this.name, methodType, 0, args.toArray());
    }
}

