/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.DefaultFileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.DefaultFileDetails;
import org.gradle.api.internal.changedetection.state.DirSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.FileDetails;
import org.gradle.api.internal.changedetection.state.FileHashSnapshot;
import org.gradle.api.internal.changedetection.state.FileSnapshotter;
import org.gradle.api.internal.changedetection.state.IncrementalFileSnapshot;
import org.gradle.api.internal.changedetection.state.MissingFileSnapshot;
import org.gradle.api.internal.changedetection.state.MissingFileVisitDetails;
import org.gradle.api.internal.changedetection.state.NormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.SnapshotNormalizationStrategy;
import org.gradle.api.internal.changedetection.state.TaskFilePropertyCompareStrategy;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionVisitor;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.file.collections.SingletonFileTree;
import org.gradle.api.internal.tasks.TaskFilePropertySpec;
import org.gradle.api.internal.tasks.execution.TaskOutputsGenerationListener;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.SerializerRegistry;

public class DefaultFileCollectionSnapshotter
implements FileCollectionSnapshotter,
TaskOutputsGenerationListener {
    private static final DefaultFileCollectionSnapshot EMPTY_SNAPSHOT = new DefaultFileCollectionSnapshot((Map<String, NormalizedFileSnapshot>)ImmutableMap.of(), TaskFilePropertyCompareStrategy.UNORDERED, true);
    private final FileSnapshotter snapshotter;
    private final StringInterner stringInterner;
    private final FileSystem fileSystem;
    private final DirectoryFileTreeFactory directoryFileTreeFactory;
    private final Map<String, DefaultFileDetails> rootFiles = new ConcurrentHashMap<String, DefaultFileDetails>();

    public DefaultFileCollectionSnapshotter(FileSnapshotter snapshotter, StringInterner stringInterner, FileSystem fileSystem, DirectoryFileTreeFactory directoryFileTreeFactory) {
        this.snapshotter = snapshotter;
        this.stringInterner = stringInterner;
        this.fileSystem = fileSystem;
        this.directoryFileTreeFactory = directoryFileTreeFactory;
    }

    public void beforeTaskOutputsGenerated() {
        this.rootFiles.clear();
    }

    public FileCollectionSnapshot emptySnapshot() {
        return EMPTY_SNAPSHOT;
    }

    public void registerSerializers(SerializerRegistry registry) {
        registry.register(DefaultFileCollectionSnapshot.class, (Serializer)new DefaultFileCollectionSnapshot.SerializerImpl(this.stringInterner));
    }

    public FileCollectionSnapshot snapshot(FileCollection input, TaskFilePropertyCompareStrategy compareStrategy, SnapshotNormalizationStrategy snapshotNormalizationStrategy) {
        String absolutePath;
        LinkedList fileTreeElements = Lists.newLinkedList();
        ArrayList missingFiles = Lists.newArrayList();
        FileCollectionInternal fileCollection = (FileCollectionInternal)input;
        FileCollectionVisitorImpl visitor = new FileCollectionVisitorImpl(fileTreeElements, missingFiles);
        fileCollection.visitRootElements(visitor);
        if (fileTreeElements.isEmpty() && missingFiles.isEmpty()) {
            return this.emptySnapshot();
        }
        LinkedHashMap snapshots = Maps.newLinkedHashMap();
        for (DefaultFileDetails fileDetails : fileTreeElements) {
            IncrementalFileSnapshot snapshot;
            NormalizedFileSnapshot normalizedSnapshot;
            absolutePath = fileDetails.path;
            if (snapshots.containsKey(absolutePath) || (normalizedSnapshot = snapshotNormalizationStrategy.getNormalizedSnapshot(fileDetails, snapshot = fileDetails.type == FileDetails.FileType.Directory ? DirSnapshot.getInstance() : new FileHashSnapshot(this.snapshotter.snapshot(fileDetails.details).getHash(), fileDetails.details.getLastModified()), this.stringInterner)) == null) continue;
            snapshots.put(absolutePath, normalizedSnapshot);
        }
        for (DefaultFileDetails missingFileDetails : missingFiles) {
            absolutePath = missingFileDetails.path;
            if (snapshots.containsKey(absolutePath)) continue;
            snapshots.put(absolutePath, snapshotNormalizationStrategy.getNormalizedSnapshot(missingFileDetails, MissingFileSnapshot.getInstance(), this.stringInterner));
        }
        return new DefaultFileCollectionSnapshot(snapshots, compareStrategy, snapshotNormalizationStrategy.isPathAbsolute());
    }

    public FileCollectionSnapshot snapshot(TaskFilePropertySpec propertySpec) {
        return this.snapshot(propertySpec.getPropertyFiles(), propertySpec.getCompareStrategy(), propertySpec.getSnapshotNormalizationStrategy());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileCollectionVisitorImpl
    implements FileCollectionVisitor,
    FileVisitor {
        private final List<DefaultFileDetails> fileTreeElements;
        private final List<DefaultFileDetails> missingFiles;

        FileCollectionVisitorImpl(List<DefaultFileDetails> fileTreeElements, List<DefaultFileDetails> missingFiles) {
            this.fileTreeElements = fileTreeElements;
            this.missingFiles = missingFiles;
        }

        @Override
        public void visitCollection(FileCollectionInternal fileCollection) {
            block5: for (File file : fileCollection) {
                DefaultFileDetails details = (DefaultFileDetails)DefaultFileCollectionSnapshotter.this.rootFiles.get(file.getPath());
                if (details == null) {
                    details = this.calculateDetails(file);
                    DefaultFileCollectionSnapshotter.this.rootFiles.put(details.path, details);
                }
                switch (details.type) {
                    case RegularFile: {
                        this.fileTreeElements.add(details);
                        continue block5;
                    }
                    case Directory: {
                        this.fileTreeElements.add(details);
                        this.visitDirectoryTree(DefaultFileCollectionSnapshotter.this.directoryFileTreeFactory.create(file));
                        continue block5;
                    }
                    case Missing: {
                        this.missingFiles.add(details);
                        continue block5;
                    }
                }
                throw new IllegalArgumentException();
            }
        }

        private DefaultFileDetails calculateDetails(File file) {
            String path = this.getPath(file);
            if (!file.exists()) {
                return new DefaultFileDetails(path, FileDetails.FileType.Missing, new MissingFileVisitDetails(file));
            }
            if (file.isDirectory()) {
                return new DefaultFileDetails(path, FileDetails.FileType.Directory, new SingletonFileTree.SingletonFileVisitDetails(file, DefaultFileCollectionSnapshotter.this.fileSystem, true));
            }
            return new DefaultFileDetails(path, FileDetails.FileType.RegularFile, new SingletonFileTree.SingletonFileVisitDetails(file, DefaultFileCollectionSnapshotter.this.fileSystem, false));
        }

        private String getPath(File file) {
            return DefaultFileCollectionSnapshotter.this.stringInterner.intern(file.getAbsolutePath());
        }

        @Override
        public void visitTree(FileTreeInternal fileTree) {
            fileTree.visitTreeOrBackingFile(this);
        }

        @Override
        public void visitDirectoryTree(DirectoryFileTree directoryTree) {
            directoryTree.visit(this);
        }

        @Override
        public void visitDir(FileVisitDetails dirDetails) {
            this.fileTreeElements.add(new DefaultFileDetails(this.getPath(dirDetails.getFile()), FileDetails.FileType.Directory, dirDetails));
        }

        @Override
        public void visitFile(FileVisitDetails fileDetails) {
            this.fileTreeElements.add(new DefaultFileDetails(this.getPath(fileDetails.getFile()), FileDetails.FileType.RegularFile, fileDetails));
        }
    }
}

