/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.datatransfer.importers;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.TransferHandler;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.datatransfer.importers.AbstractOsmDataPaster;
import org.openstreetmap.josm.gui.io.DownloadPrimitivesWithReferrersTask;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

public class OsmLinkPaster
extends AbstractOsmDataPaster {
    private static final BooleanProperty PASTE_REFERRERS = new BooleanProperty("paste.url.download-referrers", true);
    private static final String OSM_SERVER = "^https?\\://(\\w+\\.)?(osm|openstreetmap)\\.org/";

    public OsmLinkPaster() {
        super(DataFlavor.stringFlavor);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport, OsmDataLayer osmDataLayer, EastNorth eastNorth) throws UnsupportedFlavorException, IOException {
        Component component;
        if (!this.supports(transferSupport)) {
            throw new UnsupportedFlavorException(this.df);
        }
        String string = (String)transferSupport.getTransferable().getTransferData(this.df);
        List<PrimitiveId> list = OsmLinkPaster.parseIds(string);
        if (!list.isEmpty()) {
            Main.worker.submit(new DownloadPrimitivesWithReferrersTask(osmDataLayer == null, list, PASTE_REFERRERS.get(), PASTE_REFERRERS.get(), null, null));
            return true;
        }
        LatLon latLon = OsmLinkPaster.parseLatLon(string);
        if (latLon != null && (component = transferSupport.getComponent()) instanceof MapView) {
            ((MapView)component).zoomTo(latLon);
        }
        return false;
    }

    protected static LatLon parseLatLon(String string) {
        Matcher matcher = Pattern.compile("^https?\\://(\\w+\\.)?(osm|openstreetmap)\\.org/#map=(?<zoom>\\d+)/(?<lat>-?\\d+\\.\\d+)/(?<lon>-?\\d+\\.\\d+)$").matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        return new LatLon(Double.parseDouble(matcher.group("lat")), Double.parseDouble(matcher.group("lon")));
    }

    static List<PrimitiveId> parseIds(String string) {
        OsmPrimitiveType osmPrimitiveType;
        Matcher matcher = Pattern.compile("^https?\\://(\\w+\\.)?(osm|openstreetmap)\\.org/(?<type>node|way|relation)/(?<id>\\d+)(\\/.*)?$").matcher(string);
        if (!matcher.matches()) {
            return Collections.emptyList();
        }
        switch (matcher.group("type")) {
            case "way": {
                osmPrimitiveType = OsmPrimitiveType.WAY;
                break;
            }
            case "node": {
                osmPrimitiveType = OsmPrimitiveType.NODE;
                break;
            }
            case "relation": {
                osmPrimitiveType = OsmPrimitiveType.RELATION;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return Collections.singletonList(new SimplePrimitiveId(Long.parseLong(matcher.group("id")), osmPrimitiveType));
    }
}

