/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.gui.history.HistoryBrowserDialog;
import org.openstreetmap.josm.gui.history.HistoryLoadTask;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.WindowGeometry;
import org.openstreetmap.josm.tools.bugreport.BugReportExceptionHandler;

public final class HistoryBrowserDialogManager
implements LayerManager.LayerChangeListener {
    private static final String WINDOW_GEOMETRY_PREF = HistoryBrowserDialogManager.class.getName() + ".geometry";
    private static HistoryBrowserDialogManager instance;
    private final Map<Long, HistoryBrowserDialog> dialogs;
    private final Predicate<PrimitiveId> unloadedHistoryPredicate = new Predicate<PrimitiveId>(){
        private HistoryDataSet hds = HistoryDataSet.getInstance();

        @Override
        public boolean test(PrimitiveId primitiveId) {
            History history = this.hds.getHistory(primitiveId);
            if (history == null) {
                return true;
            }
            return !primitiveId.isNew() && history.getByVersion(primitiveId.getUniqueId()) == null;
        }
    };
    private final Predicate<PrimitiveId> notNewPredicate = primitiveId -> !primitiveId.isNew();

    public static synchronized HistoryBrowserDialogManager getInstance() {
        if (instance == null) {
            instance = new HistoryBrowserDialogManager();
        }
        return instance;
    }

    protected HistoryBrowserDialogManager() {
        this.dialogs = new HashMap<Long, HistoryBrowserDialog>();
        Main.getLayerManager().addLayerChangeListener(this);
    }

    public boolean existsDialog(long l) {
        return this.dialogs.containsKey(l);
    }

    private void show(long l, HistoryBrowserDialog historyBrowserDialog) {
        if (this.dialogs.values().contains(historyBrowserDialog)) {
            this.show(l);
        } else {
            this.placeOnScreen(historyBrowserDialog);
            historyBrowserDialog.setVisible(true);
            this.dialogs.put(l, historyBrowserDialog);
        }
    }

    private void show(long l) {
        if (this.dialogs.keySet().contains(l)) {
            this.dialogs.get(l).toFront();
        }
    }

    private boolean hasDialogWithCloseUpperLeftCorner(Point point) {
        for (HistoryBrowserDialog historyBrowserDialog : this.dialogs.values()) {
            Point point2 = historyBrowserDialog.getLocation();
            if (point.x < point2.x - 5 || point2.x + 5 < point.x || point.y < point2.y - 5 || point2.y + 5 < point.y) continue;
            return true;
        }
        return false;
    }

    private void placeOnScreen(HistoryBrowserDialog historyBrowserDialog) {
        WindowGeometry windowGeometry = new WindowGeometry(WINDOW_GEOMETRY_PREF, WindowGeometry.centerOnScreen(new Dimension(850, 500)));
        windowGeometry.applySafe(historyBrowserDialog);
        Point point = historyBrowserDialog.getLocation();
        while (this.hasDialogWithCloseUpperLeftCorner(point)) {
            point.x += 20;
            point.y += 20;
        }
        historyBrowserDialog.setLocation(point);
    }

    public void hide(HistoryBrowserDialog historyBrowserDialog) {
        Iterator<Map.Entry<Long, HistoryBrowserDialog>> iterator = this.dialogs.entrySet().iterator();
        while (iterator.hasNext()) {
            if (!Objects.equals(iterator.next().getValue(), historyBrowserDialog)) continue;
            iterator.remove();
            if (!this.dialogs.isEmpty()) break;
            new WindowGeometry(historyBrowserDialog).remember(WINDOW_GEOMETRY_PREF);
            break;
        }
        historyBrowserDialog.setVisible(false);
        historyBrowserDialog.dispose();
    }

    public void hideAll() {
        ArrayList<HistoryBrowserDialog> arrayList = new ArrayList<HistoryBrowserDialog>();
        arrayList.addAll(this.dialogs.values());
        for (HistoryBrowserDialog historyBrowserDialog : arrayList) {
            historyBrowserDialog.unlinkAsListener();
            this.hide(historyBrowserDialog);
        }
    }

    public void show(History history) {
        if (history == null) {
            return;
        }
        if (this.existsDialog(history.getId())) {
            this.show(history.getId());
        } else {
            HistoryBrowserDialog historyBrowserDialog = new HistoryBrowserDialog(history);
            this.show(history.getId(), historyBrowserDialog);
        }
    }

    @Override
    public void layerAdded(LayerManager.LayerAddEvent layerAddEvent) {
    }

    @Override
    public void layerRemoving(LayerManager.LayerRemoveEvent layerRemoveEvent) {
        if (layerRemoveEvent.getSource().getLayers().isEmpty()) {
            this.hideAll();
        }
    }

    @Override
    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent layerOrderChangeEvent) {
    }

    public void showHistory(Collection<? extends PrimitiveId> collection) {
        Runnable runnable;
        SubclassFilteredCollection subclassFilteredCollection = SubclassFilteredCollection.filter(collection, this.notNewPredicate);
        if (subclassFilteredCollection.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least one already uploaded node, way, or relation.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
            return;
        }
        SubclassFilteredCollection<PrimitiveId, PrimitiveId> subclassFilteredCollection2 = SubclassFilteredCollection.filter(collection, this.unloadedHistoryPredicate);
        if (!subclassFilteredCollection2.isEmpty()) {
            runnable = new HistoryLoadTask();
            for (PrimitiveId primitiveId : subclassFilteredCollection) {
                ((HistoryLoadTask)runnable).add(primitiveId);
            }
            Main.worker.submit(runnable);
        }
        runnable = () -> {
            try {
                for (PrimitiveId primitiveId : subclassFilteredCollection) {
                    History history = HistoryDataSet.getInstance().getHistory(primitiveId);
                    if (history == null) continue;
                    SwingUtilities.invokeLater(() -> this.show(history));
                }
            }
            catch (RuntimeException runtimeException) {
                BugReportExceptionHandler.handleException(runtimeException);
            }
        };
        Main.worker.submit(runnable);
    }
}

