/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class WindowGeometry {
    private Point topLeft;
    private Dimension extent;

    public WindowGeometry(Point point, Dimension dimension) {
        this.topLeft = point;
        this.extent = dimension;
    }

    public WindowGeometry(Rectangle rectangle) {
        this(rectangle.getLocation(), rectangle.getSize());
    }

    public WindowGeometry(Window window) {
        this(window.getLocationOnScreen(), window.getSize());
    }

    public WindowGeometry(String string) throws WindowGeometryException {
        this.initFromPreferences(string);
    }

    public WindowGeometry(String string, WindowGeometry windowGeometry) {
        try {
            this.initFromPreferences(string);
        }
        catch (WindowGeometryException windowGeometryException) {
            Main.debug(windowGeometryException);
            this.initFromWindowGeometry(windowGeometry);
        }
    }

    public static WindowGeometry centerOnScreen(Dimension dimension) {
        return WindowGeometry.centerOnScreen(dimension, "gui.geometry");
    }

    public static WindowGeometry centerOnScreen(Dimension dimension, String string) {
        Rectangle rectangle = string != null ? WindowGeometry.getScreenInfo(string) : WindowGeometry.getFullScreenInfo();
        Point point = new Point(rectangle.x + Math.max(0, (rectangle.width - dimension.width) / 2), rectangle.y + Math.max(0, (rectangle.height - dimension.height) / 2));
        return new WindowGeometry(point, dimension);
    }

    public static WindowGeometry centerInWindow(Component component, Dimension dimension) {
        while (component != null && !(component instanceof Window)) {
            component = component.getParent();
        }
        if (component == null) {
            return new WindowGeometry(new Point(0, 0), dimension);
        }
        Window window = (Window)component;
        Point point = new Point(Math.max(0, (window.getSize().width - dimension.width) / 2), Math.max(0, (window.getSize().height - dimension.height) / 2));
        point.x += window.getLocation().x;
        point.y += window.getLocation().y;
        return new WindowGeometry(point, dimension);
    }

    public void fixScreen(Window window) {
        Rectangle rectangle = WindowGeometry.getScreenInfo(this.getRectangle());
        Rectangle rectangle2 = WindowGeometry.getScreenInfo(new Rectangle(window.getLocationOnScreen(), window.getSize()));
        if (rectangle.x != rectangle2.x) {
            this.topLeft.x += rectangle2.x - rectangle.x;
        }
        if (rectangle.y != rectangle2.y) {
            this.topLeft.y += rectangle2.y - rectangle.y;
        }
    }

    protected int parseField(String string, String string2, String string3) throws WindowGeometryException {
        String string4 = "";
        try {
            Pattern pattern = Pattern.compile(string3 + "=(-?\\d+)", 2);
            Matcher matcher = pattern.matcher(string2);
            if (!matcher.find()) {
                throw new WindowGeometryException(I18n.tr("Preference with key ''{0}'' does not include ''{1}''. Cannot restore window geometry from preferences.", string, string3));
            }
            string4 = matcher.group(1);
            return Integer.parseInt(string4);
        }
        catch (WindowGeometryException windowGeometryException) {
            throw windowGeometryException;
        }
        catch (NumberFormatException numberFormatException) {
            throw new WindowGeometryException(I18n.tr("Preference with key ''{0}'' does not provide an int value for ''{1}''. Got {2}. Cannot restore window geometry from preferences.", string, string3, string4), numberFormatException);
        }
        catch (RuntimeException runtimeException) {
            throw new WindowGeometryException(I18n.tr("Failed to parse field ''{1}'' in preference with key ''{0}''. Exception was: {2}. Cannot restore window geometry from preferences.", string, string3, runtimeException.toString()), runtimeException);
        }
    }

    protected final void initFromPreferences(String string) throws WindowGeometryException {
        String string2 = Main.pref.get(string);
        if (string2 == null || string2.isEmpty()) {
            throw new WindowGeometryException(I18n.tr("Preference with key ''{0}'' does not exist. Cannot restore window geometry from preferences.", string));
        }
        this.topLeft = new Point();
        this.extent = new Dimension();
        this.topLeft.x = this.parseField(string, string2, "x");
        this.topLeft.y = this.parseField(string, string2, "y");
        this.extent.width = this.parseField(string, string2, "width");
        this.extent.height = this.parseField(string, string2, "height");
    }

    protected final void initFromWindowGeometry(WindowGeometry windowGeometry) {
        this.topLeft = windowGeometry.topLeft;
        this.extent = windowGeometry.extent;
    }

    public static WindowGeometry mainWindow(String string, String string2, boolean bl) {
        Object object;
        Rectangle rectangle = WindowGeometry.getScreenInfo("gui.geometry");
        if (string2 != null) {
            object = Pattern.compile("(\\d+)x(\\d+)(([+-])(\\d+)([+-])(\\d+))?").matcher(string2);
            if (((Matcher)object).matches()) {
                int n = Integer.parseInt(((Matcher)object).group(1));
                int n2 = Integer.parseInt(((Matcher)object).group(2));
                int n3 = rectangle.x;
                int n4 = rectangle.y;
                if (((Matcher)object).group(3) != null) {
                    n3 = Integer.parseInt(((Matcher)object).group(5));
                    n4 = Integer.parseInt(((Matcher)object).group(7));
                    if ("-".equals(((Matcher)object).group(4))) {
                        n3 = rectangle.x + rectangle.width - n3 - n;
                    }
                    if ("-".equals(((Matcher)object).group(6))) {
                        n4 = rectangle.y + rectangle.height - n4 - n2;
                    }
                }
                return new WindowGeometry(new Point(n3, n4), new Dimension(n, n2));
            }
            Main.warn(I18n.tr("Ignoring malformed geometry: {0}", string2));
        }
        if (bl) {
            object = new WindowGeometry(rectangle);
        } else {
            Point point = rectangle.getLocation();
            point.x += (rectangle.width - 1000) / 2;
            point.y += (rectangle.height - 740) / 2;
            object = new WindowGeometry(point, new Dimension(1000, 740));
        }
        return new WindowGeometry(string, (WindowGeometry)object);
    }

    public void remember(String string) {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append("x=").append(this.topLeft.x).append(",y=").append(this.topLeft.y).append(",width=").append(this.extent.width).append(",height=").append(this.extent.height);
        Main.pref.put(string, stringBuilder.toString());
    }

    public Point getTopLeft() {
        return this.topLeft;
    }

    public Dimension getSize() {
        return this.extent;
    }

    private Rectangle getRectangle() {
        return new Rectangle(this.topLeft, this.extent);
    }

    public void applySafe(Window window) {
        Rectangle rectangle;
        int n;
        Point point = new Point(this.topLeft);
        Dimension dimension = new Dimension(this.extent);
        Rectangle rectangle2 = WindowGeometry.getVirtualScreenBounds();
        if (point.x < rectangle2.x) {
            point.x = rectangle2.x;
        } else if (point.x > rectangle2.x + rectangle2.width - dimension.width) {
            point.x = rectangle2.x + rectangle2.width - dimension.width;
        }
        if (point.y < rectangle2.y) {
            point.y = rectangle2.y;
        } else if (point.y > rectangle2.y + rectangle2.height - dimension.height) {
            point.y = rectangle2.y + rectangle2.height - dimension.height;
        }
        int n2 = point.x + dimension.width - (rectangle2.x + rectangle2.width);
        if (n2 > 0) {
            dimension.width -= n2;
        }
        if ((n = point.y + dimension.height - (rectangle2.y + rectangle2.height)) > 0) {
            dimension.height -= n;
        }
        if (!WindowGeometry.isBugInMaximumWindowBounds(rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds())) {
            n2 = dimension.width - rectangle.width;
            if (n2 > 0) {
                dimension.width -= n2;
            }
            if ((n = dimension.height - rectangle.height) > 0) {
                dimension.height -= n;
            }
        }
        window.setLocation(point);
        window.setSize(dimension);
    }

    protected static boolean isBugInMaximumWindowBounds(Rectangle rectangle) {
        return rectangle.width <= 0 || rectangle.height <= 0;
    }

    public static Rectangle getVirtualScreenBounds() {
        Rectangle rectangle = new Rectangle();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (!GraphicsEnvironment.isHeadless()) {
            for (GraphicsDevice graphicsDevice : graphicsEnvironment.getScreenDevices()) {
                if (graphicsDevice.getType() != 0) continue;
                rectangle = rectangle.union(graphicsDevice.getDefaultConfiguration().getBounds());
            }
        }
        return rectangle;
    }

    public static Dimension getMaxDimensionOnScreen(JComponent jComponent) {
        CheckParameterUtil.ensureParameterNotNull(jComponent, "component");
        Dimension dimension = new Dimension();
        GraphicsConfiguration graphicsConfiguration = jComponent.getGraphicsConfiguration();
        if (graphicsConfiguration == null && Main.parent != null) {
            graphicsConfiguration = Main.parent.getGraphicsConfiguration();
        }
        if (graphicsConfiguration != null) {
            Rectangle rectangle = graphicsConfiguration.getBounds();
            Insets insets = jComponent.getToolkit().getScreenInsets(graphicsConfiguration);
            dimension.width = rectangle.width - insets.left - insets.right;
            dimension.height = rectangle.height - insets.top - insets.bottom;
        }
        return dimension;
    }

    public static Rectangle getScreenInfo(String string) {
        Rectangle rectangle = new WindowGeometry(string, new WindowGeometry(new Point(0, 0), new Dimension(10, 10))).getRectangle();
        return WindowGeometry.getScreenInfo(rectangle);
    }

    private static Rectangle getScreenInfo(Rectangle rectangle) {
        Rectangle rectangle2 = null;
        if (!GraphicsEnvironment.isHeadless()) {
            int n = 0;
            for (GraphicsDevice graphicsDevice : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
                int n2;
                Rectangle rectangle3;
                if (graphicsDevice.getType() != 0) continue;
                Rectangle rectangle4 = graphicsDevice.getDefaultConfiguration().getBounds();
                if (rectangle4.height > 0 && rectangle4.width / rectangle4.height >= 3) {
                    rectangle4.width /= 2;
                    rectangle3 = rectangle4.intersection(rectangle);
                    n2 = rectangle3.width * rectangle3.height;
                    if (rectangle2 == null || n < n2) {
                        n = n2;
                        rectangle2 = rectangle4;
                    }
                    rectangle4 = new Rectangle(rectangle4);
                    rectangle4.x += rectangle4.width;
                    rectangle3 = rectangle4.intersection(rectangle);
                    n2 = rectangle3.width * rectangle3.height;
                    if (n >= n2) continue;
                    n = n2;
                    rectangle2 = rectangle4;
                    continue;
                }
                rectangle3 = rectangle4.intersection(rectangle);
                n2 = rectangle3.width * rectangle3.height;
                if (rectangle2 != null && n >= n2) continue;
                n = n2;
                rectangle2 = rectangle4;
            }
        }
        return rectangle2 != null ? rectangle2 : rectangle;
    }

    public static Rectangle getFullScreenInfo() {
        return new Rectangle(new Point(0, 0), GuiHelper.getScreenSize());
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.extent == null ? 0 : this.extent.hashCode());
        n = 31 * n + (this.topLeft == null ? 0 : this.topLeft.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        WindowGeometry windowGeometry = (WindowGeometry)object;
        if (this.extent == null ? windowGeometry.extent != null : !this.extent.equals(windowGeometry.extent)) {
            return false;
        }
        return !(this.topLeft == null ? windowGeometry.topLeft != null : !this.topLeft.equals(windowGeometry.topLeft));
    }

    public String toString() {
        return "WindowGeometry{topLeft=" + this.topLeft + ",extent=" + this.extent + '}';
    }

    public static class WindowGeometryException
    extends Exception {
        WindowGeometryException(String string, Throwable throwable) {
            super(string, throwable);
        }

        WindowGeometryException(String string) {
            super(string);
        }
    }
}

