/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rope;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.LeafRope;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeBuffer;
import org.jruby.truffle.core.rope.RopeNodes;
import org.jruby.truffle.core.rope.RopeNodesFactory;
import org.jruby.truffle.core.rope.RopeOperations;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.platform.UnsafeGroup;
import org.jruby.truffle.util.StringUtils;

@CoreClass(value="Truffle::Ropes")
public abstract class TruffleRopesNodes {

    @CoreMethod(names={"create_simple_string"}, onSingleton=true)
    public static abstract class CreateSimpleStringNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject createSimpleString() {
            return this.createString(RopeOperations.create(new byte[]{116, 101, 115, 116}, (Encoding)UTF8Encoding.INSTANCE, CodeRange.CR_7BIT));
        }
    }

    @CoreMethod(names={"flatten_rope"}, onSingleton=true, required=1)
    public static abstract class FlattenRopeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isRubyString(string)"})
        public DynamicObject flattenRope(DynamicObject string, @Cached(value="create()") RopeNodes.FlattenNode flattenNode) {
            LeafRope flattened = flattenNode.executeFlatten(StringOperations.rope(string));
            return this.createString(flattened);
        }
    }

    @CoreMethod(names={"debug_print_rope"}, onSingleton=true, required=1, optional=1, unsafe={UnsafeGroup.IO})
    public static abstract class DebugPrintRopeNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.DebugPrintRopeNode debugPrintRopeNode = RopeNodesFactory.DebugPrintRopeNodeGen.create(null, null, null);

        public DebugPrintRopeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(string)"})
        public DynamicObject debugPrintDefault(DynamicObject string, NotProvided printString) {
            return this.debugPrint(string, true);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(string)"})
        public DynamicObject debugPrint(DynamicObject string, boolean printString) {
            System.err.println("Legend: ");
            System.err.println("BN = Bytes Null? (byte[] not yet populated)");
            System.err.println("BL = Byte Length");
            System.err.println("CL = Character Length");
            System.err.println("CR = Code Range");
            System.err.println("O = Offset (SubstringRope only)");
            System.err.println("T = Times (RepeatingRope only)");
            System.err.println("D = Depth");
            System.err.println("LD = Left Depth (ConcatRope only)");
            System.err.println("RD = Right Depth (ConcatRope only)");
            return this.debugPrintRopeNode.executeDebugPrint(StringOperations.rope(string), 0, printString);
        }
    }

    @CoreMethod(names={"convert_to_mutable_rope"}, onSingleton=true, required=1)
    public static abstract class ConvertToMutableRope
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isRubyString(string)"})
        public DynamicObject convertToMutableRope(DynamicObject string) {
            RopeBuffer ropeBuffer = new RopeBuffer(StringOperations.rope(string));
            StringOperations.setRope(string, ropeBuffer);
            return string;
        }
    }

    @CoreMethod(names={"dump_string"}, onSingleton=true, required=1)
    public static abstract class DumpStringNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(string)"})
        public DynamicObject dumpString(DynamicObject string) {
            StringBuilder builder = new StringBuilder();
            Rope rope = StringOperations.rope(string);
            for (int i = 0; i < rope.byteLength(); ++i) {
                builder.append(StringUtils.format("\\x%02x", rope.get(i)));
            }
            return this.createString(StringOperations.encodeRope(builder.toString(), (Encoding)UTF8Encoding.INSTANCE));
        }
    }

    @CoreMethod(names={"debug_print"}, onSingleton=true, required=1, unsafe={UnsafeGroup.IO})
    public static abstract class DebugPrintNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(string)"})
        public DynamicObject debugPrint(DynamicObject string) {
            System.err.println(string.toString());
            return this.nil();
        }
    }
}

