/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.ast;

import java.util.List;
import org.jruby.truffle.parser.ast.NodeType;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.visitor.NodeVisitor;
import org.jruby.truffle.parser.lexer.ISourcePosition;

public class OpAsgnParseNode
extends ParseNode {
    private final ParseNode receiverNode;
    private final ParseNode valueNode;
    private final String variableName;
    private final String operatorName;
    private final String variableNameAsgn;
    private final boolean isLazy;

    public OpAsgnParseNode(ISourcePosition position, ParseNode receiverNode, ParseNode valueNode, String variableName, String operatorName, boolean isLazy) {
        super(position, receiverNode.containsVariableAssignment());
        assert (receiverNode != null) : "receiverNode is not null";
        assert (valueNode != null) : "valueNode is not null";
        this.receiverNode = receiverNode;
        this.valueNode = valueNode;
        this.variableName = variableName;
        this.operatorName = operatorName;
        this.variableNameAsgn = (variableName + "=").intern();
        this.isLazy = isLazy;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.OPASGNNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitOpAsgnNode(this);
    }

    public String getOperatorName() {
        return this.operatorName;
    }

    public ParseNode getReceiverNode() {
        return this.receiverNode;
    }

    public ParseNode getValueNode() {
        return this.valueNode;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String getVariableNameAsgn() {
        return this.variableNameAsgn;
    }

    @Override
    public List<ParseNode> childNodes() {
        return ParseNode.createList(this.receiverNode, this.valueNode);
    }

    public boolean isLazy() {
        return this.isLazy;
    }

    @Override
    public boolean needsDefinitionCheck() {
        return false;
    }
}

