/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.ast.executable;

import java.math.BigInteger;
import java.util.Arrays;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyModule;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.common.IRubyWarnings;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.UndefinedMethod;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.ivars.VariableAccessor;
import org.jruby.runtime.opto.ConstantCache;
import org.jruby.runtime.opto.Invalidator;
import org.jruby.truffle.parser.Helpers;
import org.jruby.truffle.parser.scope.StaticScope;
import org.jruby.truffle.parser.scope.StaticScopeFactory;
import org.jruby.util.ByteList;
import org.jruby.util.DefinedMessage;
import org.jruby.util.RegexpOptions;

public class RuntimeCache {
    private static final int SCOPE = 0;
    private static final int SYMBOL = 1;
    private static final int FIXNUM = 2;
    private static final int FLOAT = 3;
    private static final int CONSTANT = 4;
    private static final int REGEXP = 5;
    private static final int BIGINTEGER = 6;
    private static final int VARIABLEREADER = 7;
    private static final int VARIABLEWRITER = 8;
    private static final int METHOD = 9;
    private static final int STRING = 10;
    private static final int ENCODING = 11;
    private static final int FROZEN_STRING = 12;
    private static final StaticScope[] EMPTY_SCOPES = new StaticScope[0];
    public StaticScope[] scopes = EMPTY_SCOPES;
    private static final CallSite[] EMPTY_CALLSITES = new CallSite[0];
    public CallSite[] callSites = EMPTY_CALLSITES;
    private static final CacheEntry[] EMPTY_CACHEENTRIES = new CacheEntry[0];
    public CacheEntry[] methodCache = EMPTY_CACHEENTRIES;
    private static final RubySymbol[] EMPTY_RUBYSYMBOLS = new RubySymbol[0];
    public RubySymbol[] symbols = EMPTY_RUBYSYMBOLS;
    private static final ByteList[] EMPTY_BYTELISTS = new ByteList[0];
    public ByteList[] byteLists = EMPTY_BYTELISTS;
    private static final RubyString[] EMPTY_STRINGS = new RubyString[0];
    public RubyString[] frozenStrings = EMPTY_STRINGS;
    private static final Encoding[] EMPTY_ENCODINGS = new Encoding[0];
    public Encoding[] encodings = EMPTY_ENCODINGS;
    private static final RubyFixnum[] EMPTY_FIXNUMS = new RubyFixnum[0];
    public RubyFixnum[] fixnums = EMPTY_FIXNUMS;
    private static final RubyFloat[] EMPTY_FLOATS = new RubyFloat[0];
    public RubyFloat[] floats = EMPTY_FLOATS;
    private static final RubyRegexp[] EMPTY_RUBYREGEXPS = new RubyRegexp[0];
    public RubyRegexp[] regexps = EMPTY_RUBYREGEXPS;
    private static final BigInteger[] EMPTY_BIGINTEGERS = new BigInteger[0];
    public BigInteger[] bigIntegers = EMPTY_BIGINTEGERS;
    private static final VariableAccessor[] EMPTY_VARIABLE_ACCESSORS = new VariableAccessor[0];
    public VariableAccessor[] variableReaders = EMPTY_VARIABLE_ACCESSORS;
    public VariableAccessor[] variableWriters = EMPTY_VARIABLE_ACCESSORS;
    public ConstantCache[] constants = new ConstantCache[0];

    public final StaticScope getScope(StaticScopeFactory staticScopeFactory, ThreadContext context, StaticScope parent, String varNamesDescriptor, int index) {
        StaticScope scope = this.scopes[index];
        if (scope == null) {
            this.scopes[index] = scope = Helpers.decodeScopeAndDetermineModule(staticScopeFactory, context, parent, varNamesDescriptor);
        }
        return scope;
    }

    public final StaticScope getScope(int index) {
        return this.scopes[index];
    }

    public final CallSite getCallSite(int index) {
        return this.callSites[index];
    }

    public final RubySymbol getSymbol(ThreadContext context, int index, String name, String encodingName) {
        RubySymbol symbol = this.symbols[index];
        if (symbol == null) {
            symbol = context.runtime.newSymbol(name);
            if (encodingName != null) {
                symbol.associateEncoding(((EncodingDB.Entry)EncodingDB.getEncodings().get(encodingName.getBytes())).getEncoding());
            }
            this.symbols[index] = symbol;
        }
        return symbol;
    }

    public final RubyString getString(ThreadContext context, int index, int codeRange) {
        return RubyString.newStringShared((Ruby)context.runtime, (ByteList)this.getByteList(index), (int)codeRange);
    }

    public final RubyString getFrozenString(ThreadContext context, int bytelistIndex, int stringIndex, int codeRange) {
        RubyString str = this.frozenStrings[stringIndex];
        if (str == null) {
            str = this.frozenStrings[stringIndex] = context.runtime.freezeAndDedupString((RubyString)RubyString.newStringShared((Ruby)context.runtime, (ByteList)this.getByteList(bytelistIndex), (int)codeRange).freeze(context));
        }
        return str;
    }

    public final ByteList getByteList(int index) {
        return this.byteLists[index];
    }

    public final Encoding getEncoding(int index) {
        return this.encodings[index];
    }

    public final RubyFixnum getFixnum(ThreadContext context, int index, int value) {
        RubyFixnum fixnum = this.fixnums[index];
        if (fixnum == null) {
            this.fixnums[index] = RubyFixnum.newFixnum((Ruby)context.runtime, (long)value);
            return this.fixnums[index];
        }
        return fixnum;
    }

    public final RubyFixnum getFixnum(ThreadContext context, int index, long value) {
        RubyFixnum fixnum = this.fixnums[index];
        if (fixnum == null) {
            this.fixnums[index] = RubyFixnum.newFixnum((Ruby)context.runtime, (long)value);
            return this.fixnums[index];
        }
        return fixnum;
    }

    public final RubyFloat getFloat(ThreadContext context, int index, double value) {
        RubyFloat flote = this.floats[index];
        if (flote == null) {
            this.floats[index] = RubyFloat.newFloat((Ruby)context.runtime, (double)value);
            return this.floats[index];
        }
        return flote;
    }

    public final RubyRegexp getRegexp(ThreadContext context, int index, ByteList pattern, int options) {
        RubyRegexp regexp = this.regexps[index];
        if (regexp == null || context.runtime.getKCode() != regexp.getKCode()) {
            regexp = RubyRegexp.newRegexp((Ruby)context.runtime, (ByteList)pattern, (RegexpOptions)RegexpOptions.fromEmbeddedOptions((int)options));
            regexp.setLiteral();
            this.regexps[index] = regexp;
        }
        return regexp;
    }

    public final RubyRegexp getRegexp(int index) {
        return this.regexps[index];
    }

    public final RubyRegexp cacheRegexp(int index, RubyString pattern, int options) {
        RubyRegexp regexp = this.regexps[index];
        Ruby runtime = pattern.getRuntime();
        if (regexp == null || runtime.getKCode() != regexp.getKCode()) {
            this.regexps[index] = regexp = RubyRegexp.newRegexp((Ruby)runtime, (ByteList)pattern.getByteList(), (RegexpOptions)RegexpOptions.fromEmbeddedOptions((int)options));
        }
        return regexp;
    }

    public final RubyRegexp cacheRegexp(int index, RubyRegexp regexp) {
        this.regexps[index] = regexp;
        return regexp;
    }

    public final BigInteger getBigInteger(int index, String pattern) {
        BigInteger bigint = this.bigIntegers[index];
        if (bigint == null) {
            this.bigIntegers[index] = new BigInteger(pattern, 16);
            return this.bigIntegers[index];
        }
        return bigint;
    }

    public final IRubyObject getVariable(ThreadContext context, int index, String name, IRubyObject object) {
        IRubyObject value = this.getValue(context, index, name, object);
        if (value != null) {
            return value;
        }
        Ruby runtime = context.runtime;
        if (runtime.isVerbose()) {
            this.warnAboutUninitializedIvar(runtime, name);
        }
        return runtime.getNil();
    }

    public final IRubyObject getVariableDefined(ThreadContext context, int index, String name, IRubyObject object) {
        return this.getValue(context, index, name, object) == null ? null : context.runtime.getDefinedMessage(DefinedMessage.INSTANCE_VARIABLE);
    }

    private final IRubyObject getValue(ThreadContext context, int index, String name, IRubyObject object) {
        VariableAccessor variableAccessor = this.variableReaders[index];
        RubyClass cls = object.getMetaClass().getRealClass();
        if (variableAccessor.getClassId() != cls.hashCode()) {
            this.variableReaders[index] = variableAccessor = cls.getVariableAccessorForRead(name);
        }
        return (IRubyObject)variableAccessor.get((Object)object);
    }

    private void warnAboutUninitializedIvar(Ruby runtime, String name) {
        runtime.getWarnings().warning(IRubyWarnings.ID.IVAR_NOT_INITIALIZED, "instance variable " + name + " not initialized");
    }

    public final IRubyObject setVariable(int index, String name, IRubyObject object, IRubyObject value) {
        VariableAccessor variableAccessor = this.variableWriters[index];
        RubyClass cls = object.getMetaClass().getRealClass();
        if (variableAccessor.getClassId() != cls.hashCode()) {
            this.variableWriters[index] = variableAccessor = cls.getVariableAccessorForWrite(name);
        }
        variableAccessor.set((Object)object, (Object)value);
        return value;
    }

    public final void initScopes(int size) {
        this.scopes = new StaticScope[size];
    }

    public final void initCallSites(int size) {
        this.callSites = new CallSite[size];
    }

    public final void initFromDescriptor(String descriptor) {
        String[] pieces = descriptor.split("\uffff");
        CallSite[] sites = new CallSite[pieces.length - 0];
        if (pieces[0].length() != 0) {
            block6: for (int i = 0; i < pieces.length - 1; i += 2) {
                switch (pieces[i + 1].charAt(0)) {
                    case 'N': {
                        sites[i / 2] = MethodIndex.getCallSite((String)pieces[i]);
                        continue block6;
                    }
                    case 'F': {
                        sites[i / 2] = MethodIndex.getFunctionalCallSite((String)pieces[i]);
                        continue block6;
                    }
                    case 'V': {
                        sites[i / 2] = MethodIndex.getVariableCallSite((String)pieces[i]);
                        continue block6;
                    }
                    case 'S': {
                        sites[i / 2] = MethodIndex.getSuperCallSite();
                        continue block6;
                    }
                    default: {
                        throw new RuntimeException("Unknown call type: " + pieces[i + 1] + " for method " + pieces[i]);
                    }
                }
            }
            this.callSites = sites;
        }
        this.initOthers(pieces[pieces.length - 1]);
    }

    public final void initOthers(String descriptor) {
        int frozenStringCount;
        int encodingCount;
        int stringCount;
        int methodCount;
        int variableWriterCount;
        int variableReaderCount;
        int bigIntegerCount;
        int regexpCount;
        int constantCount;
        int floatCount;
        int fixnumCount;
        int symbolCount;
        int scopeCount = RuntimeCache.getDescriptorValue(descriptor, 0);
        if (scopeCount > 0) {
            this.initScopes(scopeCount);
        }
        if ((symbolCount = RuntimeCache.getDescriptorValue(descriptor, 1)) > 0) {
            this.initSymbols(symbolCount);
        }
        if ((fixnumCount = RuntimeCache.getDescriptorValue(descriptor, 2)) > 0) {
            this.initFixnums(fixnumCount);
        }
        if ((floatCount = RuntimeCache.getDescriptorValue(descriptor, 3)) > 0) {
            this.initFloats(floatCount);
        }
        if ((constantCount = RuntimeCache.getDescriptorValue(descriptor, 4)) > 0) {
            this.initConstants(constantCount);
        }
        if ((regexpCount = RuntimeCache.getDescriptorValue(descriptor, 5)) > 0) {
            this.initRegexps(regexpCount);
        }
        if ((bigIntegerCount = RuntimeCache.getDescriptorValue(descriptor, 6)) > 0) {
            this.initBigIntegers(bigIntegerCount);
        }
        if ((variableReaderCount = RuntimeCache.getDescriptorValue(descriptor, 7)) > 0) {
            this.initVariableReaders(variableReaderCount);
        }
        if ((variableWriterCount = RuntimeCache.getDescriptorValue(descriptor, 8)) > 0) {
            this.initVariableWriters(variableWriterCount);
        }
        if ((methodCount = RuntimeCache.getDescriptorValue(descriptor, 9)) > 0) {
            this.initMethodCache(methodCount);
        }
        if ((stringCount = RuntimeCache.getDescriptorValue(descriptor, 10)) > 0) {
            this.initStrings(stringCount);
        }
        if ((encodingCount = RuntimeCache.getDescriptorValue(descriptor, 11)) > 0) {
            this.initEncodings(encodingCount);
        }
        if ((frozenStringCount = RuntimeCache.getDescriptorValue(descriptor, 12)) > 0) {
            this.initFrozenStrings(frozenStringCount);
        }
    }

    private static int getDescriptorValue(String descriptor, int type) {
        return descriptor.charAt(type);
    }

    public final void initSymbols(int size) {
        this.symbols = new RubySymbol[size];
    }

    public final ByteList[] initStrings(int size) {
        this.byteLists = new ByteList[size];
        return this.byteLists;
    }

    public final RubyString[] initFrozenStrings(int size) {
        this.frozenStrings = new RubyString[size];
        return this.frozenStrings;
    }

    public final Encoding[] initEncodings(int size) {
        this.encodings = new Encoding[size];
        return this.encodings;
    }

    public final void initFixnums(int size) {
        this.fixnums = new RubyFixnum[size];
    }

    public final void initFloats(int size) {
        this.floats = new RubyFloat[size];
    }

    public final void initRegexps(int size) {
        this.regexps = new RubyRegexp[size];
    }

    public final void initBigIntegers(int size) {
        this.bigIntegers = new BigInteger[size];
    }

    public final void initConstants(int size) {
        this.constants = new ConstantCache[size];
    }

    public final void initVariableReaders(int size) {
        this.variableReaders = new VariableAccessor[size];
        Arrays.fill(this.variableReaders, VariableAccessor.DUMMY_ACCESSOR);
    }

    public final void initVariableWriters(int size) {
        this.variableWriters = new VariableAccessor[size];
        Arrays.fill(this.variableWriters, VariableAccessor.DUMMY_ACCESSOR);
    }

    public final void initMethodCache(int size) {
        this.methodCache = new CacheEntry[size];
        Arrays.fill(this.methodCache, CacheEntry.NULL_CACHE);
    }

    public final IRubyObject getConstant(ThreadContext context, StaticScope scope, String name, int index) {
        IRubyObject value = this.getValue(context, scope, name, index);
        return value != null ? value : scope.getModule().callMethod(context, "const_missing", (IRubyObject)context.runtime.fastNewSymbol(name));
    }

    public final IRubyObject getConstantDefined(ThreadContext context, StaticScope scope, String name, int index) {
        IRubyObject value = this.getValue(context, scope, name, index);
        return value == null ? null : context.runtime.getDefinedMessage(DefinedMessage.CONSTANT);
    }

    public IRubyObject getValue(ThreadContext context, StaticScope scope, String name, int index) {
        ConstantCache cache = this.constants[index];
        return ConstantCache.isCached((ConstantCache)cache) ? cache.value : this.reCache(context, scope, name, index);
    }

    public IRubyObject reCache(ThreadContext context, StaticScope scope, String name, int index) {
        Invalidator invalidator = context.runtime.getConstantInvalidator(name);
        Object newGeneration = invalidator.getData();
        IRubyObject value = scope.getConstant(name);
        this.constants[index] = value != null ? new ConstantCache(value, newGeneration, invalidator) : null;
        return value;
    }

    public final IRubyObject getConstantFrom(RubyModule target, ThreadContext context, String name, int index) {
        IRubyObject value = this.getValueFrom(target, context, name, index);
        return value != null ? value : target.getConstantFromConstMissing(name);
    }

    public IRubyObject getValueFrom(RubyModule target, ThreadContext context, String name, int index) {
        ConstantCache cache = this.constants[index];
        return ConstantCache.isCachedFrom((RubyModule)target, (ConstantCache)cache) ? cache.value : this.reCacheFrom(target, context, name, index);
    }

    public IRubyObject reCacheFrom(RubyModule target, ThreadContext context, String name, int index) {
        Invalidator invalidator = context.runtime.getConstantInvalidator(name);
        Object newGeneration = invalidator.getData();
        IRubyObject value = target.getConstantFromNoConstMissing(name, false);
        this.constants[index] = value != null ? new ConstantCache(value, newGeneration, invalidator, target.hashCode()) : null;
        return value;
    }

    public DynamicMethod getMethod(ThreadContext context, RubyClass selfType, int index, String methodName) {
        CacheEntry myCache = this.getCacheEntry(index);
        if (CacheEntry.typeOk((CacheEntry)myCache, (RubyClass)selfType)) {
            return myCache.method;
        }
        return this.cacheAndGet(context, selfType, index, methodName);
    }

    public DynamicMethod getMethod(ThreadContext context, IRubyObject self, int index, String methodName) {
        return this.getMethod(context, RuntimeCache.pollAndGetClass(context, self), index, methodName);
    }

    private DynamicMethod cacheAndGet(ThreadContext context, RubyClass selfType, int index, String methodName) {
        CacheEntry entry = selfType.searchWithCache(methodName);
        DynamicMethod method = entry.method;
        if (method.isUndefined()) {
            return Helpers.selectMethodMissing(context, selfType, method.getVisibility(), methodName, CallType.FUNCTIONAL);
        }
        this.methodCache[index] = entry;
        return method;
    }

    private DynamicMethod searchWithCacheNoMethodMissing(RubyClass clazz, int index, String name1) {
        CacheEntry entry = clazz.searchWithCache(name1);
        DynamicMethod method = entry.method;
        if (entry.method == UndefinedMethod.INSTANCE) {
            return null;
        }
        this.methodCache[index] = entry;
        return method;
    }

    private DynamicMethod searchWithCacheNoMethodMissing(RubyClass clazz, int index, String name1, String name2) {
        CacheEntry entry = clazz.searchWithCache(name1);
        DynamicMethod method = entry.method;
        if (entry.method == UndefinedMethod.INSTANCE) {
            return this.searchWithCacheNoMethodMissing(clazz, index, name2);
        }
        this.methodCache[index] = entry;
        return method;
    }

    public final DynamicMethod searchWithCacheNoMethodMissing(IRubyObject obj, int index, String name1) {
        CacheEntry myCache = this.getCacheEntry(index);
        if (CacheEntry.typeOk((CacheEntry)myCache, (RubyClass)obj.getMetaClass())) {
            return myCache.method;
        }
        return this.searchWithCacheNoMethodMissing(obj.getMetaClass(), index, name1);
    }

    public final DynamicMethod searchWithCacheNoMethodMissing(IRubyObject obj, int index, String name1, String name2) {
        CacheEntry myCache = this.getCacheEntry(index);
        if (CacheEntry.typeOk((CacheEntry)myCache, (RubyClass)obj.getMetaClass())) {
            return myCache.method;
        }
        return this.searchWithCacheNoMethodMissing(obj.getMetaClass(), index, name1, name2);
    }

    public DynamicMethod searchWithCache(RubyClass clazz, int index, String name1) {
        CacheEntry entry = clazz.searchWithCache(name1);
        DynamicMethod method = entry.method;
        if (entry.method == UndefinedMethod.INSTANCE) {
            return Helpers.selectMethodMissing(clazz, method.getVisibility(), name1, CallType.FUNCTIONAL);
        }
        this.methodCache[index] = entry;
        return method;
    }

    public DynamicMethod searchWithCache(RubyClass clazz, int index, String name1, String name2) {
        CacheEntry entry = clazz.searchWithCache(name1);
        DynamicMethod method = entry.method;
        if (entry.method == UndefinedMethod.INSTANCE) {
            return this.searchWithCache(clazz, index, name2);
        }
        this.methodCache[index] = entry;
        return method;
    }

    public DynamicMethod searchWithCache(RubyClass clazz, int index, String name1, String name2, String name3) {
        CacheEntry entry = clazz.searchWithCache(name1);
        DynamicMethod method = entry.method;
        if (entry.method == UndefinedMethod.INSTANCE) {
            return this.searchWithCache(clazz, index, name2, name3);
        }
        this.methodCache[index] = entry;
        return method;
    }

    public DynamicMethod searchWithCache(RubyClass clazz, int index, String name1, String name2, String name3, String name4) {
        CacheEntry entry = clazz.searchWithCache(name1);
        DynamicMethod method = entry.method;
        if (entry.method == UndefinedMethod.INSTANCE) {
            return this.searchWithCache(clazz, index, name2, name3, name4);
        }
        this.methodCache[index] = entry;
        return method;
    }

    public DynamicMethod searchWithCache(RubyClass clazz, int index, String name1, String name2, String name3, String name4, String name5) {
        CacheEntry entry = clazz.searchWithCache(name1);
        DynamicMethod method = entry.method;
        if (entry.method == UndefinedMethod.INSTANCE) {
            return this.searchWithCache(clazz, index, name2, name3, name4, name5);
        }
        this.methodCache[index] = entry;
        return method;
    }

    public DynamicMethod searchWithCache(RubyClass clazz, int index, String name1, String name2, String name3, String name4, String name5, String name6) {
        CacheEntry entry = clazz.searchWithCache(name1);
        DynamicMethod method = entry.method;
        if (entry.method == UndefinedMethod.INSTANCE) {
            return this.searchWithCache(clazz, index, name2, name3, name4, name5, name6);
        }
        this.methodCache[index] = entry;
        return method;
    }

    public DynamicMethod searchWithCache(RubyClass clazz, int index, String name1, String name2, String name3, String name4, String name5, String name6, String name7) {
        CacheEntry entry = clazz.searchWithCache(name1);
        DynamicMethod method = entry.method;
        if (entry.method == UndefinedMethod.INSTANCE) {
            return this.searchWithCache(clazz, index, name2, name3, name4, name5, name6, name7);
        }
        this.methodCache[index] = entry;
        return method;
    }

    public DynamicMethod searchWithCache(RubyClass clazz, int index, String name1, String name2, String name3, String name4, String name5, String name6, String name7, String name8) {
        CacheEntry entry = clazz.searchWithCache(name1);
        DynamicMethod method = entry.method;
        if (entry.method == UndefinedMethod.INSTANCE) {
            return this.searchWithCache(clazz, index, name2, name3, name4, name5, name6, name7, name8);
        }
        this.methodCache[index] = entry;
        return method;
    }

    public DynamicMethod searchWithCache(IRubyObject obj, int index, String name1) {
        CacheEntry myCache = this.getCacheEntry(index);
        if (CacheEntry.typeOk((CacheEntry)myCache, (RubyClass)obj.getMetaClass())) {
            return myCache.method;
        }
        return this.searchWithCache(obj.getMetaClass(), index, name1);
    }

    public DynamicMethod searchWithCache(IRubyObject obj, int index, String name1, String name2) {
        CacheEntry myCache = this.getCacheEntry(index);
        if (CacheEntry.typeOk((CacheEntry)myCache, (RubyClass)obj.getMetaClass())) {
            return myCache.method;
        }
        return this.searchWithCache(obj.getMetaClass(), index, name1, name2);
    }

    public DynamicMethod searchWithCache(IRubyObject obj, int index, String name1, String name2, String name3) {
        CacheEntry myCache = this.getCacheEntry(index);
        if (CacheEntry.typeOk((CacheEntry)myCache, (RubyClass)obj.getMetaClass())) {
            return myCache.method;
        }
        return this.searchWithCache(obj.getMetaClass(), index, name1, name2, name3);
    }

    public DynamicMethod searchWithCache(IRubyObject obj, int index, String name1, String name2, String name3, String name4) {
        CacheEntry myCache = this.getCacheEntry(index);
        if (CacheEntry.typeOk((CacheEntry)myCache, (RubyClass)obj.getMetaClass())) {
            return myCache.method;
        }
        return this.searchWithCache(obj.getMetaClass(), index, name1, name2, name3, name4);
    }

    public DynamicMethod searchWithCache(IRubyObject obj, int index, String name1, String name2, String name3, String name4, String name5) {
        CacheEntry myCache = this.getCacheEntry(index);
        if (CacheEntry.typeOk((CacheEntry)myCache, (RubyClass)obj.getMetaClass())) {
            return myCache.method;
        }
        return this.searchWithCache(obj.getMetaClass(), index, name1, name2, name3, name4, name5);
    }

    public DynamicMethod searchWithCache(IRubyObject obj, int index, String name1, String name2, String name3, String name4, String name5, String name6) {
        CacheEntry myCache = this.getCacheEntry(index);
        if (CacheEntry.typeOk((CacheEntry)myCache, (RubyClass)obj.getMetaClass())) {
            return myCache.method;
        }
        return this.searchWithCache(obj.getMetaClass(), index, name1, name2, name3, name4, name5, name6);
    }

    public DynamicMethod searchWithCache(IRubyObject obj, int index, String name1, String name2, String name3, String name4, String name5, String name6, String name7) {
        CacheEntry myCache = this.getCacheEntry(index);
        if (CacheEntry.typeOk((CacheEntry)myCache, (RubyClass)obj.getMetaClass())) {
            return myCache.method;
        }
        return this.searchWithCache(obj.getMetaClass(), index, name1, name2, name3, name4, name5, name6, name7);
    }

    public DynamicMethod searchWithCache(IRubyObject obj, int index, String name1, String name2, String name3, String name4, String name5, String name6, String name7, String name8) {
        CacheEntry myCache = this.getCacheEntry(index);
        if (CacheEntry.typeOk((CacheEntry)myCache, (RubyClass)obj.getMetaClass())) {
            return myCache.method;
        }
        return this.searchWithCache(obj.getMetaClass(), index, name1, name2, name3, name4, name5, name6, name7, name8);
    }

    private static RubyClass pollAndGetClass(ThreadContext context, IRubyObject self) {
        context.callThreadPoll();
        RubyClass selfType = self.getMetaClass();
        return selfType;
    }

    private CacheEntry getCacheEntry(int index) {
        return this.methodCache[index];
    }
}

