/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.lexer;

import java.io.InputStream;
import java.nio.channels.Channel;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyEncoding;
import org.jruby.RubyIO;
import org.jruby.RubyString;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.truffle.parser.lexer.LexerSource;
import org.jruby.util.ByteList;
import org.jruby.util.IOInputStream;
import org.jruby.util.io.ChannelHelper;

public class GetsLexerSource
extends LexerSource {
    private IRubyObject io;
    private Encoding encoding;
    private int offset;

    public GetsLexerSource(String sourceName, int line, IRubyObject io, RubyArray scriptLines, Encoding encoding) {
        super(sourceName, line, scriptLines);
        this.io = io;
        this.encoding = encoding;
    }

    public GetsLexerSource(String sourceName, int line, IRubyObject io, RubyArray scriptLines) {
        this(sourceName, line, io, scriptLines, GetsLexerSource.frobnicateEncoding(io));
    }

    public static final Encoding frobnicateEncoding(IRubyObject io) {
        if (!io.respondsTo("encoding")) {
            return io.getRuntime().getDefaultExternalEncoding();
        }
        IRubyObject encodingObject = io.callMethod(io.getRuntime().getCurrentContext(), "encoding");
        return encodingObject instanceof RubyEncoding ? ((RubyEncoding)encodingObject).getEncoding() : io.getRuntime().getDefaultExternalEncoding();
    }

    @Override
    public Encoding getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(Encoding encoding) {
        this.encoding = encoding;
        this.encodeExistingScriptLines(encoding);
    }

    @Override
    public ByteList gets() {
        IRubyObject result = this.io.callMethod(this.io.getRuntime().getCurrentContext(), "gets");
        if (result.isNil()) {
            return null;
        }
        ByteList bytelist = result.convertToString().getByteList();
        this.offset += bytelist.getRealSize();
        bytelist.setEncoding(this.encoding);
        if (this.scriptLines != null) {
            this.scriptLines.append((IRubyObject)RubyString.newString((Ruby)this.scriptLines.getRuntime(), (ByteList)bytelist));
        }
        return bytelist;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public Channel getRemainingAsChannel() {
        if (this.io instanceof RubyIO) {
            return ((RubyIO)this.io).getChannel();
        }
        return ChannelHelper.readableChannel((InputStream)new IOInputStream(this.io));
    }

    @Override
    public IRubyObject getRemainingAsIO() {
        return this.io;
    }
}

