ms08_067_netapi is one of the most popular remote exploits against Microsoft Windows. It is
considered a reliable exploit, and allows you to gain access as SYSTEM - the highest Windows
privilege. In modern day penetration test, this exploit would most likely be used in an internal
environment, and not so much from external due to the likelihood of a firewall.

The check command of ms08_067_netapi is also highly accurate, because it is actually testing the
vulnerable code path, not just passively.


## Vulnerable Application

This exploit works against a vulnerable SMB service from one of these Windows systems:

* Windows 2000
* Windows XP
* Windows 2003

To reliability determine whether the machine is vulnerable, you will have to either examine
the system's patch level, or use a vulnerability check.

## Verification Steps

Please see Basic Usage under Overview.

## Options

Please see Required Options under Overview.

## Scenarios

**Failure to detect the language pack**

On some Windows systems, ms08_067_netapi (as well as other SMB modules) might show you this
message:


> Windows 2003 R2 Service Pack 2 - lang:Unknown


This is because the targeted system does not allow itself to be enumerated without authentication.
In this case, either you can set the username and password to be able to use automatic detection,
like this:

```
set SMBUSER [username]
set SMBPASS [password]
```

Or you must manually set the target with the correct language, for example:

```
set target [target ID]
```

**Unsafe configuration of LHOST**

Although ms08_067_netapi is reliable enough for a memory corruption exploit, it has its own
denial-of-service moments. One scenario is when the LHOST option is incorrectly configured,
which could result the SMB to crash.
