/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.facet;

import com.baselet.control.basics.XValues;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.enums.AlignVertical;
import com.baselet.control.enums.ElementStyle;
import com.baselet.element.facet.Facet;
import com.baselet.element.facet.common.BackgroundColorFacet;
import com.baselet.element.facet.common.CommentFacet;
import com.baselet.element.facet.common.ElementStyleFacet;
import com.baselet.element.facet.common.FontSizeFacet;
import com.baselet.element.facet.common.ForegroundColorFacet;
import com.baselet.element.facet.common.GroupFacet;
import com.baselet.element.facet.common.HorizontalAlignFacet;
import com.baselet.element.facet.common.LayerFacet;
import com.baselet.element.facet.common.LineTypeFacet;
import com.baselet.element.facet.common.LineWidthFacet;
import com.baselet.element.facet.common.SeparatorLineFacet;
import com.baselet.element.facet.common.TextPrintFacet;
import com.baselet.element.facet.common.TransparencyFacet;
import com.baselet.element.facet.common.VerticalAlignFacet;
import com.baselet.element.facet.customdrawings.CustomDrawingFacet;
import com.baselet.element.facet.specific.HierarchyFacet;
import com.baselet.element.relation.facet.LineDescriptionFacet;
import com.baselet.element.relation.facet.LineDescriptionPositionFacet;
import com.baselet.element.relation.facet.RelationLineTypeFacet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class Settings {
    protected static final List<Facet> BASE = Settings.listOf(BackgroundColorFacet.INSTANCE, TransparencyFacet.INSTANCE, ForegroundColorFacet.INSTANCE, LayerFacet.INSTANCE, LineWidthFacet.INSTANCE, GroupFacet.INSTANCE, CommentFacet.INSTANCE);
    protected static final List<Facet> BASE_WITH_LINETYPE = Settings.listOf(BASE, LineTypeFacet.INSTANCE, CustomDrawingFacet.INSTANCE);
    protected static final List<Facet> BASE_EXTENDED = Settings.listOf(BASE_WITH_LINETYPE, TextPrintFacet.INSTANCE, FontSizeFacet.INSTANCE);
    protected static final List<Facet> RELATION = Settings.listOf(BASE, FontSizeFacet.INSTANCE, RelationLineTypeFacet.INSTANCE, LineDescriptionFacet.INSTANCE, LineDescriptionPositionFacet.INSTANCE_MESSAGE_START, LineDescriptionPositionFacet.INSTANCE_MESSAGE_END, LineDescriptionPositionFacet.INSTANCE_ROLE_START, LineDescriptionPositionFacet.INSTANCE_ROLE_END);
    protected static final List<Facet> MANUALRESIZE = Settings.listOf(BASE_EXTENDED, VerticalAlignFacet.INSTANCE, HorizontalAlignFacet.INSTANCE, ElementStyleFacet.INSTANCE);
    protected static final List<Facet> NOTEXT = BASE_WITH_LINETYPE;
    protected static final List<Facet> AUTORESIZE = Settings.listOf(BASE_EXTENDED, SeparatorLineFacet.INSTANCE);
    protected static final List<Facet> HIERARCHY = Settings.listOf(BASE_WITH_LINETYPE, FontSizeFacet.INSTANCE, ElementStyleFacet.INSTANCE_AUTORESIZEONLY, HierarchyFacet.INSTANCE);
    private List<Facet> firstRunFacets;
    private List<Facet> secondRunFacets;

    protected static List<Facet> listOf(Facet ... f) {
        ArrayList<Facet> facetList = new ArrayList<Facet>();
        facetList.addAll(Arrays.asList(f));
        return facetList;
    }

    protected static List<Facet> listOf(List<Facet> list, Facet ... f) {
        ArrayList<Facet> facetList = new ArrayList<Facet>(list);
        facetList.addAll(Arrays.asList(f));
        return facetList;
    }

    public XValues getXValues(double y, int height, int width) {
        return new XValues(0.0, width);
    }

    public AlignVertical getVAlign() {
        return AlignVertical.TOP;
    }

    public AlignHorizontal getHAlign() {
        return AlignHorizontal.CENTER;
    }

    public abstract ElementStyle getElementStyle();

    protected abstract List<Facet> createFacets();

    private void initFacets() {
        if (this.firstRunFacets == null) {
            this.firstRunFacets = new ArrayList<Facet>();
            this.secondRunFacets = new ArrayList<Facet>();
            this.addAll(this.createFacets());
            this.sortListByPriority(this.firstRunFacets);
            this.sortListByPriority(this.secondRunFacets);
        }
    }

    private void addAll(List<Facet> facets) {
        for (Facet f : facets) {
            if (f.handleOnFirstRun()) {
                this.secondRunFacets.add(f);
                continue;
            }
            this.firstRunFacets.add(f);
        }
    }

    private void sortListByPriority(List<? extends Facet> facets) {
        Collections.sort(facets, new Comparator<Facet>(){

            @Override
            public int compare(Facet o1, Facet o2) {
                return o1.getPriority().compareTo(o2.getPriority());
            }
        });
    }

    public final List<Facet> getFacetsForSecondRun() {
        this.initFacets();
        return this.firstRunFacets;
    }

    public final List<Facet> getFacetsForFirstRun() {
        this.initFacets();
        return this.secondRunFacets;
    }
}

