/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.util.ArrayList;
import java.util.List;
import javax.swing.UIManager;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class StableCompoundEdit
implements UndoableEdit {
    private static final int HAS_BEEN_DONE = 1;
    private static final int ALIVE = 2;
    private static final int IN_PROGRESS = 4;
    private int statusBits = 7;
    private ArrayList<UndoableEdit> edits = new ArrayList(4);

    public final List<UndoableEdit> getEdits() {
        return this.edits;
    }

    @Override
    public void die() {
        this.clearStatusBits(2);
        int n = this.edits.size();
        for (int i = n - 1; i >= 0; --i) {
            this.edits.get(i).die();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undo() throws CannotUndoException {
        int n;
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        try {
            for (n = this.edits.size() - 1; n >= 0; --n) {
                this.edits.get(n).undo();
            }
            this.clearStatusBits(1);
        }
        finally {
            if (n != -1) {
                int n2 = this.edits.size();
                while (++n < n2) {
                    this.edits.get(n).redo();
                }
            }
        }
    }

    @Override
    public boolean canUndo() {
        return this.isAnyStatusBit(2) && this.isAnyStatusBit(1) && !this.isInProgress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void redo() throws CannotRedoException {
        int n;
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        int n2 = this.edits.size();
        try {
            for (n = 0; n < n2; ++n) {
                this.edits.get(n).redo();
            }
            this.setStatusBits(1);
        }
        finally {
            if (n != n2) {
                while (--n >= 0) {
                    this.edits.get(n).undo();
                }
            }
        }
    }

    @Override
    public boolean canRedo() {
        return this.isAnyStatusBit(2) && !this.isAnyStatusBit(1) && !this.isInProgress();
    }

    @Override
    public boolean addEdit(UndoableEdit undoableEdit) {
        if (!this.isInProgress()) {
            return false;
        }
        UndoableEdit undoableEdit2 = this.lastEdit();
        if (undoableEdit2 == null) {
            this.edits.add(undoableEdit);
        } else if (!undoableEdit2.addEdit(undoableEdit)) {
            if (undoableEdit.replaceEdit(undoableEdit2)) {
                this.edits.remove(this.edits.size() - 1);
            }
            this.edits.add(undoableEdit);
        }
        return true;
    }

    @Override
    public boolean replaceEdit(UndoableEdit undoableEdit) {
        return false;
    }

    @Override
    public boolean isSignificant() {
        int n = this.edits.size();
        for (int i = 0; i < n; ++i) {
            if (!this.edits.get(i).isSignificant()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getPresentationName() {
        UndoableEdit undoableEdit = this.lastEdit();
        if (undoableEdit != null) {
            return undoableEdit.getPresentationName();
        }
        return "";
    }

    @Override
    public String getUndoPresentationName() {
        UndoableEdit undoableEdit = this.lastEdit();
        if (undoableEdit != null) {
            return undoableEdit.getUndoPresentationName();
        }
        String string = this.getPresentationName();
        string = !"".equals(string) ? UIManager.getString("AbstractUndoableEdit.undoText") + " " + string : UIManager.getString("AbstractUndoableEdit.undoText");
        return string;
    }

    @Override
    public String getRedoPresentationName() {
        UndoableEdit undoableEdit = this.lastEdit();
        if (undoableEdit != null) {
            return undoableEdit.getRedoPresentationName();
        }
        String string = this.getPresentationName();
        string = !"".equals(string) ? UIManager.getString("AbstractUndoableEdit.redoText") + " " + string : UIManager.getString("AbstractUndoableEdit.redoText");
        return string;
    }

    public void end() {
        this.clearStatusBits(4);
        this.edits.trimToSize();
    }

    public boolean isInProgress() {
        return this.isAnyStatusBit(4);
    }

    protected UndoableEdit lastEdit() {
        int n = this.edits.size();
        if (n > 0) {
            return this.edits.get(n - 1);
        }
        return null;
    }

    private boolean isAnyStatusBit(int n) {
        return (this.statusBits & n) != 0;
    }

    private void setStatusBits(int n) {
        this.statusBits |= n;
    }

    private void clearStatusBits(int n) {
        this.statusBits &= ~n;
    }

    public String toString() {
        return super.toString() + " hasBeenDone: " + this.isAnyStatusBit(1) + " alive: " + this.isAnyStatusBit(2) + " inProgress: " + this.isInProgress() + " edits: " + this.edits;
    }
}

