/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.plaf.aqua;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.border.Border;

public class FakeDropShadowBorder
implements Border {
    private static final int TOP = 8;
    private static final int BOTTOM = 8;
    private static final int LEFT = 8;
    private static final int RIGHT = 8;
    private final Insets insets;
    private static final String upLeft = "border_top_left.png";
    private static final String downRight = "border_bottom_right.png";
    private static final String downLeft = "border_bottom_left.png";
    private static final String upRight = "border_top_right.png";
    private static final String bottom = "border_bottom.png";
    private static final String leftEdge = "border_left.png";
    private static final String rightEdge = "border_right.png";
    private static final String top = "border_top.png";
    private static Map<String, BufferedImage> imgs = new HashMap<String, BufferedImage>();

    private FakeDropShadowBorder(Insets insets) {
        this.insets = insets;
    }

    public static Border createDefault() {
        return new FakeDropShadowBorder(new Insets(8, 8, 8, 8));
    }

    public static Border createLeftBorder() {
        return new FakeDropShadowBorder(new Insets(0, 0, 8, 8));
    }

    public static Border createRightBorder() {
        return new FakeDropShadowBorder(new Insets(0, 8, 8, 0));
    }

    public static Border createBottomBorder() {
        return new FakeDropShadowBorder(new Insets(8, 8, 0, 8));
    }

    public static Border createTopBorder() {
        return new FakeDropShadowBorder(new Insets(0, 8, 8, 8));
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return new Insets(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right);
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        BufferedImage bufferedImage = null;
        if (this.insets.top > 0 && this.insets.left > 0) {
            bufferedImage = FakeDropShadowBorder.getImage(upLeft);
            graphics2D.drawImage((Image)bufferedImage, n, n2, null);
        }
        if (this.insets.right > 0 && this.insets.bottom > 0) {
            bufferedImage = FakeDropShadowBorder.getImage(downRight);
            int n5 = n + n3 - bufferedImage.getWidth();
            if (this.insets.right == 0) {
                n5 += 8;
            }
            graphics2D.drawImage((Image)bufferedImage, n5, n2 + n4 - bufferedImage.getHeight(), null);
        }
        if (this.insets.top > 0 && this.insets.right > 0) {
            bufferedImage = FakeDropShadowBorder.getImage(upRight);
            graphics2D.drawImage((Image)bufferedImage, n + n3 - bufferedImage.getWidth(), n2, null);
        }
        if (this.insets.left > 0 && this.insets.bottom > 0) {
            bufferedImage = FakeDropShadowBorder.getImage(downLeft);
            if (this.insets.left == 0) {
                n -= 8;
            }
            graphics2D.drawImage((Image)bufferedImage, n, n2 + n4 - bufferedImage.getHeight(), null);
        }
        if (this.insets.left > 0) {
            bufferedImage = FakeDropShadowBorder.getImage(leftEdge);
            graphics2D.drawImage(bufferedImage, n, n2 + this.insets.top, bufferedImage.getWidth(), n4 - this.insets.top - this.insets.bottom, null);
        }
        if (this.insets.right > 0) {
            bufferedImage = FakeDropShadowBorder.getImage(rightEdge);
            graphics2D.drawImage(bufferedImage, n + n3 - bufferedImage.getWidth(), n2 + this.insets.top, bufferedImage.getWidth(), n4 - this.insets.top - this.insets.bottom, null);
        }
        if (this.insets.bottom > 0) {
            bufferedImage = FakeDropShadowBorder.getImage(bottom);
            graphics2D.drawImage(bufferedImage, n + this.insets.left, n2 + n4 - bufferedImage.getHeight(), n + n3 - this.insets.left - this.insets.right, bufferedImage.getHeight(), null);
        }
        if (this.insets.top > 0) {
            bufferedImage = FakeDropShadowBorder.getImage(top);
            graphics2D.drawImage(bufferedImage, n + this.insets.left, n2, n + n3 - this.insets.left - this.insets.right, bufferedImage.getHeight(), null);
        }
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    private static BufferedImage getImage(String string) {
        BufferedImage bufferedImage = imgs.get(string);
        if (bufferedImage == null) {
            Exception exception = null;
            try {
                bufferedImage = ImageIO.read(FakeDropShadowBorder.class.getResourceAsStream(string));
            }
            catch (Exception exception2) {
                bufferedImage = new BufferedImage(1, 1, 2);
                exception = exception2;
            }
            imgs.put(string, bufferedImage);
            if (exception != null) {
                throw new IllegalStateException(exception);
            }
        }
        return bufferedImage;
    }
}

