/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcherSupplier;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.xcontent.AbstractObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentLocation;
import org.elasticsearch.common.xcontent.XContentParser;

public final class ConstructingObjectParser<Value, Context extends ParseFieldMatcherSupplier>
extends AbstractObjectParser<Value, Context> {
    private static final BiConsumer<Object, Object> REQUIRED_CONSTRUCTOR_ARG_MARKER = (a, b) -> {
        throw new UnsupportedOperationException("I am just a marker I should never be called.");
    };
    private static final BiConsumer<Object, Object> OPTIONAL_CONSTRUCTOR_ARG_MARKER = (a, b) -> {
        throw new UnsupportedOperationException("I am just a marker I should never be called.");
    };
    private final List<ConstructorArgInfo> constructorArgInfos = new ArrayList<ConstructorArgInfo>();
    private final ObjectParser<Target, Context> objectParser;
    private final Function<Object[], Value> builder;
    private int numberOfFields = 0;

    public ConstructingObjectParser(String name, Function<Object[], Value> builder) {
        this.objectParser = new ObjectParser(name);
        this.builder = builder;
    }

    @Override
    public Value apply(XContentParser parser, Context context) {
        try {
            return (Value)this.objectParser.parse(parser, new Target(parser), context).finish();
        }
        catch (IOException e) {
            throw new ParsingException(parser.getTokenLocation(), "[" + this.objectParser.getName() + "] failed to parse object", e, new Object[0]);
        }
    }

    public static <Value, FieldT> BiConsumer<Value, FieldT> constructorArg() {
        return REQUIRED_CONSTRUCTOR_ARG_MARKER;
    }

    public static <Value, FieldT> BiConsumer<Value, FieldT> optionalConstructorArg() {
        return OPTIONAL_CONSTRUCTOR_ARG_MARKER;
    }

    @Override
    public <T> void declareField(BiConsumer<Value, T> consumer, AbstractObjectParser.ContextParser<Context, T> parser, ParseField parseField, ObjectParser.ValueType type) {
        if (consumer == REQUIRED_CONSTRUCTOR_ARG_MARKER || consumer == OPTIONAL_CONSTRUCTOR_ARG_MARKER) {
            int position = this.constructorArgInfos.size();
            boolean required = consumer == REQUIRED_CONSTRUCTOR_ARG_MARKER;
            this.constructorArgInfos.add(new ConstructorArgInfo(parseField, required));
            this.objectParser.declareField((Value target, T v) -> ((Target)target).constructorArg(position, parseField, v), parser, parseField, type);
        } else {
            ++this.numberOfFields;
            this.objectParser.declareField(this.queueingConsumer(consumer, parseField), parser, parseField, type);
        }
    }

    private <T> BiConsumer<Target, T> queueingConsumer(BiConsumer<Value, T> consumer, ParseField parseField) {
        return (target, v) -> {
            if (((Target)target).targetObject != null) {
                consumer.accept(((Target)target).targetObject, v);
                return;
            }
            XContentLocation location = ((Target)target).parser.getTokenLocation();
            ((Target)target).queue(targetObject -> {
                try {
                    consumer.accept(targetObject, v);
                }
                catch (Exception e) {
                    throw new ParsingException(location, "[" + this.objectParser.getName() + "] failed to parse field [" + parseField.getPreferredName() + "]", e, new Object[0]);
                }
            });
        };
    }

    private static class ConstructorArgInfo {
        final ParseField field;
        final boolean required;

        public ConstructorArgInfo(ParseField field, boolean required) {
            this.field = field;
            this.required = required;
        }
    }

    private class Target {
        private final Object[] constructorArgs;
        private final XContentParser parser;
        private int constructorArgsCollected;
        private Consumer<Value>[] queuedFields;
        private int queuedFieldsCount;
        private Value targetObject;

        public Target(XContentParser parser) {
            this.constructorArgs = new Object[ConstructingObjectParser.this.constructorArgInfos.size()];
            this.constructorArgsCollected = 0;
            this.queuedFieldsCount = 0;
            this.parser = parser;
        }

        private void constructorArg(int position, ParseField parseField, Object value) {
            if (this.constructorArgs[position] != null) {
                throw new IllegalArgumentException("Can't repeat param [" + parseField + "]");
            }
            this.constructorArgs[position] = value;
            ++this.constructorArgsCollected;
            if (this.constructorArgsCollected == ConstructingObjectParser.this.constructorArgInfos.size()) {
                this.buildTarget();
            }
        }

        private void queue(Consumer<Value> queueMe) {
            assert (this.targetObject == null) : "Don't queue after the targetObject has been built! Just apply the consumer directly.";
            if (this.queuedFields == null) {
                Consumer[] queuedFields = new Consumer[ConstructingObjectParser.this.numberOfFields];
                this.queuedFields = queuedFields;
            }
            this.queuedFields[this.queuedFieldsCount] = queueMe;
            ++this.queuedFieldsCount;
        }

        private Value finish() {
            if (this.targetObject != null) {
                return this.targetObject;
            }
            StringBuilder message = null;
            for (int i = 0; i < this.constructorArgs.length; ++i) {
                if (this.constructorArgs[i] != null) continue;
                ConstructorArgInfo arg = (ConstructorArgInfo)ConstructingObjectParser.this.constructorArgInfos.get(i);
                if (!arg.required) continue;
                if (message == null) {
                    message = new StringBuilder("Required [").append(arg.field);
                    continue;
                }
                message.append(", ").append(arg.field);
            }
            if (message != null) {
                throw new IllegalArgumentException(message.append(']').toString());
            }
            assert (!ConstructingObjectParser.this.constructorArgInfos.isEmpty()) : "[" + ConstructingObjectParser.access$300(ConstructingObjectParser.this).getName() + "] must configure at least on constructor argument. If it doesn't have any it should use ObjectParser instead of ConstructingObjectParser. This is a bug in the parser declaration.";
            this.buildTarget();
            return this.targetObject;
        }

        private void buildTarget() {
            try {
                this.targetObject = ConstructingObjectParser.this.builder.apply(this.constructorArgs);
                while (this.queuedFieldsCount > 0) {
                    --this.queuedFieldsCount;
                    this.queuedFields[this.queuedFieldsCount].accept(this.targetObject);
                }
            }
            catch (ParsingException e) {
                throw new ParsingException(e.getLineNumber(), e.getColumnNumber(), "failed to build [" + ConstructingObjectParser.this.objectParser.getName() + "] after last required field arrived", e);
            }
            catch (Exception e) {
                throw new ParsingException(null, "Failed to build [" + ConstructingObjectParser.this.objectParser.getName() + "] after last required field arrived", e, new Object[0]);
            }
        }
    }
}

