/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.channels.ClosedByInterruptException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.apache.lucene.index.SnapshotDeletionPolicy;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.UsageTrackingQueryCachingPolicy;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.ThreadInterruptedException;
import org.apache.lucene.util.Version;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeRequest;
import org.elasticsearch.action.admin.indices.upgrade.post.UpgradeRequest;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.Callback;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.AsyncIOProcessor;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.cache.IndexCache;
import org.elasticsearch.index.cache.bitset.ShardBitsetFilterCache;
import org.elasticsearch.index.cache.request.ShardRequestCache;
import org.elasticsearch.index.codec.CodecService;
import org.elasticsearch.index.engine.CommitStats;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineClosedException;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.EngineFactory;
import org.elasticsearch.index.engine.InternalEngineFactory;
import org.elasticsearch.index.engine.RefreshFailedEngineException;
import org.elasticsearch.index.engine.Segment;
import org.elasticsearch.index.engine.SegmentsStats;
import org.elasticsearch.index.fielddata.FieldDataStats;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.fielddata.ShardFieldData;
import org.elasticsearch.index.flush.FlushStats;
import org.elasticsearch.index.get.GetStats;
import org.elasticsearch.index.get.ShardGetService;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.DocumentMapperForType;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.recovery.RecoveryStats;
import org.elasticsearch.index.refresh.RefreshStats;
import org.elasticsearch.index.search.stats.SearchStats;
import org.elasticsearch.index.search.stats.ShardSearchStats;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.DocsStats;
import org.elasticsearch.index.shard.ElasticsearchQueryCachingPolicy;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexSearcherWrapper;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.IndexShardNotRecoveringException;
import org.elasticsearch.index.shard.IndexShardNotStartedException;
import org.elasticsearch.index.shard.IndexShardOperationsLock;
import org.elasticsearch.index.shard.IndexShardRecoveringException;
import org.elasticsearch.index.shard.IndexShardRelocatedException;
import org.elasticsearch.index.shard.IndexShardStartedException;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.IndexingOperationListener;
import org.elasticsearch.index.shard.IndexingStats;
import org.elasticsearch.index.shard.InternalIndexingStats;
import org.elasticsearch.index.shard.LocalShardSnapshot;
import org.elasticsearch.index.shard.RefreshListeners;
import org.elasticsearch.index.shard.SearchOperationListener;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.index.shard.ShardStateMetaData;
import org.elasticsearch.index.shard.StoreRecovery;
import org.elasticsearch.index.shard.TranslogRecoveryPerformer;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetaData;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogConfig;
import org.elasticsearch.index.translog.TranslogStats;
import org.elasticsearch.index.warmer.ShardIndexWarmerService;
import org.elasticsearch.index.warmer.WarmerStats;
import org.elasticsearch.indices.IndexingMemoryController;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.indices.recovery.PeerRecoveryTargetService;
import org.elasticsearch.indices.recovery.RecoveryFailedException;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.search.suggest.completion.CompletionFieldStats;
import org.elasticsearch.search.suggest.completion.CompletionStats;
import org.elasticsearch.search.suggest.completion2x.Completion090PostingsFormat;
import org.elasticsearch.threadpool.ThreadPool;

public class IndexShard
extends AbstractIndexShardComponent
implements IndicesClusterStateService.Shard {
    private final ThreadPool threadPool;
    private final MapperService mapperService;
    private final IndexCache indexCache;
    private final Store store;
    private final InternalIndexingStats internalIndexingStats;
    private final ShardSearchStats searchStats = new ShardSearchStats();
    private final ShardGetService getService;
    private final ShardIndexWarmerService shardWarmerService;
    private final ShardRequestCache requestCacheStats;
    private final ShardFieldData shardFieldData;
    private final IndexFieldDataService indexFieldDataService;
    private final ShardBitsetFilterCache shardBitsetFilterCache;
    private final Object mutex = new Object();
    private final String checkIndexOnStartup;
    private final CodecService codecService;
    private final Engine.Warmer warmer;
    private final SnapshotDeletionPolicy deletionPolicy;
    private final SimilarityService similarityService;
    private final TranslogConfig translogConfig;
    private final IndexEventListener indexEventListener;
    private final QueryCachingPolicy cachingPolicy;
    private final AtomicLong writingBytes = new AtomicLong();
    private final SearchOperationListener searchOperationListener;
    protected volatile ShardRouting shardRouting;
    protected volatile IndexShardState state;
    protected volatile long primaryTerm;
    protected final AtomicReference<Engine> currentEngineReference = new AtomicReference();
    protected final EngineFactory engineFactory;
    private final IndexingOperationListener indexingOperationListeners;
    @Nullable
    private RecoveryState recoveryState;
    private final RecoveryStats recoveryStats = new RecoveryStats();
    private final MeanMetric refreshMetric = new MeanMetric();
    private final MeanMetric flushMetric = new MeanMetric();
    private final ShardEventListener shardEventListener = new ShardEventListener();
    private final ShardPath path;
    private final IndexShardOperationsLock indexShardOperationsLock;
    private static final EnumSet<IndexShardState> readAllowedStates = EnumSet.of(IndexShardState.STARTED, IndexShardState.RELOCATED, IndexShardState.POST_RECOVERY);
    public static final EnumSet<IndexShardState> writeAllowedStatesForPrimary = EnumSet.of(IndexShardState.RECOVERING, IndexShardState.POST_RECOVERY, IndexShardState.STARTED);
    private static final EnumSet<IndexShardState> writeAllowedStatesForReplica = EnumSet.of(IndexShardState.RECOVERING, IndexShardState.POST_RECOVERY, IndexShardState.STARTED, IndexShardState.RELOCATED);
    private final IndexSearcherWrapper searcherWrapper;
    private final AtomicBoolean active = new AtomicBoolean();
    @Nullable
    private final RefreshListeners refreshListeners;
    private final AsyncIOProcessor<Translog.Location> translogSyncProcessor = new AsyncIOProcessor<Translog.Location>(this.logger, 1024){

        @Override
        protected void write(List<Tuple<Translog.Location, Consumer<Exception>>> candidates) throws IOException {
            try {
                Engine engine = IndexShard.this.getEngine();
                engine.getTranslog().ensureSynced(candidates.stream().map(Tuple::v1));
            }
            catch (EngineClosedException engine) {
            }
            catch (IOException ex) {
                IndexShard.this.logger.debug("failed to sync translog", (Throwable)ex);
                throw ex;
            }
        }
    };
    private final AtomicBoolean asyncFlushRunning = new AtomicBoolean();

    public IndexShard(ShardRouting shardRouting, IndexSettings indexSettings, ShardPath path, Store store, IndexCache indexCache, MapperService mapperService, SimilarityService similarityService, IndexFieldDataService indexFieldDataService, @Nullable EngineFactory engineFactory, IndexEventListener indexEventListener, IndexSearcherWrapper indexSearcherWrapper, ThreadPool threadPool, BigArrays bigArrays, Engine.Warmer warmer, List<SearchOperationListener> searchOperationListener, List<IndexingOperationListener> listeners) throws IOException {
        super(shardRouting.shardId(), indexSettings);
        assert (shardRouting.initializing());
        this.shardRouting = shardRouting;
        Settings settings = indexSettings.getSettings();
        this.codecService = new CodecService(mapperService, this.logger);
        this.warmer = warmer;
        this.deletionPolicy = new SnapshotDeletionPolicy((IndexDeletionPolicy)new KeepOnlyLastCommitDeletionPolicy());
        this.similarityService = similarityService;
        Objects.requireNonNull(store, "Store must be provided to the index shard");
        this.engineFactory = engineFactory == null ? new InternalEngineFactory() : engineFactory;
        this.store = store;
        this.indexEventListener = indexEventListener;
        this.threadPool = threadPool;
        this.mapperService = mapperService;
        this.indexCache = indexCache;
        this.internalIndexingStats = new InternalIndexingStats();
        ArrayList<IndexingOperationListener> listenersList = new ArrayList<IndexingOperationListener>(listeners);
        listenersList.add(this.internalIndexingStats);
        this.indexingOperationListeners = new IndexingOperationListener.CompositeListener(listenersList, this.logger);
        ArrayList<SearchOperationListener> searchListenersList = new ArrayList<SearchOperationListener>(searchOperationListener);
        searchListenersList.add(this.searchStats);
        this.searchOperationListener = new SearchOperationListener.CompositeListener(searchListenersList, this.logger);
        this.getService = new ShardGetService(indexSettings, this, mapperService);
        this.shardWarmerService = new ShardIndexWarmerService(this.shardId, indexSettings);
        this.requestCacheStats = new ShardRequestCache();
        this.shardFieldData = new ShardFieldData();
        this.indexFieldDataService = indexFieldDataService;
        this.shardBitsetFilterCache = new ShardBitsetFilterCache(this.shardId, indexSettings);
        this.state = IndexShardState.CREATED;
        this.path = path;
        this.logger.debug("state: [CREATED]");
        this.checkIndexOnStartup = indexSettings.getValue(IndexSettings.INDEX_CHECK_ON_STARTUP);
        this.translogConfig = new TranslogConfig(this.shardId, this.shardPath().resolveTranslog(), indexSettings, bigArrays);
        if (IndexModule.INDEX_QUERY_CACHE_EVERYTHING_SETTING.get(settings).booleanValue()) {
            this.cachingPolicy = QueryCachingPolicy.ALWAYS_CACHE;
        } else {
            Object cachingPolicy = new UsageTrackingQueryCachingPolicy();
            if (!IndexModule.INDEX_QUERY_CACHE_TERM_QUERIES_SETTING.get(settings).booleanValue()) {
                cachingPolicy = new ElasticsearchQueryCachingPolicy((QueryCachingPolicy)cachingPolicy);
            }
            this.cachingPolicy = cachingPolicy;
        }
        this.indexShardOperationsLock = new IndexShardOperationsLock(this.shardId, this.logger, threadPool);
        this.searcherWrapper = indexSearcherWrapper;
        this.primaryTerm = indexSettings.getIndexMetaData().primaryTerm(this.shardId.id());
        this.refreshListeners = this.buildRefreshListeners();
        this.persistMetadata(shardRouting, null);
    }

    public Store store() {
        return this.store;
    }

    public boolean canIndex() {
        return true;
    }

    public ShardGetService getService() {
        return this.getService;
    }

    public ShardBitsetFilterCache shardBitsetFilterCache() {
        return this.shardBitsetFilterCache;
    }

    public IndexFieldDataService indexFieldDataService() {
        return this.indexFieldDataService;
    }

    public MapperService mapperService() {
        return this.mapperService;
    }

    public SearchOperationListener getSearchOperationListener() {
        return this.searchOperationListener;
    }

    public ShardIndexWarmerService warmerService() {
        return this.shardWarmerService;
    }

    public ShardRequestCache requestCache() {
        return this.requestCacheStats;
    }

    public ShardFieldData fieldData() {
        return this.shardFieldData;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePrimaryTerm(long newTerm) {
        Object object = this.mutex;
        synchronized (object) {
            if (newTerm != this.primaryTerm) {
                assert (!this.shardRouting.primary() || !this.shardRouting.initializing()) : "a started primary shard should never update it's term. shard: " + this.shardRouting + " current term [" + this.primaryTerm + "] new term [" + newTerm + "]";
                assert (newTerm > this.primaryTerm) : "primary terms can only go up. current [" + this.primaryTerm + "], new [" + newTerm + "]";
                this.primaryTerm = newTerm;
            }
        }
    }

    @Override
    public ShardRouting routingEntry() {
        return this.shardRouting;
    }

    public QueryCachingPolicy getQueryCachingPolicy() {
        return this.cachingPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRoutingEntry(ShardRouting newRouting) throws IOException {
        ShardRouting currentRouting;
        Object object = this.mutex;
        synchronized (object) {
            currentRouting = this.shardRouting;
            if (!newRouting.shardId().equals(this.shardId())) {
                throw new IllegalArgumentException("Trying to set a routing entry with shardId " + newRouting.shardId() + " on a shard with shardId " + this.shardId() + "");
            }
            if (!(currentRouting == null || newRouting.isSameAllocation(currentRouting))) {
                throw new IllegalArgumentException("Trying to set a routing entry with a different allocation. Current " + currentRouting + ", new " + newRouting);
            }
            if (currentRouting != null && currentRouting.primary() && !newRouting.primary()) {
                throw new IllegalArgumentException("illegal state: trying to move shard from primary mode to replica mode. Current " + currentRouting + ", new " + newRouting);
            }
            if (this.state == IndexShardState.POST_RECOVERY && newRouting.active()) {
                assert (!currentRouting.active()) : "we are in POST_RECOVERY, but our shard routing is active " + currentRouting;
                try {
                    this.getEngine().refresh("cluster_state_started");
                }
                catch (Exception e) {
                    this.logger.debug("failed to refresh due to move to cluster wide started", (Throwable)e);
                }
                this.changeState(IndexShardState.STARTED, "global state is [" + (Object)((Object)newRouting.state()) + "]");
            } else if (!(this.state != IndexShardState.RELOCATED || newRouting.relocating() && newRouting.equalsIgnoringMetaData(currentRouting))) {
                throw new IndexShardRelocatedException(this.shardId(), "Shard is marked as relocated, cannot safely move to state " + (Object)((Object)newRouting.state()));
            }
            this.shardRouting = newRouting;
            this.persistMetadata(newRouting, currentRouting);
        }
        if (currentRouting != null && !currentRouting.active() && newRouting.active()) {
            this.indexEventListener.afterIndexShardStarted(this);
        }
        if (!newRouting.equals(currentRouting)) {
            this.indexEventListener.shardRoutingChanged(this, currentRouting, newRouting);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexShardState markAsRecovering(String reason, RecoveryState recoveryState) throws IndexShardStartedException, IndexShardRelocatedException, IndexShardRecoveringException, IndexShardClosedException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.state == IndexShardState.CLOSED) {
                throw new IndexShardClosedException(this.shardId);
            }
            if (this.state == IndexShardState.STARTED) {
                throw new IndexShardStartedException(this.shardId);
            }
            if (this.state == IndexShardState.RELOCATED) {
                throw new IndexShardRelocatedException(this.shardId);
            }
            if (this.state == IndexShardState.RECOVERING) {
                throw new IndexShardRecoveringException(this.shardId);
            }
            if (this.state == IndexShardState.POST_RECOVERY) {
                throw new IndexShardRecoveringException(this.shardId);
            }
            this.recoveryState = recoveryState;
            return this.changeState(IndexShardState.RECOVERING, reason);
        }
    }

    public void relocated(String reason) throws IllegalIndexShardStateException, InterruptedException {
        assert (this.shardRouting.primary()) : "only primaries can be marked as relocated: " + this.shardRouting;
        try {
            this.indexShardOperationsLock.blockOperations(30L, TimeUnit.MINUTES, () -> {
                assert (this.indexShardOperationsLock.getActiveOperationsCount() == 0) : "in-flight operations in progress while moving shard state to relocated";
                Object object = this.mutex;
                synchronized (object) {
                    if (this.state != IndexShardState.STARTED) {
                        throw new IndexShardNotStartedException(this.shardId, this.state);
                    }
                    if (!this.shardRouting.relocating()) {
                        throw new IllegalIndexShardStateException(this.shardId, IndexShardState.STARTED, ": shard is no longer relocating " + this.shardRouting, new Object[0]);
                    }
                    this.changeState(IndexShardState.RELOCATED, reason);
                }
            });
        }
        catch (TimeoutException e) {
            this.logger.warn("timed out waiting for relocation hand-off to complete");
            this.failShard("timed out waiting for relocation hand-off to complete", null);
            throw new IndexShardClosedException(this.shardId(), "timed out waiting for relocation hand-off to complete");
        }
    }

    @Override
    public IndexShardState state() {
        return this.state;
    }

    private IndexShardState changeState(IndexShardState newState, String reason) {
        this.logger.debug("state: [{}]->[{}], reason [{}]", (Object)this.state, (Object)newState, (Object)reason);
        IndexShardState previousState = this.state;
        this.state = newState;
        this.indexEventListener.indexShardStateChanged(this, previousState, newState, reason);
        return previousState;
    }

    public Engine.Index prepareIndexOnPrimary(SourceToParse source, long version, VersionType versionType, long autoGeneratedIdTimestamp, boolean isRetry) {
        try {
            this.verifyPrimary();
            return IndexShard.prepareIndex(this.docMapper(source.type()), source, version, versionType, Engine.Operation.Origin.PRIMARY, autoGeneratedIdTimestamp, isRetry);
        }
        catch (Exception e) {
            this.verifyNotClosed(e);
            throw e;
        }
    }

    public Engine.Index prepareIndexOnReplica(SourceToParse source, long version, VersionType versionType, long autoGeneratedIdTimestamp, boolean isRetry) {
        try {
            this.verifyReplicationTarget();
            return IndexShard.prepareIndex(this.docMapper(source.type()), source, version, versionType, Engine.Operation.Origin.REPLICA, autoGeneratedIdTimestamp, isRetry);
        }
        catch (Exception e) {
            this.verifyNotClosed(e);
            throw e;
        }
    }

    static Engine.Index prepareIndex(DocumentMapperForType docMapper, SourceToParse source, long version, VersionType versionType, Engine.Operation.Origin origin, long autoGeneratedIdTimestamp, boolean isRetry) {
        long startTime = System.nanoTime();
        ParsedDocument doc = docMapper.getDocumentMapper().parse(source);
        if (docMapper.getMapping() != null) {
            doc.addDynamicMappingsUpdate(docMapper.getMapping());
        }
        MappedFieldType uidFieldType = docMapper.getDocumentMapper().uidMapper().fieldType();
        Query uidQuery = uidFieldType.termQuery(doc.uid(), null);
        Term uid = MappedFieldType.extractTerm(uidQuery);
        return new Engine.Index(uid, doc, version, versionType, origin, startTime, autoGeneratedIdTimestamp, isRetry);
    }

    public void index(Engine.Index index) {
        this.ensureWriteAllowed(index);
        Engine engine = this.getEngine();
        this.index(engine, index);
    }

    private void index(Engine engine, Engine.Index index) {
        this.active.set(true);
        index = this.indexingOperationListeners.preIndex(index);
        try {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("index [{}][{}]{}", (Object)index.type(), (Object)index.id(), index.docs());
            }
            engine.index(index);
            index.endTime(System.nanoTime());
        }
        catch (Exception e) {
            this.indexingOperationListeners.postIndex(index, e);
            throw e;
        }
        this.indexingOperationListeners.postIndex(index, index.isCreated());
    }

    public Engine.Delete prepareDeleteOnPrimary(String type, String id, long version, VersionType versionType) {
        this.verifyPrimary();
        DocumentMapper documentMapper = this.docMapper(type).getDocumentMapper();
        MappedFieldType uidFieldType = documentMapper.uidMapper().fieldType();
        Query uidQuery = uidFieldType.termQuery(Uid.createUid(type, id), null);
        Term uid = MappedFieldType.extractTerm(uidQuery);
        return IndexShard.prepareDelete(type, id, uid, version, versionType, Engine.Operation.Origin.PRIMARY);
    }

    public Engine.Delete prepareDeleteOnReplica(String type, String id, long version, VersionType versionType) {
        DocumentMapper documentMapper = this.docMapper(type).getDocumentMapper();
        MappedFieldType uidFieldType = documentMapper.uidMapper().fieldType();
        Query uidQuery = uidFieldType.termQuery(Uid.createUid(type, id), null);
        Term uid = MappedFieldType.extractTerm(uidQuery);
        return IndexShard.prepareDelete(type, id, uid, version, versionType, Engine.Operation.Origin.REPLICA);
    }

    static Engine.Delete prepareDelete(String type, String id, Term uid, long version, VersionType versionType, Engine.Operation.Origin origin) {
        long startTime = System.nanoTime();
        return new Engine.Delete(type, id, uid, version, versionType, origin, startTime, false);
    }

    public void delete(Engine.Delete delete) {
        this.ensureWriteAllowed(delete);
        Engine engine = this.getEngine();
        this.delete(engine, delete);
    }

    private void delete(Engine engine, Engine.Delete delete) {
        this.active.set(true);
        delete = this.indexingOperationListeners.preDelete(delete);
        try {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("delete [{}]", (Object)delete.uid().text());
            }
            engine.delete(delete);
            delete.endTime(System.nanoTime());
        }
        catch (Exception e) {
            this.indexingOperationListeners.postDelete(delete, e);
            throw e;
        }
        this.indexingOperationListeners.postDelete(delete);
    }

    public Engine.GetResult get(Engine.Get get) {
        this.readAllowed();
        return this.getEngine().get(get, this::acquireSearcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(String source) {
        this.verifyNotClosed();
        if (this.canIndex()) {
            long bytes = this.getEngine().getIndexBufferRAMBytesUsed();
            this.writingBytes.addAndGet(bytes);
            try {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("refresh with source [{}] indexBufferRAMBytesUsed [{}]", (Object)source, (Object)new ByteSizeValue(bytes));
                }
                long time = System.nanoTime();
                this.getEngine().refresh(source);
                this.refreshMetric.inc(System.nanoTime() - time);
            }
            finally {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("remove [{}] writing bytes for shard [{}]", (Object)new ByteSizeValue(bytes), (Object)this.shardId());
                }
                this.writingBytes.addAndGet(-bytes);
            }
        } else {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("refresh with source [{}]", (Object)source);
            }
            long time = System.nanoTime();
            this.getEngine().refresh(source);
            this.refreshMetric.inc(System.nanoTime() - time);
        }
    }

    public long getWritingBytes() {
        return this.writingBytes.get();
    }

    public RefreshStats refreshStats() {
        return new RefreshStats(this.refreshMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.refreshMetric.sum()));
    }

    public FlushStats flushStats() {
        return new FlushStats(this.flushMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.flushMetric.sum()));
    }

    public DocsStats docStats() {
        this.readAllowed();
        Engine engine = this.getEngine();
        return engine.getDocStats();
    }

    @Nullable
    public CommitStats commitStats() {
        Engine engine = this.getEngineOrNull();
        return engine == null ? null : engine.commitStats();
    }

    public IndexingStats indexingStats(String ... types) {
        long throttleTimeInMillis;
        boolean throttled;
        Engine engine = this.getEngineOrNull();
        if (engine == null) {
            throttled = false;
            throttleTimeInMillis = 0L;
        } else {
            throttled = engine.isThrottled();
            throttleTimeInMillis = engine.getIndexThrottleTimeInMillis();
        }
        return this.internalIndexingStats.stats(throttled, throttleTimeInMillis, types);
    }

    public SearchStats searchStats(String ... groups) {
        return this.searchStats.stats(groups);
    }

    public GetStats getStats() {
        return this.getService.stats();
    }

    public StoreStats storeStats() {
        try {
            return this.store.stats();
        }
        catch (IOException e) {
            throw new ElasticsearchException("io exception while building 'store stats'", (Throwable)e, new Object[0]);
        }
        catch (AlreadyClosedException ex) {
            return null;
        }
    }

    public MergeStats mergeStats() {
        Engine engine = this.getEngineOrNull();
        if (engine == null) {
            return new MergeStats();
        }
        return engine.getMergeStats();
    }

    public SegmentsStats segmentStats(boolean includeSegmentFileSizes) {
        SegmentsStats segmentsStats = this.getEngine().segmentsStats(includeSegmentFileSizes);
        segmentsStats.addBitsetMemoryInBytes(this.shardBitsetFilterCache.getMemorySizeInBytes());
        return segmentsStats;
    }

    public WarmerStats warmerStats() {
        return this.shardWarmerService.stats();
    }

    public FieldDataStats fieldDataStats(String ... fields) {
        return this.shardFieldData.stats(fields);
    }

    public TranslogStats translogStats() {
        return this.getEngine().getTranslog().stats();
    }

    public CompletionStats completionStats(String ... fields) {
        CompletionStats completionStats = new CompletionStats();
        try (Engine.Searcher currentSearcher = this.acquireSearcher("completion_stats");){
            completionStats.add(CompletionFieldStats.completionStats(currentSearcher.reader(), fields));
            Completion090PostingsFormat postingsFormat = (Completion090PostingsFormat)PostingsFormat.forName((String)"completion090");
            completionStats.add(postingsFormat.completionStats(currentSearcher.reader(), fields));
        }
        return completionStats;
    }

    public Engine.SyncedFlushResult syncFlush(String syncId, Engine.CommitId expectedCommitId) {
        this.verifyStartedOrRecovering();
        this.logger.trace("trying to sync flush. sync id [{}]. expected commit id [{}]]", (Object)syncId, (Object)expectedCommitId);
        Engine engine = this.getEngine();
        if (engine.isRecovering()) {
            throw new IllegalIndexShardStateException(this.shardId(), this.state, "syncFlush is only allowed if the engine is not recovery from translog", new Object[0]);
        }
        return engine.syncFlush(syncId, expectedCommitId);
    }

    public Engine.CommitId flush(FlushRequest request) throws ElasticsearchException {
        boolean waitIfOngoing = request.waitIfOngoing();
        boolean force = request.force();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("flush with {}", (Object)request);
        }
        this.verifyStartedOrRecovering();
        Engine engine = this.getEngine();
        if (engine.isRecovering()) {
            throw new IllegalIndexShardStateException(this.shardId(), this.state, "flush is only allowed if the engine is not recovery from translog", new Object[0]);
        }
        long time = System.nanoTime();
        Engine.CommitId commitId = engine.flush(force, waitIfOngoing);
        this.flushMetric.inc(System.nanoTime() - time);
        return commitId;
    }

    public void forceMerge(ForceMergeRequest forceMerge) throws IOException {
        this.verifyStarted();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("force merge with {}", (Object)forceMerge);
        }
        this.getEngine().forceMerge(forceMerge.flush(), forceMerge.maxNumSegments(), forceMerge.onlyExpungeDeletes(), false, false);
    }

    public Version upgrade(UpgradeRequest upgrade) throws IOException {
        this.verifyStarted();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("upgrade with {}", (Object)upgrade);
        }
        Version previousVersion = this.minimumCompatibleVersion();
        this.getEngine().forceMerge(true, Integer.MAX_VALUE, false, true, upgrade.upgradeOnlyAncientSegments());
        Version version = this.minimumCompatibleVersion();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("upgraded segments for {} from version {} to version {}", (Object)this.shardId, (Object)previousVersion, (Object)version);
        }
        return version;
    }

    public Version minimumCompatibleVersion() {
        Version luceneVersion = null;
        for (Segment segment : this.getEngine().segments(false)) {
            if (luceneVersion != null && !luceneVersion.onOrAfter(segment.getVersion())) continue;
            luceneVersion = segment.getVersion();
        }
        return luceneVersion == null ? this.indexSettings.getIndexVersionCreated().luceneVersion : luceneVersion;
    }

    public IndexCommit acquireIndexCommit(boolean flushFirst) throws EngineException {
        IndexShardState state = this.state;
        if (state == IndexShardState.STARTED || state == IndexShardState.RELOCATED || state == IndexShardState.CLOSED) {
            return this.getEngine().acquireIndexCommit(flushFirst);
        }
        throw new IllegalIndexShardStateException(this.shardId, state, "snapshot is not allowed", new Object[0]);
    }

    public void releaseIndexCommit(IndexCommit snapshot) throws IOException {
        this.deletionPolicy.release(snapshot);
    }

    /*
     * Exception decompiling
     */
    public Store.MetadataSnapshot snapshotStoreMetadata() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void failShard(String reason, @Nullable Exception e) {
        this.getEngine().failEngine(reason, e);
    }

    public Engine.Searcher acquireSearcher(String source) {
        Engine.Searcher searcher;
        block6: {
            this.readAllowed();
            Engine engine = this.getEngine();
            Engine.Searcher searcher2 = engine.acquireSearcher(source);
            boolean success = false;
            try {
                Engine.Searcher wrappedSearcher;
                Engine.Searcher searcher3 = wrappedSearcher = this.searcherWrapper == null ? searcher2 : this.searcherWrapper.wrap(searcher2);
                assert (wrappedSearcher != null);
                success = true;
                searcher = wrappedSearcher;
                if (success) break block6;
            }
            catch (IOException ex) {
                try {
                    throw new ElasticsearchException("failed to wrap searcher", (Throwable)ex, new Object[0]);
                }
                catch (Throwable throwable) {
                    if (!success) {
                        Releasables.close(success, searcher2);
                    }
                    throw throwable;
                }
            }
            Releasables.close(success, searcher2);
        }
        return searcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(String reason, boolean flushEngine) throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            try {
                this.changeState(IndexShardState.CLOSED, reason);
            }
            catch (Throwable throwable) {
                Engine engine = this.currentEngineReference.getAndSet(null);
                try {
                    if (engine != null && flushEngine) {
                        engine.flushAndClose();
                    }
                }
                catch (Throwable throwable2) {
                    IOUtils.close((Closeable[])new Closeable[]{engine});
                    this.indexShardOperationsLock.close();
                    throw throwable2;
                }
                IOUtils.close((Closeable[])new Closeable[]{engine});
                this.indexShardOperationsLock.close();
                throw throwable;
            }
            Engine engine = this.currentEngineReference.getAndSet(null);
            try {
                if (engine != null && flushEngine) {
                    engine.flushAndClose();
                }
            }
            catch (Throwable throwable) {
                IOUtils.close((Closeable[])new Closeable[]{engine});
                this.indexShardOperationsLock.close();
                throw throwable;
            }
            IOUtils.close((Closeable[])new Closeable[]{engine});
            this.indexShardOperationsLock.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexShard postRecovery(String reason) throws IndexShardStartedException, IndexShardRelocatedException, IndexShardClosedException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.state == IndexShardState.CLOSED) {
                throw new IndexShardClosedException(this.shardId);
            }
            if (this.state == IndexShardState.STARTED) {
                throw new IndexShardStartedException(this.shardId);
            }
            if (this.state == IndexShardState.RELOCATED) {
                throw new IndexShardRelocatedException(this.shardId);
            }
            this.recoveryState.setStage(RecoveryState.Stage.DONE);
            this.changeState(IndexShardState.POST_RECOVERY, reason);
        }
        return this;
    }

    public void prepareForIndexRecovery() {
        if (this.state != IndexShardState.RECOVERING) {
            throw new IndexShardNotRecoveringException(this.shardId, this.state);
        }
        this.recoveryState.setStage(RecoveryState.Stage.INDEX);
        assert (this.currentEngineReference.get() == null);
    }

    public int performBatchRecovery(Iterable<Translog.Operation> operations) {
        if (this.state != IndexShardState.RECOVERING) {
            throw new IndexShardNotRecoveringException(this.shardId, this.state);
        }
        this.active.set(true);
        Engine engine = this.getEngine();
        return engine.config().getTranslogRecoveryPerformer().performBatchRecovery(engine, operations);
    }

    public void performTranslogRecovery(boolean indexExists) throws IOException {
        if (!indexExists) {
            RecoveryState.Translog translogStats = this.recoveryState().getTranslog();
            translogStats.totalOperations(0);
            translogStats.totalOperationsOnStart(0);
        }
        this.internalPerformTranslogRecovery(false, indexExists, -1L);
        assert (this.recoveryState.getStage() == RecoveryState.Stage.TRANSLOG) : "TRANSLOG stage expected but was: " + (Object)((Object)this.recoveryState.getStage());
    }

    private void internalPerformTranslogRecovery(boolean skipTranslogRecovery, boolean indexExists, long maxUnsafeAutoIdTimestamp) throws IOException {
        if (this.state != IndexShardState.RECOVERING) {
            throw new IndexShardNotRecoveringException(this.shardId, this.state);
        }
        this.recoveryState.setStage(RecoveryState.Stage.VERIFY_INDEX);
        if (Booleans.parseBoolean(this.checkIndexOnStartup, false)) {
            try {
                this.checkIndex();
            }
            catch (IOException ex) {
                throw new RecoveryFailedException(this.recoveryState, "check index failed", (Throwable)ex);
            }
        }
        this.recoveryState.setStage(RecoveryState.Stage.TRANSLOG);
        EngineConfig.OpenMode openMode = !indexExists ? EngineConfig.OpenMode.CREATE_INDEX_AND_TRANSLOG : (skipTranslogRecovery ? EngineConfig.OpenMode.OPEN_INDEX_CREATE_TRANSLOG : EngineConfig.OpenMode.OPEN_INDEX_AND_TRANSLOG);
        EngineConfig config = this.newEngineConfig(openMode, maxUnsafeAutoIdTimestamp);
        config.setEnableGcDeletes(false);
        Engine newEngine = this.createNewEngine(config);
        this.verifyNotClosed();
        if (openMode == EngineConfig.OpenMode.OPEN_INDEX_AND_TRANSLOG) {
            this.active.set(true);
            newEngine.recoverFromTranslog();
        }
    }

    protected void onNewEngine(Engine newEngine) {
        this.refreshListeners.setTranslog(newEngine.getTranslog());
    }

    public void skipTranslogRecovery(long maxUnsafeAutoIdTimestamp) throws IOException {
        assert (this.getEngineOrNull() == null) : "engine was already created";
        this.internalPerformTranslogRecovery(true, true, maxUnsafeAutoIdTimestamp);
        assert (this.recoveryState.getTranslog().recoveredOperations() == 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performRecoveryRestart() throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.state != IndexShardState.RECOVERING) {
                throw new IndexShardNotRecoveringException(this.shardId, this.state);
            }
            Engine engine = this.currentEngineReference.getAndSet(null);
            IOUtils.close((Closeable[])new Closeable[]{engine});
            this.recoveryState().setStage(RecoveryState.Stage.INIT);
        }
    }

    public RecoveryStats recoveryStats() {
        return this.recoveryStats;
    }

    @Override
    public RecoveryState recoveryState() {
        return this.recoveryState;
    }

    public void finalizeRecovery() {
        this.recoveryState().setStage(RecoveryState.Stage.FINALIZE);
        Engine engine = this.getEngine();
        engine.refresh("recovery_finalization");
        engine.config().setEnableGcDeletes(true);
    }

    public boolean ignoreRecoveryAttempt() {
        IndexShardState state = this.state();
        return state == IndexShardState.POST_RECOVERY || state == IndexShardState.RECOVERING || state == IndexShardState.STARTED || state == IndexShardState.RELOCATED || state == IndexShardState.CLOSED;
    }

    public void readAllowed() throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (!readAllowedStates.contains((Object)state)) {
            throw new IllegalIndexShardStateException(this.shardId, state, "operations only allowed when shard state is one of " + readAllowedStates.toString(), new Object[0]);
        }
    }

    private void ensureWriteAllowed(Engine.Operation op) throws IllegalIndexShardStateException {
        Engine.Operation.Origin origin = op.origin();
        IndexShardState state = this.state;
        if (origin == Engine.Operation.Origin.PRIMARY) {
            if (!writeAllowedStatesForPrimary.contains((Object)state)) {
                throw new IllegalIndexShardStateException(this.shardId, state, "operation only allowed when shard state is one of " + writeAllowedStatesForPrimary + ", origin [" + (Object)((Object)origin) + "]", new Object[0]);
            }
        } else if (origin.isRecovery()) {
            if (state != IndexShardState.RECOVERING) {
                throw new IllegalIndexShardStateException(this.shardId, state, "operation only allowed when recovering, origin [" + (Object)((Object)origin) + "]", new Object[0]);
            }
        } else {
            assert (origin == Engine.Operation.Origin.REPLICA);
            if (!writeAllowedStatesForReplica.contains((Object)state)) {
                throw new IllegalIndexShardStateException(this.shardId, state, "operation only allowed when shard state is one of " + writeAllowedStatesForReplica + ", origin [" + (Object)((Object)origin) + "]", new Object[0]);
            }
        }
    }

    private void verifyPrimary() {
        if (!this.shardRouting.primary()) {
            throw new IllegalStateException("shard is not a primary " + this.shardRouting);
        }
    }

    private void verifyReplicationTarget() {
        IndexShardState state = this.state();
        if (this.shardRouting.primary() && this.shardRouting.active() && state != IndexShardState.RELOCATED) {
            throw new IllegalStateException("active primary shard cannot be a replication target before  relocation hand off " + this.shardRouting + ", state is [" + (Object)((Object)state) + "]");
        }
    }

    protected final void verifyStartedOrRecovering() throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (state != IndexShardState.STARTED && state != IndexShardState.RECOVERING && state != IndexShardState.POST_RECOVERY) {
            throw new IllegalIndexShardStateException(this.shardId, state, "operation only allowed when started/recovering", new Object[0]);
        }
    }

    private void verifyNotClosed() throws IllegalIndexShardStateException {
        this.verifyNotClosed(null);
    }

    private void verifyNotClosed(Exception suppressed) throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (state == IndexShardState.CLOSED) {
            IndexShardClosedException exc = new IndexShardClosedException(this.shardId, "operation only allowed when not closed");
            if (suppressed != null) {
                exc.addSuppressed(suppressed);
            }
            throw exc;
        }
    }

    protected final void verifyStarted() throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (state != IndexShardState.STARTED) {
            throw new IndexShardNotStartedException(this.shardId, state);
        }
    }

    public long getIndexBufferRAMBytesUsed() {
        Engine engine = this.getEngineOrNull();
        if (engine == null) {
            return 0L;
        }
        try {
            return engine.getIndexBufferRAMBytesUsed();
        }
        catch (AlreadyClosedException ex) {
            return 0L;
        }
    }

    public void addShardFailureCallback(Callback<ShardFailure> onShardFailure) {
        this.shardEventListener.delegates.add(onShardFailure);
    }

    public void checkIdle(long inactiveTimeNS) {
        boolean wasActive;
        Engine engineOrNull = this.getEngineOrNull();
        if (engineOrNull != null && System.nanoTime() - engineOrNull.getLastWriteNanos() >= inactiveTimeNS && (wasActive = this.active.getAndSet(false))) {
            this.logger.debug("shard is now inactive");
            try {
                this.indexEventListener.onShardInactive(this);
            }
            catch (Exception e) {
                this.logger.warn("failed to notify index event listener", (Throwable)e);
            }
        }
    }

    public boolean isActive() {
        return this.active.get();
    }

    public ShardPath shardPath() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recoverFromLocalShards(BiConsumer<String, MappingMetaData> mappingUpdateConsumer, List<IndexShard> localShards) throws IOException {
        assert (this.shardRouting.primary()) : "recover from local shards only makes sense if the shard is a primary shard";
        assert (this.recoveryState.getRecoverySource().getType() == RecoverySource.Type.LOCAL_SHARDS) : "invalid recovery type: " + this.recoveryState.getRecoverySource();
        ArrayList<LocalShardSnapshot> snapshots = new ArrayList<LocalShardSnapshot>();
        try {
            for (IndexShard shard : localShards) {
                snapshots.add(new LocalShardSnapshot(shard));
            }
            assert (this.shardRouting.primary()) : "recover from local shards only makes sense if the shard is a primary shard";
            StoreRecovery storeRecovery = new StoreRecovery(this.shardId, this.logger);
            boolean bl = storeRecovery.recoverFromLocalShards(mappingUpdateConsumer, this, snapshots);
            return bl;
        }
        finally {
            IOUtils.close(snapshots);
        }
    }

    public boolean recoverFromStore() {
        assert (this.shardRouting.primary()) : "recover from store only makes sense if the shard is a primary shard";
        assert (this.shardRouting.initializing()) : "can only start recovery on initializing shard";
        StoreRecovery storeRecovery = new StoreRecovery(this.shardId, this.logger);
        return storeRecovery.recoverFromStore(this);
    }

    public boolean restoreFromRepository(Repository repository) {
        assert (this.shardRouting.primary()) : "recover from store only makes sense if the shard is a primary shard";
        assert (this.recoveryState.getRecoverySource().getType() == RecoverySource.Type.SNAPSHOT) : "invalid recovery type: " + this.recoveryState.getRecoverySource();
        StoreRecovery storeRecovery = new StoreRecovery(this.shardId, this.logger);
        return storeRecovery.recoverFromRepository(this, repository);
    }

    boolean shouldFlush() {
        Engine engine = this.getEngineOrNull();
        if (engine != null) {
            try {
                Translog translog = engine.getTranslog();
                return translog.sizeInBytes() > this.indexSettings.getFlushThresholdSize().getBytes();
            }
            catch (AlreadyClosedException | EngineClosedException throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public void onSettingsChanged() {
        Engine engineOrNull = this.getEngineOrNull();
        if (engineOrNull != null) {
            engineOrNull.onSettingsChanged();
        }
    }

    public Translog.View acquireTranslogView() {
        Engine engine = this.getEngine();
        assert (engine.getTranslog() != null) : "translog must not be null";
        return engine.getTranslog().newView();
    }

    public List<Segment> segments(boolean verbose) {
        return this.getEngine().segments(verbose);
    }

    public void flushAndCloseEngine() throws IOException {
        this.getEngine().flushAndClose();
    }

    public Translog getTranslog() {
        return this.getEngine().getTranslog();
    }

    public IndexEventListener getIndexEventListener() {
        return this.indexEventListener;
    }

    public void activateThrottling() {
        try {
            this.getEngine().activateThrottling();
        }
        catch (EngineClosedException engineClosedException) {
            // empty catch block
        }
    }

    public void deactivateThrottling() {
        try {
            this.getEngine().deactivateThrottling();
        }
        catch (EngineClosedException engineClosedException) {
            // empty catch block
        }
    }

    private void handleRefreshException(Exception e) {
        if (!(e instanceof EngineClosedException)) {
            if (e instanceof RefreshFailedEngineException) {
                RefreshFailedEngineException rfee = (RefreshFailedEngineException)e;
                if (!(rfee.getCause() instanceof InterruptedException || rfee.getCause() instanceof ClosedByInterruptException || rfee.getCause() instanceof ThreadInterruptedException || this.state == IndexShardState.CLOSED)) {
                    this.logger.warn("Failed to perform engine refresh", (Throwable)e);
                }
            } else if (this.state != IndexShardState.CLOSED) {
                this.logger.warn("Failed to perform engine refresh", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeIndexingBuffer() {
        if (!this.canIndex()) {
            throw new UnsupportedOperationException();
        }
        try {
            Engine engine = this.getEngine();
            long bytes = engine.getIndexBufferRAMBytesUsed();
            this.logger.debug("add [{}] writing bytes for shard [{}]", (Object)new ByteSizeValue(bytes), (Object)this.shardId());
            this.writingBytes.addAndGet(bytes);
            try {
                engine.writeIndexingBuffer();
            }
            finally {
                this.writingBytes.addAndGet(-bytes);
                this.logger.debug("remove [{}] writing bytes for shard [{}]", (Object)new ByteSizeValue(bytes), (Object)this.shardId());
            }
        }
        catch (Exception e) {
            this.handleRefreshException(e);
        }
    }

    public void noopUpdate(String type) {
        this.internalIndexingStats.noopUpdate(type);
    }

    private void checkIndex() throws IOException {
        if (this.store.tryIncRef()) {
            try {
                this.doCheckIndex();
            }
            finally {
                this.store.decRef();
            }
        }
    }

    private void doCheckIndex() throws IOException {
        BytesStreamOutput os;
        long timeNS;
        block27: {
            timeNS = System.nanoTime();
            if (!Lucene.indexExists(this.store.directory())) {
                return;
            }
            os = new BytesStreamOutput();
            PrintStream out = new PrintStream((OutputStream)os, false, StandardCharsets.UTF_8.name());
            if ("checksum".equals(this.checkIndexOnStartup)) {
                IOException corrupt = null;
                Store.MetadataSnapshot metadata = this.snapshotStoreMetadata();
                for (Map.Entry<String, StoreFileMetaData> entry : metadata.asMap().entrySet()) {
                    try {
                        Store.checkIntegrity(entry.getValue(), this.store.directory());
                        out.println("checksum passed: " + entry.getKey());
                    }
                    catch (IOException exc) {
                        out.println("checksum failed: " + entry.getKey());
                        exc.printStackTrace(out);
                        corrupt = exc;
                    }
                }
                out.flush();
                if (corrupt != null) {
                    this.logger.warn("check index [failure]\n{}", (Object)os.bytes().utf8ToString());
                    throw corrupt;
                }
            } else {
                try (CheckIndex checkIndex = new CheckIndex(this.store.directory());){
                    checkIndex.setInfoStream(out);
                    CheckIndex.Status status = checkIndex.checkIndex();
                    out.flush();
                    if (status.clean) break block27;
                    if (this.state == IndexShardState.CLOSED) {
                        return;
                    }
                    this.logger.warn("check index [failure]\n{}", (Object)os.bytes().utf8ToString());
                    if ("fix".equals(this.checkIndexOnStartup)) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("fixing index, writing new segments file ...");
                        }
                        checkIndex.exorciseIndex(status);
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("index fixed, wrote new segments file \"{}\"", (Object)status.segmentsFileName);
                        }
                        break block27;
                    }
                    throw new IllegalStateException("index check failure but can't fix it");
                }
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("check index [success]\n{}", (Object)os.bytes().utf8ToString());
        }
        this.recoveryState.getVerifyIndex().checkIndexTime(Math.max(0L, TimeValue.nsecToMSec(System.nanoTime() - timeNS)));
    }

    Engine getEngine() {
        Engine engine = this.getEngineOrNull();
        if (engine == null) {
            throw new EngineClosedException(this.shardId);
        }
        return engine;
    }

    protected Engine getEngineOrNull() {
        return this.currentEngineReference.get();
    }

    public void startRecovery(RecoveryState recoveryState, PeerRecoveryTargetService recoveryTargetService, PeerRecoveryTargetService.RecoveryListener recoveryListener, RepositoriesService repositoriesService, BiConsumer<String, MappingMetaData> mappingUpdateConsumer, IndicesService indicesService) {
        assert (recoveryState.getRecoverySource().equals(this.shardRouting.recoverySource()));
        switch (recoveryState.getRecoverySource().getType()) {
            case EMPTY_STORE: 
            case EXISTING_STORE: {
                this.markAsRecovering("from store", recoveryState);
                this.threadPool.generic().execute(() -> {
                    try {
                        if (this.recoverFromStore()) {
                            recoveryListener.onRecoveryDone(recoveryState);
                        }
                    }
                    catch (Exception e) {
                        recoveryListener.onRecoveryFailure(recoveryState, new RecoveryFailedException(recoveryState, null, (Throwable)e), true);
                    }
                });
                break;
            }
            case PEER: {
                try {
                    this.markAsRecovering("from " + recoveryState.getSourceNode(), recoveryState);
                    recoveryTargetService.startRecovery(this, recoveryState.getSourceNode(), recoveryListener);
                }
                catch (Exception e) {
                    this.failShard("corrupted preexisting index", e);
                    recoveryListener.onRecoveryFailure(recoveryState, new RecoveryFailedException(recoveryState, null, (Throwable)e), true);
                }
                break;
            }
            case SNAPSHOT: {
                this.markAsRecovering("from snapshot", recoveryState);
                RecoverySource.SnapshotRecoverySource recoverySource = (RecoverySource.SnapshotRecoverySource)recoveryState.getRecoverySource();
                this.threadPool.generic().execute(() -> {
                    try {
                        Repository repository = repositoriesService.repository(recoverySource.snapshot().getRepository());
                        if (this.restoreFromRepository(repository)) {
                            recoveryListener.onRecoveryDone(recoveryState);
                        }
                    }
                    catch (Exception e) {
                        recoveryListener.onRecoveryFailure(recoveryState, new RecoveryFailedException(recoveryState, null, (Throwable)e), true);
                    }
                });
                break;
            }
            case LOCAL_SHARDS: {
                int numShards;
                IndexMetaData indexMetaData = this.indexSettings().getIndexMetaData();
                Index mergeSourceIndex = indexMetaData.getMergeSourceIndex();
                ArrayList<IndexShard> startedShards = new ArrayList<IndexShard>();
                IndexService sourceIndexService = indicesService.indexService(mergeSourceIndex);
                int n = numShards = sourceIndexService != null ? sourceIndexService.getIndexSettings().getNumberOfShards() : -1;
                if (sourceIndexService != null) {
                    for (IndexShard shard : sourceIndexService) {
                        if (shard.state() != IndexShardState.STARTED) continue;
                        startedShards.add(shard);
                    }
                }
                if (numShards == startedShards.size()) {
                    this.markAsRecovering("from local shards", recoveryState);
                    this.threadPool.generic().execute(() -> {
                        try {
                            Set<ShardId> shards = IndexMetaData.selectShrinkShards(this.shardId().id(), sourceIndexService.getMetaData(), indexMetaData.getNumberOfShards());
                            if (this.recoverFromLocalShards(mappingUpdateConsumer, startedShards.stream().filter(s -> shards.contains(s.shardId())).collect(Collectors.toList()))) {
                                recoveryListener.onRecoveryDone(recoveryState);
                            }
                        }
                        catch (Exception e) {
                            recoveryListener.onRecoveryFailure(recoveryState, new RecoveryFailedException(recoveryState, null, (Throwable)e), true);
                        }
                    });
                    break;
                }
                RuntimeException e = numShards == -1 ? new IndexNotFoundException(mergeSourceIndex) : new IllegalStateException("not all shards from index " + mergeSourceIndex + " are started yet, expected " + numShards + " found " + startedShards.size() + " can't recover shard " + this.shardId());
                recoveryListener.onRecoveryFailure(recoveryState, new RecoveryFailedException(recoveryState, null, (Throwable)e), true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown recovery source " + recoveryState.getRecoverySource());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Engine createNewEngine(EngineConfig config) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.state == IndexShardState.CLOSED) {
                throw new EngineClosedException(this.shardId);
            }
            assert (this.currentEngineReference.get() == null);
            Engine engine = this.newEngine(config);
            this.onNewEngine(engine);
            this.currentEngineReference.set(engine);
        }
        Engine engine = this.getEngineOrNull();
        if (engine != null) {
            engine.onSettingsChanged();
        }
        return engine;
    }

    protected Engine newEngine(EngineConfig config) {
        return this.engineFactory.newReadWriteEngine(config);
    }

    void persistMetadata(ShardRouting newRouting, @Nullable ShardRouting currentRouting) throws IOException {
        assert (newRouting != null) : "newRouting must not be null";
        if (currentRouting == null || currentRouting.primary() != newRouting.primary() || !currentRouting.allocationId().equals(newRouting.allocationId())) {
            assert (currentRouting == null || currentRouting.isSameAllocation(newRouting));
            String writeReason = currentRouting == null ? "initial state with allocation id [" + newRouting.allocationId() + "]" : "routing changed from " + currentRouting + " to " + newRouting;
            this.logger.trace("{} writing shard state, reason [{}]", (Object)this.shardId, (Object)writeReason);
            ShardStateMetaData newShardStateMetadata = new ShardStateMetaData(newRouting.primary(), this.getIndexUUID(), newRouting.allocationId());
            ShardStateMetaData.FORMAT.write(newShardStateMetadata, this.shardPath().getShardStatePath());
        } else {
            this.logger.trace("{} skip writing shard state, has been written before", (Object)this.shardId);
        }
    }

    private String getIndexUUID() {
        return this.indexSettings.getUUID();
    }

    private DocumentMapperForType docMapper(String type) {
        return this.mapperService.documentMapperWithAutoCreate(type);
    }

    private EngineConfig newEngineConfig(EngineConfig.OpenMode openMode, long maxUnsafeAutoIdTimestamp) {
        IndexShardRecoveryPerformer translogRecoveryPerformer = new IndexShardRecoveryPerformer(this.shardId, this.mapperService, this.logger);
        return new EngineConfig(openMode, this.shardId, this.threadPool, this.indexSettings, this.warmer, this.store, this.deletionPolicy, this.indexSettings.getMergePolicy(), this.mapperService.indexAnalyzer(), this.similarityService.similarity(this.mapperService), this.codecService, this.shardEventListener, translogRecoveryPerformer, this.indexCache.query(), this.cachingPolicy, this.translogConfig, IndexingMemoryController.SHARD_INACTIVE_TIME_SETTING.get(this.indexSettings.getSettings()), this.refreshListeners, maxUnsafeAutoIdTimestamp);
    }

    public void acquirePrimaryOperationLock(ActionListener<Releasable> onLockAcquired, String executorOnDelay) {
        this.verifyNotClosed();
        this.verifyPrimary();
        this.indexShardOperationsLock.acquire(onLockAcquired, executorOnDelay, false);
    }

    public void acquireReplicaOperationLock(long opPrimaryTerm, ActionListener<Releasable> onLockAcquired, String executorOnDelay) {
        this.verifyNotClosed();
        this.verifyReplicationTarget();
        if (this.primaryTerm > opPrimaryTerm) {
            throw new IllegalArgumentException(LoggerMessageFormat.format("{} operation term [{}] is too old (current [{}])", this.shardId, opPrimaryTerm, this.primaryTerm));
        }
        this.indexShardOperationsLock.acquire(onLockAcquired, executorOnDelay, true);
    }

    public int getActiveOperationsCount() {
        return this.indexShardOperationsLock.getActiveOperationsCount();
    }

    public final void sync(Translog.Location location, Consumer<Exception> syncListener) {
        this.verifyNotClosed();
        this.translogSyncProcessor.put(location, syncListener);
    }

    public Translog.Durability getTranslogDurability() {
        return this.indexSettings.getTranslogDurability();
    }

    public boolean maybeFlush() {
        if (this.shouldFlush() && this.asyncFlushRunning.compareAndSet(false, true)) {
            if (!this.shouldFlush()) {
                this.asyncFlushRunning.compareAndSet(true, false);
            } else {
                this.logger.debug("submitting async flush request");
                AbstractRunnable abstractRunnable = new AbstractRunnable(){

                    @Override
                    public void onFailure(Exception e) {
                        if (IndexShard.this.state != IndexShardState.CLOSED) {
                            IndexShard.this.logger.warn("failed to flush index", (Throwable)e);
                        }
                    }

                    @Override
                    protected void doRun() throws Exception {
                        IndexShard.this.flush(new FlushRequest(new String[0]));
                    }

                    @Override
                    public void onAfter() {
                        IndexShard.this.asyncFlushRunning.compareAndSet(true, false);
                        IndexShard.this.maybeFlush();
                    }
                };
                this.threadPool.executor("flush").execute(abstractRunnable);
                return true;
            }
        }
        return false;
    }

    protected RefreshListeners buildRefreshListeners() {
        return new RefreshListeners(this.indexSettings::getMaxRefreshListeners, () -> this.refresh("too_many_listeners"), this.threadPool.executor("listener")::execute, this.logger);
    }

    EngineFactory getEngineFactory() {
        return this.engineFactory;
    }

    public boolean isRefreshNeeded() {
        return this.getEngine().refreshNeeded() || this.refreshListeners != null && this.refreshListeners.refreshNeeded();
    }

    public void addRefreshListener(Translog.Location location, Consumer<Boolean> listener) {
        this.refreshListeners.addOrNotify(location, listener);
    }

    private class IndexShardRecoveryPerformer
    extends TranslogRecoveryPerformer {
        protected IndexShardRecoveryPerformer(ShardId shardId, MapperService mapperService, Logger logger) {
            super(shardId, mapperService, logger);
        }

        @Override
        protected void operationProcessed() {
            assert (IndexShard.this.recoveryState != null);
            IndexShard.this.recoveryState.getTranslog().incrementRecoveredOperations();
        }

        @Override
        public int recoveryFromSnapshot(Engine engine, Translog.Snapshot snapshot) throws IOException {
            assert (IndexShard.this.recoveryState != null);
            RecoveryState.Translog translogStats = IndexShard.this.recoveryState.getTranslog();
            translogStats.totalOperations(snapshot.totalOperations());
            translogStats.totalOperationsOnStart(snapshot.totalOperations());
            return super.recoveryFromSnapshot(engine, snapshot);
        }

        @Override
        protected void index(Engine engine, Engine.Index engineIndex) {
            IndexShard.this.index(engine, engineIndex);
        }

        @Override
        protected void delete(Engine engine, Engine.Delete engineDelete) {
            IndexShard.this.delete(engine, engineDelete);
        }
    }

    public static final class ShardFailure {
        public final ShardRouting routing;
        public final String reason;
        @Nullable
        public final Exception cause;

        public ShardFailure(ShardRouting routing, String reason, @Nullable Exception cause) {
            this.routing = routing;
            this.reason = reason;
            this.cause = cause;
        }
    }

    class ShardEventListener
    implements Engine.EventListener {
        private final CopyOnWriteArrayList<Callback<ShardFailure>> delegates = new CopyOnWriteArrayList();

        ShardEventListener() {
        }

        @Override
        public void onFailedEngine(String reason, @Nullable Exception failure) {
            ShardFailure shardFailure = new ShardFailure(IndexShard.this.shardRouting, reason, failure);
            for (Callback<ShardFailure> listener : this.delegates) {
                try {
                    listener.handle(shardFailure);
                }
                catch (Exception inner) {
                    inner.addSuppressed(failure);
                    IndexShard.this.logger.warn("exception while notifying engine failure", (Throwable)inner);
                }
            }
        }
    }
}

