/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util.objectTree;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.openapi.util.objectTree.ObjectNode;
import org.jetbrains.kotlin.com.intellij.openapi.util.objectTree.ObjectTreeAction;
import org.jetbrains.kotlin.com.intellij.openapi.util.objectTree.ObjectTreeListener;
import org.jetbrains.kotlin.com.intellij.openapi.util.objectTree.ThrowableInterner;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.WeakHashMap;

public final class ObjectTree<T> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.objectTree.ObjectTree");
    private final List<ObjectTreeListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Set<T> myRootObjects = ContainerUtil.newIdentityTroveSet();
    private final Map<T, ObjectNode<T>> myObject2NodeMap = ContainerUtil.newIdentityTroveMap();
    private final Map<Object, Object> myDisposedObjects = new WeakHashMap(100, 0.5f, ContainerUtil.identityStrategy());
    private final List<ObjectNode<T>> myExecutedNodes = new ArrayList<ObjectNode<T>>();
    private final List<T> myExecutedUnregisteredNodes = new ArrayList<T>();
    final Object treeLock = new Object();
    private final AtomicLong myModification = new AtomicLong(0L);

    ObjectNode<T> getNode(@NotNull T object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "org/jetbrains/kotlin/com/intellij/openapi/util/objectTree/ObjectTree", "getNode"));
        }
        return this.myObject2NodeMap.get(object);
    }

    ObjectNode<T> putNode(@NotNull T object, @Nullable(value="null means remove") ObjectNode<T> node) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "org/jetbrains/kotlin/com/intellij/openapi/util/objectTree/ObjectTree", "putNode"));
        }
        return node == null ? this.myObject2NodeMap.remove(object) : this.myObject2NodeMap.put(object, node);
    }

    @NotNull
    final List<ObjectNode<T>> getNodesInExecution() {
        List<ObjectNode<T>> list2 = this.myExecutedNodes;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/objectTree/ObjectTree", "getNodesInExecution"));
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void register(@NotNull T parent2, @NotNull T child) {
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/com/intellij/openapi/util/objectTree/ObjectTree", "register"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/kotlin/com/intellij/openapi/util/objectTree/ObjectTree", "register"));
        }
        Object object = this.treeLock;
        synchronized (object) {
            ObjectNode<T> childNode;
            Object wasDisposed = this.myDisposedObjects.get(parent2);
            if (wasDisposed != null) {
                throw new IncorrectOperationException("Sorry but parent: " + parent2 + " has already been disposed " + "(see the cause for stacktrace) so the child: " + child + " will never be disposed", wasDisposed instanceof Throwable ? (Throwable)wasDisposed : null);
            }
            this.myDisposedObjects.remove(child);
            ObjectNode<T> parentNode = this.getNode(parent2);
            if (parentNode == null) {
                parentNode = this.createNodeFor(parent2, null);
            }
            if ((childNode = this.getNode(child)) == null) {
                childNode = this.createNodeFor(child, parentNode);
            } else {
                ObjectNode<T> oldParent = childNode.getParent();
                if (oldParent != null) {
                    oldParent.removeChild(childNode);
                }
            }
            this.myRootObjects.remove(child);
            this.checkWasNotAddedAlready(parentNode, childNode);
            parentNode.addChild(childNode);
            this.fireRegistered(childNode.getObject());
        }
    }

    private void checkWasNotAddedAlready(ObjectNode<T> childNode, @NotNull ObjectNode<T> parentNode) {
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "org/jetbrains/kotlin/com/intellij/openapi/util/objectTree/ObjectTree", "checkWasNotAddedAlready"));
        }
        for (ObjectNode<T> node = childNode; node != null; node = node.getParent()) {
            if (node != parentNode) continue;
            throw new IncorrectOperationException("'" + childNode.getObject() + "' was already added as a child of '" + parentNode.getObject() + "'");
        }
    }

    @NotNull
    private ObjectNode<T> createNodeFor(@NotNull T object, @Nullable ObjectNode<T> parentNode) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "org/jetbrains/kotlin/com/intellij/openapi/util/objectTree/ObjectTree", "createNodeFor"));
        }
        ObjectNode<T> newNode = new ObjectNode<T>(this, parentNode, object, this.getNextModification());
        if (parentNode == null) {
            this.myRootObjects.add(object);
        }
        this.putNode(object, newNode);
        ObjectNode<T> objectNode = newNode;
        if (objectNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/objectTree/ObjectTree", "createNodeFor"));
        }
        return objectNode;
    }

    private long getNextModification() {
        return this.myModification.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean executeAll(@NotNull T object, boolean disposeTree, @NotNull ObjectTreeAction<T> action, boolean processUnregistered) {
        ObjectNode<T> node;
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "org/jetbrains/kotlin/com/intellij/openapi/util/objectTree/ObjectTree", "executeAll"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "org/jetbrains/kotlin/com/intellij/openapi/util/objectTree/ObjectTree", "executeAll"));
        }
        Object object2 = this.treeLock;
        synchronized (object2) {
            node = this.getNode(object);
        }
        if (node == null) {
            if (processUnregistered) {
                this.executeUnregistered(object, action);
                return true;
            }
            return false;
        }
        node.execute(disposeTree, action);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> void executeActionWithRecursiveGuard(@NotNull T object, @NotNull List<T> recursiveGuard, @NotNull ObjectTreeAction<T> action) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "org/jetbrains/kotlin/com/intellij/openapi/util/objectTree/ObjectTree", "executeActionWithRecursiveGuard"));
        }
        if (recursiveGuard == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recursiveGuard", "org/jetbrains/kotlin/com/intellij/openapi/util/objectTree/ObjectTree", "executeActionWithRecursiveGuard"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "org/jetbrains/kotlin/com/intellij/openapi/util/objectTree/ObjectTree", "executeActionWithRecursiveGuard"));
        }
        List<T> list2 = recursiveGuard;
        synchronized (list2) {
            if (ArrayUtil.indexOf(recursiveGuard, object, ContainerUtil.identityStrategy()) != -1) {
                return;
            }
            recursiveGuard.add(object);
        }
        try {
            action.execute(object);
        }
        finally {
            list2 = recursiveGuard;
            synchronized (list2) {
                int i = ArrayUtil.lastIndexOf(recursiveGuard, object, ContainerUtil.identityStrategy());
                assert (i != -1);
                recursiveGuard.remove(i);
            }
        }
    }

    private void executeUnregistered(@NotNull T object, @NotNull ObjectTreeAction<T> action) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "org/jetbrains/kotlin/com/intellij/openapi/util/objectTree/ObjectTree", "executeUnregistered"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "org/jetbrains/kotlin/com/intellij/openapi/util/objectTree/ObjectTree", "executeUnregistered"));
        }
        ObjectTree.executeActionWithRecursiveGuard(object, this.myExecutedUnregisteredNodes, action);
    }

    void removeRootObject(@NotNull T object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "org/jetbrains/kotlin/com/intellij/openapi/util/objectTree/ObjectTree", "removeRootObject"));
        }
        this.myRootObjects.remove(object);
    }

    private void fireRegistered(@NotNull Object object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "org/jetbrains/kotlin/com/intellij/openapi/util/objectTree/ObjectTree", "fireRegistered"));
        }
        for (ObjectTreeListener each : this.myListeners) {
            each.objectRegistered(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireExecuted(@NotNull Object object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "org/jetbrains/kotlin/com/intellij/openapi/util/objectTree/ObjectTree", "fireExecuted"));
        }
        for (ObjectTreeListener each : this.myListeners) {
            each.objectExecuted(object);
        }
        Object object2 = this.treeLock;
        synchronized (object2) {
            this.myDisposedObjects.put(object, Disposer.isDebugMode() ? ThrowableInterner.intern(new Throwable()) : Boolean.TRUE);
        }
    }
}

