/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cif;

import java.util.Hashtable;
import javajs.util.CifDataParser;
import javajs.util.Lst;
import javajs.util.PT;

public class Cif2DataParser
extends CifDataParser {
    @Override
    protected int getVersion() {
        return 2;
    }

    @Override
    public String toUnicode(String data) {
        return data;
    }

    @Override
    protected boolean isQuote(char ch) {
        switch (ch) {
            case '\u0001': 
            case '\"': 
            case '\'': 
            case ';': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    @Override
    protected Object getQuotedStringOrObject(char ch) {
        return this.processQuotedString();
    }

    @Override
    protected String preprocessString() throws Exception {
        this.line = this.ich == 0 ? this.str : this.str.substring(this.ich);
        return this.setString(this.processSemiString());
    }

    private Object processQuotedString() {
        String str = null;
        char quoteChar = this.str.charAt(this.ich);
        String tripleChar = null;
        try {
            switch (quoteChar) {
                case '\u0001': {
                    this.ich = this.str.indexOf("\u0001", this.ich + 1);
                    str = this.str.substring(1, this.ich);
                    ++this.ich;
                    break;
                }
                case '[': {
                    return this.readList();
                }
                case ']': {
                    ++this.ich;
                    return "]";
                }
                case '{': {
                    return this.readTable();
                }
                case '}': {
                    ++this.ich;
                    return "}";
                }
                case '\"': 
                case '\'': {
                    if (this.str.indexOf("'''") == this.ich) {
                        tripleChar = "'''";
                    } else if (this.str.indexOf("\"\"\"") == this.ich) {
                        tripleChar = "\"\"\"";
                    }
                    int nchar = tripleChar == null ? 1 : 3;
                    int pt = this.ich + nchar;
                    int pt1 = 0;
                    while ((pt1 = tripleChar == null ? this.str.indexOf(quoteChar, pt) : this.str.indexOf(tripleChar, pt)) < 0 && this.readLine() != null) {
                        this.str = this.str + this.line;
                    }
                    this.ich = pt1 + nchar;
                    this.cch = this.str.length();
                    str = this.str.substring(pt, pt1);
                }
            }
        }
        catch (Exception e) {
            System.out.println("exception in Cif2DataParser ; " + e);
        }
        return this.cterm == '\u0000' || this.asObject ? str : PT.esc(str);
    }

    protected String processSemiString() throws Exception {
        int pt2;
        int pt1;
        String str = this.preprocessSemiString();
        if (str.indexOf(59) != 1 && (pt1 = str.indexOf(92)) > 1 && ((pt2 = str.indexOf(10)) > pt1 || pt2 < 0)) {
            String prefix = str.substring(1, pt1);
            str = PT.rep(str, "\n" + prefix, "\n");
            str = "\u0001" + str.substring(str.charAt(pt1 + 1) == '\\' ? pt1 + 1 : (pt2 < 0 ? str.length() - 1 : pt2 + 1));
        }
        this.ich = 0;
        return this.fixLineFolding(str);
    }

    public Object readList() throws Exception {
        ++this.ich;
        char cterm0 = this.cterm;
        this.cterm = (char)93;
        String ns = this.nullString;
        this.nullString = null;
        Lst<Object> lst = this.asObject ? new Lst<Object>() : null;
        int n = 0;
        String str = "";
        while (true) {
            Object value;
            Object object = value = this.asObject ? this.getNextTokenObject() : this.getNextToken();
            if (value == null || value.equals("]")) break;
            if (this.asObject) {
                lst.addLast(value);
                continue;
            }
            if (n++ > 0) {
                str = str + ",";
            }
            str = str + value;
        }
        this.cterm = cterm0;
        this.nullString = ns;
        return this.asObject ? lst : "[" + str + "]";
    }

    public Object readTable() throws Exception {
        String key;
        ++this.ich;
        char cterm0 = this.cterm;
        this.cterm = (char)125;
        String ns = this.nullString;
        this.nullString = null;
        Hashtable<String, Object> map = this.asObject ? new Hashtable<String, Object>() : null;
        int n = 0;
        String str = "";
        while ((key = this.getNextToken()) != null && !key.equals("}")) {
            while (this.isSpaceOrColon(this.ich)) {
                ++this.ich;
            }
            if (this.asObject) {
                map.put(key, this.getNextTokenObject());
                continue;
            }
            if (n++ > 0) {
                str = str + ",";
            }
            str = str + key + " : " + this.getNextToken();
        }
        this.cterm = cterm0;
        this.nullString = ns;
        return this.asObject ? map : "{" + str + "}";
    }

    private boolean isSpaceOrColon(int ich) {
        if (ich < this.cch) {
            switch (this.line.charAt(ich)) {
                case '\t': 
                case '\n': 
                case ' ': 
                case ':': {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected Object unquoted(String s) {
        char c;
        if (this.cterm == '\u0000' && !this.asObject) {
            return s;
        }
        int n = s.length();
        if (n > 0 && (PT.isDigit(c = s.charAt(0)) || c == '-' || c == '.' && n > 1)) {
            boolean isFloat;
            int pt = s.indexOf(40);
            boolean bl = isFloat = s.indexOf(".") >= 0;
            if (n > 1 && pt > 0 && s.indexOf(41, pt + 1) == n - 1) {
                s = s.substring(0, pt);
            }
            try {
                if (isFloat) {
                    float f = Float.parseFloat(s);
                    if (this.asObject) {
                        return Float.valueOf(f);
                    }
                    s = "" + f;
                    if (s.indexOf(".") < 0 && s.indexOf("E") < 0) {
                        s = s + ".0";
                    }
                    return s;
                }
                int i = Integer.parseInt(s);
                return this.asObject ? Integer.valueOf(i) : "" + i;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.asObject ? s : PT.esc(s);
    }

    private String fixLineFolding(String str) {
        int eol;
        if (str.indexOf(92) < 0) {
            return str;
        }
        int n = str.length();
        if (str.endsWith("\\\u0001")) {
            str = str.substring(0, n - 1) + "\n\u0001";
        }
        int pt = 0;
        while ((pt = str.indexOf(92, pt + 1)) >= 0 && (eol = str.indexOf(10, pt)) >= 0) {
            int i = eol;
            while (--i > pt) {
                char ch = str.charAt(i);
                if (PT.isWhitespace(ch)) continue;
                if (ch == '\\') {
                    pt = i;
                    break;
                }
                pt = eol;
                break;
            }
            if (pt >= eol) continue;
            str = str.substring(0, pt) + str.substring(eol + 1);
        }
        return str;
    }
}

