/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.util.function.Function;

public class MultiLineFlowLayout
extends FlowLayout {
    public MultiLineFlowLayout() {
    }

    public MultiLineFlowLayout(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    public MultiLineFlowLayout(int n) {
        super(n);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        return this.getLayoutSize(container, Component::getPreferredSize);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.getLayoutSize(container, Component::getMinimumSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension getLayoutSize(Container container, Function<Component, Dimension> function) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n = MultiLineFlowLayout.getWidthOf(container);
            Insets insets = container.getInsets();
            int n2 = n - insets.left - insets.right - this.getHgap() * 2;
            int n3 = 0;
            int n4 = insets.top + insets.bottom + this.getVgap() * 2;
            int n5 = 0;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                Dimension dimension = function.apply(component);
                if (n3 != 0) {
                    n3 += this.getHgap();
                }
                if ((n3 = (int)((double)n3 + dimension.getWidth())) > n2) {
                    n4 += n5 + this.getVgap();
                    n5 = 0;
                    n3 = 0;
                }
                n5 = Math.max(n5, dimension.height);
            }
            return new Dimension(n, n4 += n5);
        }
    }

    private static int getWidthOf(Container container) {
        Container container2 = container;
        while (container2.getWidth() == 0 && container2.getParent() != null) {
            container2 = container2.getParent();
        }
        int n = container2.getWidth();
        if (n == 0) {
            return Integer.MAX_VALUE;
        }
        return n;
    }

    @Override
    public String toString() {
        return "MultiLineFlowLayout [align=" + this.getAlignment() + ']';
    }
}

