/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.vm;

import java.util.concurrent.Executor;

abstract class ComputeInExecutor<R>
implements Runnable {
    private final Executor executor;
    private R result;
    private Throwable exception;
    private boolean started;
    private boolean done;

    protected ComputeInExecutor(Executor executor) {
        this.executor = executor;
    }

    protected abstract R compute();

    public final R get() {
        this.perform();
        if (this.executor != null) {
            this.waitForDone();
        }
        this.exceptionCheck();
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForDone() {
        ComputeInExecutor computeInExecutor = this;
        synchronized (computeInExecutor) {
            while (!this.done) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private void exceptionCheck() throws RuntimeException {
        if (this.exception instanceof RuntimeException) {
            throw (RuntimeException)this.exception;
        }
        if (this.exception != null) {
            throw new RuntimeException(this.exception);
        }
    }

    public final void perform() {
        if (this.started) {
            return;
        }
        this.started = true;
        if (this.executor == null) {
            this.run();
        } else {
            this.executor.execute(this);
        }
        this.exceptionCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        try {
            this.result = this.compute();
        }
        catch (Exception ex) {
            this.exception = ex.getClass() == RuntimeException.class && ex.getCause() != null ? ex.getCause() : ex;
        }
        finally {
            if (this.executor != null) {
                ComputeInExecutor computeInExecutor = this;
                synchronized (computeInExecutor) {
                    this.done = true;
                    this.notifyAll();
                }
            } else {
                this.done = true;
            }
        }
    }

    public final String toString() {
        return "value=" + this.result + ",exception=" + this.exception + ",computed=" + this.done;
    }
}

