/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core;

import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.core.CoreLibrary;
import org.jruby.truffle.core.InlinedCoreMethodNode;
import org.jruby.truffle.core.numeric.FixnumNodesFactory;
import org.jruby.truffle.language.Options;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.dispatch.RubyCallNode;
import org.jruby.truffle.language.dispatch.RubyCallNodeParameters;
import org.jruby.truffle.language.methods.InternalMethod;

public class CoreMethods {
    private final InternalMethod fixnumPlus;
    private final InternalMethod fixnumMinus;
    private final InternalMethod fixnumMul;

    public CoreMethods(CoreLibrary coreLibrary) {
        this.fixnumPlus = this.getMethod(coreLibrary.getFixnumClass(), "+");
        this.fixnumMinus = this.getMethod(coreLibrary.getFixnumClass(), "-");
        this.fixnumMul = this.getMethod(coreLibrary.getFixnumClass(), "*");
    }

    private InternalMethod getMethod(DynamicObject module, String name) {
        InternalMethod method = Layouts.MODULE.getFields(module).getMethod(name);
        if (method == null) {
            throw new AssertionError();
        }
        return method;
    }

    public RubyNode createCallNode(RubyCallNodeParameters callParameters) {
        if (!Options.BASICOPS_INLINE || callParameters.getBlock() != null || callParameters.isSplatted() || callParameters.isSafeNavigation()) {
            return new RubyCallNode(callParameters);
        }
        int n = 1 + callParameters.getArguments().length;
        if (n == 2) {
            switch (callParameters.getMethodName()) {
                case "+": {
                    return InlinedCoreMethodNode.inlineBuiltin(callParameters, this.fixnumPlus, FixnumNodesFactory.AddNodeFactory.getInstance());
                }
                case "-": {
                    return InlinedCoreMethodNode.inlineBuiltin(callParameters, this.fixnumMinus, FixnumNodesFactory.SubNodeFactory.getInstance());
                }
                case "*": {
                    return InlinedCoreMethodNode.inlineBuiltin(callParameters, this.fixnumMul, FixnumNodesFactory.MulNodeFactory.getInstance());
                }
            }
        }
        return new RubyCallNode(callParameters);
    }
}

