/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rope;

import org.jcodings.Encoding;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.Rope;

public class RepeatingRope
extends Rope {
    private final Rope child;
    private final int times;

    public RepeatingRope(Rope child, int times) {
        super(child.getEncoding(), child.getCodeRange(), child.isSingleByteOptimizable(), child.byteLength() * times, child.characterLength() * times, child.depth() + 1, null);
        this.child = child;
        this.times = times;
    }

    @Override
    public Rope withEncoding(Encoding newEncoding, CodeRange newCodeRange) {
        return new RepeatingRope(this.child.withEncoding(newEncoding, newCodeRange), this.times);
    }

    @Override
    protected byte[] getBytesSlow() {
        if (this.child.getRawBytes() != null) {
            int n;
            byte[] childBytes = this.child.getRawBytes();
            int len = childBytes.length * this.times;
            byte[] ret = new byte[len];
            System.arraycopy(childBytes, 0, ret, 0, n);
            for (n = childBytes.length; n <= len / 2; n *= 2) {
                System.arraycopy(ret, 0, ret, n, n);
            }
            System.arraycopy(ret, 0, ret, n, len - n);
            return ret;
        }
        return super.getBytesSlow();
    }

    @Override
    protected byte getByteSlow(int index) {
        return this.child.getByteSlow(index % this.child.byteLength());
    }

    public Rope getChild() {
        return this.child;
    }

    public int getTimes() {
        return this.times;
    }

    public String toString() {
        String childString = this.child.toString();
        StringBuilder builder = new StringBuilder(childString.length() * this.times);
        for (int i = 0; i < this.times; ++i) {
            builder.append(childString);
        }
        return builder.toString();
    }
}

