/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.language.RubyBaseNode;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;

public class WarnNode
extends RubyBaseNode {
    @Node.Child
    CallDispatchHeadNode warnMethod = CallDispatchHeadNode.createMethodCall();

    public Object execute(VirtualFrame frame, String ... arguments) {
        String warningMessage = this.concatArgumentsToString(arguments);
        DynamicObject warningString = this.createString(warningMessage.getBytes(), (Encoding)UTF8Encoding.INSTANCE);
        return this.warnMethod.call(frame, this.getContext().getCoreLibrary().getKernelModule(), "warn", warningString);
    }

    @CompilerDirectives.TruffleBoundary
    private String concatArgumentsToString(String ... arguments) {
        return String.join((CharSequence)"", arguments);
    }
}

