/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmMetadataVersion;
import kotlin.reflect.jvm.internal.impl.load.kotlin.PackageParts;
import kotlin.reflect.jvm.internal.impl.serialization.jvm.JvmPackageTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleMapping {
    @NotNull
    private final Map<String, PackageParts> packageFqName2Parts;
    private final String debugName;
    @JvmField
    @NotNull
    public static final String MAPPING_FILE_EXT = "kotlin_module";
    @JvmField
    @NotNull
    public static final ModuleMapping EMPTY;
    public static final Companion Companion;

    @Nullable
    public final PackageParts findPackageParts(@NotNull String packageFqName) {
        Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
        return this.packageFqName2Parts.get(packageFqName);
    }

    @NotNull
    public String toString() {
        return this.debugName;
    }

    @NotNull
    public final Map<String, PackageParts> getPackageFqName2Parts() {
        return this.packageFqName2Parts;
    }

    private ModuleMapping(Map<String, PackageParts> packageFqName2Parts, String debugName) {
        this.packageFqName2Parts = packageFqName2Parts;
        this.debugName = debugName;
    }

    static {
        Companion = new Companion(null);
        MAPPING_FILE_EXT = MAPPING_FILE_EXT;
        EMPTY = new ModuleMapping(MapsKt.<String, PackageParts>emptyMap(), "EMPTY");
    }

    public /* synthetic */ ModuleMapping(@NotNull Map packageFqName2Parts, @NotNull String debugName, DefaultConstructorMarker $constructor_marker) {
        this(packageFqName2Parts, debugName);
    }

    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ModuleMapping create(@Nullable byte[] proto, @Nullable String debugName) {
            JvmPackageTable.PackageTable parseFrom;
            int[] nArray;
            void size$iv;
            JvmMetadataVersion jvmMetadataVersion;
            if (proto == null) {
                return EMPTY;
            }
            DataInputStream stream = new DataInputStream(new ByteArrayInputStream(proto));
            int n = stream.readInt();
            JvmMetadataVersion jvmMetadataVersion2 = jvmMetadataVersion;
            JvmMetadataVersion jvmMetadataVersion3 = jvmMetadataVersion;
            int[] result$iv = new int[size$iv];
            boolean bl = false;
            void var9_11 = size$iv - true;
            if (bl <= var9_11) {
                void i$iv;
                do {
                    int n2;
                    void var10_13 = ++i$iv;
                    void var11_15 = i$iv;
                    nArray = result$iv;
                    nArray[var11_15] = n2 = stream.readInt();
                } while (i$iv != var9_11);
            }
            nArray = result$iv;
            jvmMetadataVersion2(Arrays.copyOf(nArray, nArray.length));
            JvmMetadataVersion version = jvmMetadataVersion3;
            if (version.isCompatible() && (parseFrom = JvmPackageTable.PackageTable.parseFrom(stream)) != null) {
                void $receiver$iv;
                HashMap<String, PackageParts> packageFqNameParts = MapsKt.hashMapOf(new Pair[0]);
                Iterable i$iv = parseFrom.getPackagePartsList();
                for (Object element$iv : $receiver$iv) {
                    void $receiver$iv2;
                    JvmPackageTable.PackageParts it = (JvmPackageTable.PackageParts)element$iv;
                    String string = it.getPackageFqName();
                    Intrinsics.checkExpressionValueIsNotNull(string, "it.packageFqName");
                    PackageParts packageParts = new PackageParts(string);
                    packageFqNameParts.put(it.getPackageFqName(), packageParts);
                    Iterable iterable = it.getClassNameList();
                    for (Object element$iv2 : $receiver$iv2) {
                        String it2 = (String)element$iv2;
                        packageParts.getParts().add(it2);
                    }
                }
                Map map2 = packageFqNameParts;
                String string = debugName;
                if (string == null) {
                    string = "<unknown>";
                }
                return new ModuleMapping(map2, string, null);
            }
            return EMPTY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

