/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.openide.explorer.view.DragDropUtilities;
import org.openide.explorer.view.ExplorerDnDManager;
import org.openide.explorer.view.TableView;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.util.datatransfer.PasteType;

final class TableViewDropSupport
implements DropTargetListener,
Runnable {
    boolean active = false;
    boolean dropTargetPopupAllowed;
    DropTarget dropTarget;
    int lastIndex = -1;
    protected TableView view;
    protected JTable table;

    public TableViewDropSupport(TableView tableView, JTable jTable) {
        this(tableView, jTable, true);
    }

    public TableViewDropSupport(TableView tableView, JTable jTable, boolean bl) {
        this.view = tableView;
        this.table = jTable;
        this.dropTargetPopupAllowed = bl;
    }

    public void setDropTargetPopupAllowed(boolean bl) {
        this.dropTargetPopupAllowed = bl;
    }

    public boolean isDropTargetPopupAllowed() {
        return this.dropTargetPopupAllowed;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        int n = ExplorerDnDManager.getDefault().getAdjustedDropAction(dropTargetDragEvent.getDropAction(), this.view.getAllowedDropActions());
        this.lastIndex = this.indexWithCheck(dropTargetDragEvent);
        if (this.lastIndex < 0) {
            dropTargetDragEvent.rejectDrag();
        } else {
            dropTargetDragEvent.acceptDrag(n);
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        int n = ExplorerDnDManager.getDefault().getAdjustedDropAction(dropTargetDragEvent.getDropAction(), this.view.getAllowedDropActions());
        int n2 = this.indexWithCheck(dropTargetDragEvent);
        if (n2 < 0) {
            dropTargetDragEvent.rejectDrag();
            if (this.lastIndex >= 0) {
                this.lastIndex = -1;
            }
        } else {
            dropTargetDragEvent.acceptDrag(n);
            if (this.lastIndex != n2) {
                if (this.lastIndex < 0) {
                    this.lastIndex = n2;
                }
                this.lastIndex = n2;
            }
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        if (this.lastIndex >= 0) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        boolean bl = true;
        try {
            int n = this.table.rowAtPoint(dropTargetDropEvent.getLocation());
            Node node = this.view.getNodeFromRow(n);
            int n2 = ExplorerDnDManager.getDefault().getAdjustedDropAction(dropTargetDropEvent.getDropAction(), this.view.getAllowedDropActions());
            if (n < 0 || !this.canDrop(node, n2)) {
                dropTargetDropEvent.rejectDrop();
                return;
            }
            PasteType pasteType = null;
            if (pasteType == null) {
                bl = false;
                RequestProcessor.getDefault().post((Runnable)this, 500);
                return;
            }
            dropTargetDropEvent.acceptDrop(n2);
            if (n2 == 0x40000000) {
            } else {
                DragDropUtilities.performPaste(pasteType, null);
            }
        }
        finally {
            dropTargetDropEvent.dropComplete(bl);
        }
    }

    private boolean canDrop(Node node, int n) {
        Object object;
        if (node == null) {
            return false;
        }
        if (ExplorerDnDManager.getDefault().getNodeAllowedActions() == 0) {
            return false;
        }
        if ((2 & n) != 0 && (object = ExplorerDnDManager.getDefault().getDraggedNodes()) != null) {
            for (int i = 0; i < ((Node[])object).length; ++i) {
                if (!node.equals((Object)object[i].getParentNode())) continue;
                return false;
            }
        }
        if ((object = ExplorerDnDManager.getDefault().getDraggedTransferable((2 & n) != 0)) == null) {
            return false;
        }
        Object var4_5 = null;
        return var4_5 != null;
    }

    public void activate(boolean bl) {
        if (this.active == bl) {
            return;
        }
        this.active = bl;
        this.getDropTarget().setActive(bl);
    }

    @Override
    public void run() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this);
            return;
        }
        DragDropUtilities.dropNotSuccesfull();
    }

    int indexWithCheck(DropTargetDragEvent dropTargetDragEvent) {
        int n = ExplorerDnDManager.getDefault().getAdjustedDropAction(dropTargetDragEvent.getDropAction(), this.view.getAllowedDropActions());
        if ((n & this.view.getAllowedDropActions()) == 0) {
            return -1;
        }
        int n2 = this.table.rowAtPoint(dropTargetDragEvent.getLocation());
        if (n2 == -1) {
            return -1;
        }
        Node node = this.view.getNodeFromRow(n2);
        if (n2 < 0) {
            return -1;
        }
        if (!(node instanceof Node)) {
            return -1;
        }
        return n2;
    }

    DropTarget getDropTarget() {
        if (this.dropTarget == null) {
            this.dropTarget = new DropTarget(this.table, this.view.getAllowedDropActions(), this, false);
        }
        return this.dropTarget;
    }
}

