/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.thread;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jruby.truffle.core.basicobject.BasicObjectLayoutImpl;
import org.jruby.truffle.core.thread.ThreadBacktraceLocationLayout;
import org.jruby.truffle.language.backtrace.Activation;

@GeneratedBy(value=ThreadBacktraceLocationLayout.class)
public class ThreadBacktraceLocationLayoutImpl
extends BasicObjectLayoutImpl
implements ThreadBacktraceLocationLayout {
    public static final ThreadBacktraceLocationLayout INSTANCE = new ThreadBacktraceLocationLayoutImpl();
    protected static final Shape.Allocator THREAD_BACKTRACE_LOCATION_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey ACTIVATION_IDENTIFIER = new HiddenKey("activation");
    protected static final Property ACTIVATION_PROPERTY = Property.create(ACTIVATION_IDENTIFIER, THREAD_BACKTRACE_LOCATION_ALLOCATOR.locationForType(Activation.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), 0);

    protected ThreadBacktraceLocationLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createThreadBacktraceLocationShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape(new ThreadBacktraceLocationType(logicalClass, metaClass)).addProperty(ACTIVATION_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createThreadBacktraceLocation(DynamicObjectFactory factory, Activation activation) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant(factory);
        assert (ThreadBacktraceLocationLayoutImpl.createsThreadBacktraceLocation(factory));
        assert (factory.getShape().hasProperty(ACTIVATION_IDENTIFIER));
        assert (activation != null);
        return factory.newInstance(activation);
    }

    private static boolean isThreadBacktraceLocation(DynamicObject object) {
        return ThreadBacktraceLocationLayoutImpl.isThreadBacktraceLocation(object.getShape().getObjectType());
    }

    private static boolean isThreadBacktraceLocation(ObjectType objectType) {
        return objectType instanceof ThreadBacktraceLocationType;
    }

    private static boolean createsThreadBacktraceLocation(DynamicObjectFactory factory) {
        return ThreadBacktraceLocationLayoutImpl.isThreadBacktraceLocation(factory.getShape().getObjectType());
    }

    @Override
    public Activation getActivation(DynamicObject object) {
        assert (ThreadBacktraceLocationLayoutImpl.isThreadBacktraceLocation(object));
        assert (object.getShape().hasProperty(ACTIVATION_IDENTIFIER));
        return (Activation)ACTIVATION_PROPERTY.get(object, ThreadBacktraceLocationLayoutImpl.isThreadBacktraceLocation(object));
    }

    public static class ThreadBacktraceLocationType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public ThreadBacktraceLocationType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public ThreadBacktraceLocationType setLogicalClass(DynamicObject logicalClass) {
            return new ThreadBacktraceLocationType(logicalClass, this.metaClass);
        }

        @Override
        public ThreadBacktraceLocationType setMetaClass(DynamicObject metaClass) {
            return new ThreadBacktraceLocationType(this.logicalClass, metaClass);
        }
    }
}

