/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.styleelement;

import java.util.Objects;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.styleelement.MapImage;
import org.openstreetmap.josm.gui.mappaint.styleelement.NodeElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.StyleElement;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class RepeatImageElement
extends StyleElement {
    public MapImage pattern;
    public float offset;
    public float spacing;
    public float phase;
    public LineImageAlignment align;
    private static final String[] REPEAT_IMAGE_KEYS = new String[]{"repeat-image", "repeat-image-width", "repeat-image-height", "repeat-image-opacity", null, null};

    public RepeatImageElement(Cascade cascade, MapImage mapImage, float f, float f2, float f3, LineImageAlignment lineImageAlignment) {
        super(cascade, 2.9f);
        CheckParameterUtil.ensureParameterNotNull(mapImage);
        CheckParameterUtil.ensureParameterNotNull((Object)lineImageAlignment);
        this.pattern = mapImage;
        this.offset = f;
        this.spacing = f2;
        this.phase = f3;
        this.align = lineImageAlignment;
    }

    public static RepeatImageElement create(Environment environment) {
        MapImage mapImage = NodeElement.createIcon(environment, REPEAT_IMAGE_KEYS);
        if (mapImage == null) {
            return null;
        }
        Cascade cascade = environment.mc.getCascade(environment.layer);
        float f = cascade.get("repeat-image-offset", Float.valueOf(0.0f), Float.class).floatValue();
        float f2 = cascade.get("repeat-image-spacing", Float.valueOf(0.0f), Float.class).floatValue();
        float f3 = -cascade.get("repeat-image-phase", Float.valueOf(0.0f), Float.class).floatValue();
        LineImageAlignment lineImageAlignment = LineImageAlignment.CENTER;
        Keyword keyword = cascade.get("repeat-image-align", Keyword.CENTER, Keyword.class);
        if ("top".equals(keyword.val)) {
            lineImageAlignment = LineImageAlignment.TOP;
        } else if ("bottom".equals(keyword.val)) {
            lineImageAlignment = LineImageAlignment.BOTTOM;
        }
        return new RepeatImageElement(cascade, mapImage, f, f2, f3, lineImageAlignment);
    }

    @Override
    public void paintPrimitive(OsmPrimitive osmPrimitive, MapPaintSettings mapPaintSettings, StyledMapRenderer styledMapRenderer, boolean bl, boolean bl2, boolean bl3) {
        Way way = (Way)osmPrimitive;
        styledMapRenderer.drawRepeatImage(way, this.pattern, styledMapRenderer.isInactiveMode() || way.isDisabled(), this.offset, this.spacing, this.phase, this.align);
    }

    @Override
    public boolean isProperLineStyle() {
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        RepeatImageElement repeatImageElement = (RepeatImageElement)object;
        return Float.compare(repeatImageElement.offset, this.offset) == 0 && Float.compare(repeatImageElement.spacing, this.spacing) == 0 && Float.compare(repeatImageElement.phase, this.phase) == 0 && Objects.equals(this.pattern, repeatImageElement.pattern) && this.align == repeatImageElement.align;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.pattern, Float.valueOf(this.offset), Float.valueOf(this.spacing), Float.valueOf(this.phase), this.align});
    }

    @Override
    public String toString() {
        return "RepeatImageStyle{" + super.toString() + "pattern=[" + this.pattern + "], offset=" + this.offset + ", spacing=" + this.spacing + ", phase=" + -this.phase + ", align=" + (Object)((Object)this.align) + '}';
    }

    public static enum LineImageAlignment {
        TOP(0.5),
        CENTER(0.0),
        BOTTOM(-0.5);

        private final double alignmentOffset;

        private LineImageAlignment(double d) {
            this.alignmentOffset = d;
        }

        public double getAlignmentOffset() {
            return this.alignmentOffset;
        }
    }
}

